/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.cf;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String es = null;
        private int et = 0;
        private long eu = Long.MIN_VALUE;
        private short ev = (short)-1;
        private double ew;
        private double ex;
        private float ey;

        public Builder setRequestId(String requestId) {
            this.es = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.et = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.eu = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.ev = 1;
            this.ew = latitude;
            this.ex = longitude;
            this.ey = radius;
            return this;
        }

        public Geofence build() {
            if (this.es == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.et == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if (this.eu == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.ev == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            return new cf(this.es, this.et, 1, this.ew, this.ex, this.ey, this.eu);
        }
    }
}

