/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class af<K, V> {
    private final LinkedHashMap<K, V> bb;
    private int size;
    private int bc;
    private int bd;
    private int be;
    private int bf;
    private int bg;
    private int bh;

    public af(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.bc = n2;
        this.bb = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        af<K, V> af2 = this;
        synchronized (af2) {
            object = this.bb.get(key);
            if (object != null) {
                ++this.bg;
                return object;
            }
            ++this.bh;
        }
        af2 = this.create(key);
        if (af2 == null) {
            return null;
        }
        af af3 = this;
        synchronized (af3) {
            ++this.be;
            object = this.bb.put(key, af2);
            if (object != null) {
                this.bb.put(key, object);
            } else {
                this.size += this.c(key, af2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, af2, object);
            return object;
        }
        this.trimToSize(this.bc);
        return (V)af2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v2;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        af af2 = this;
        synchronized (af2) {
            ++this.bd;
            this.size += this.c(key, value);
            v2 = this.bb.put(key, value);
            if (v2 != null) {
                this.size -= this.c(key, v2);
            }
        }
        if (v2 != null) {
            this.entryRemoved(false, key, v2, value);
        }
        this.trimToSize(this.bc);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v2;
            K k2;
            af af2 = this;
            synchronized (af2) {
                if (this.size < 0 || this.bb.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.bb.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.bb.entrySet().iterator().next();
                k2 = entry.getKey();
                v2 = entry.getValue();
                this.bb.remove(k2);
                this.size -= this.c(k2, v2);
                ++this.bf;
            }
            this.entryRemoved(true, k2, v2, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int c(K k2, V v2) {
        int n2 = this.sizeOf(k2, v2);
        if (n2 < 0) {
            throw new IllegalStateException("Negative size: " + k2 + "=" + v2);
        }
        return n2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n2 = this.bg + this.bh;
        int n3 = n2 != 0 ? 100 * this.bg / n2 : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.bc, this.bg, this.bh, n3);
    }
}

