/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.w;
import com.google.android.gms.internal.x;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvitationEntity
implements Invitation {
    private final GameEntity dE;
    private final String dF;
    private final long dG;
    private final int dH;
    private final Participant dI;
    private final ArrayList<Participant> dJ;
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new Parcelable.Creator<InvitationEntity>(){

        public InvitationEntity p(Parcel parcel) {
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l2 = parcel.readLong();
            int n2 = parcel.readInt();
            Participant participant = (Participant)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<Object> arrayList = new ArrayList<Object>(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                arrayList.add(ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new InvitationEntity(gameEntity, string, l2, n2, participant, arrayList);
        }

        public InvitationEntity[] C(int n2) {
            return new InvitationEntity[n2];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.C(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.p(x0);
        }
    };

    public InvitationEntity(Invitation invitation) {
        this.dE = new GameEntity(invitation.getGame());
        this.dF = invitation.getInvitationId();
        this.dG = invitation.getCreationTimestamp();
        this.dH = invitation.getInvitationType();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.dJ = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.dJ.add((Participant)participant2.freeze());
        }
        x.b(participant, (Object)"Must have a valid inviter!");
        this.dI = (Participant)participant.freeze();
    }

    @Override
    public Game getGame() {
        return this.dE;
    }

    @Override
    public String getInvitationId() {
        return this.dF;
    }

    @Override
    public Participant getInviter() {
        return this.dI;
    }

    @Override
    public long getCreationTimestamp() {
        return this.dG;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return this.dJ;
    }

    @Override
    public int getInvitationType() {
        return this.dH;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    public static int a(Invitation invitation) {
        return w.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    public static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return w.a(invitation2.getGame(), invitation.getGame()) && w.a(invitation2.getInvitationId(), invitation.getInvitationId()) && w.a(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && w.a(invitation2.getInvitationType(), invitation.getInvitationType()) && w.a(invitation2.getInviter(), invitation.getInviter()) && w.a(invitation2.getParticipants(), invitation.getParticipants());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    public static String b(Invitation invitation) {
        return w.c(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.getInvitationType()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).toString();
    }

    public int describeContents() {
        return 0;
    }

    private InvitationEntity(GameEntity game, String invitationId, long creationTimestamp, int invitationType, Participant inviter, ArrayList<Participant> participants) {
        this.dE = game;
        this.dF = invitationId;
        this.dG = creationTimestamp;
        this.dH = invitationType;
        this.dI = inviter;
        this.dJ = participants;
    }

    public void writeToParcel(Parcel dest, int flags) {
        this.dE.writeToParcel(dest, flags);
        dest.writeString(this.dF);
        dest.writeLong(this.dG);
        dest.writeInt(this.dH);
        this.dI.writeToParcel(dest, flags);
        int n2 = this.dJ.size();
        dest.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.dJ.get(i2).writeToParcel(dest, flags);
        }
    }
}

