/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.internal.af;
import com.google.android.gms.internal.ba;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ImageManager {
    private static ImageManager ai;
    private final Context mContext;
    private final af<Uri, WeakReference<Drawable.ConstantState>> aj;
    private final Map<ListenerHolder, ImageReceiver> ak;
    private final Map<Uri, ImageReceiver> al;

    public static ImageManager create(Context context) {
        if (ai == null) {
            ai = new ImageManager(context);
        }
        return ai;
    }

    private ImageManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.aj = new af(50);
        if (ba.ad()) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new c(this.aj));
        }
        this.ak = new HashMap<ListenerHolder, ImageReceiver>();
        this.al = new HashMap<Uri, ImageReceiver>();
    }

    public void loadImage(ImageView imageView, Uri uri) {
        this.loadImage(imageView, uri, 0);
    }

    public void loadImage(ImageView imageView, int resId) {
        this.loadImage(imageView, null, resId);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        this.a(new b(imageView, defaultResId), uri);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        this.loadImage(listener, uri, 0);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        this.a(new a(listener, defaultResId), uri);
    }

    private void a(ListenerHolder listenerHolder, Uri uri) {
        Drawable.ConstantState constantState;
        Object object;
        if (uri != null && (object = this.aj.get(uri)) != null && (constantState = (Drawable.ConstantState)object.get()) != null) {
            listenerHolder.handleCachedDrawable(uri, constantState.newDrawable());
            return;
        }
        if (!listenerHolder.shouldLoadImage(uri)) {
            return;
        }
        object = this.al.get(uri);
        if (object == null) {
            object = new ImageReceiver(uri);
            this.al.put(uri, (ImageReceiver)((Object)object));
        }
        ((ImageReceiver)((Object)object)).addOnImageLoadedListenerHolder(listenerHolder);
        this.ak.put(listenerHolder, (ImageReceiver)((Object)object));
        constantState = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
        constantState.putExtra("com.google.android.gms.extras.uri", (Parcelable)uri);
        constantState.putExtra("com.google.android.gms.extras.resultReceiver", object);
        constantState.putExtra("com.google.android.gms.extras.priority", 3);
        this.mContext.sendBroadcast((Intent)constantState);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class c
    implements ComponentCallbacks2 {
        private final af<Uri, WeakReference<Drawable.ConstantState>> aq;

        public c(af<Uri, WeakReference<Drawable.ConstantState>> af2) {
            this.aq = af2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.aq.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.aq.evictAll();
            } else if (level >= 40) {
                this.aq.trimToSize(this.aq.size() / 2);
            }
        }
    }

    final class b
    extends ListenerHolder {
        private final WeakReference<ImageView> ap;

        private b(ImageView imageView, int n2) {
            super(imageView.hashCode(), n2);
            this.ap = new WeakReference<ImageView>(imageView);
        }

        public void handleCachedDrawable(Uri uri, Drawable drawable2) {
            ImageReceiver imageReceiver;
            ImageView imageView = (ImageView)this.ap.get();
            if (imageView != null) {
                imageView.setImageDrawable(drawable2);
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.ak.remove(this))) != null) {
                imageReceiver.removeOnImageLoadedListenerHolder(this);
            }
        }

        public boolean shouldLoadImage(Uri uri) {
            ImageView imageView = (ImageView)this.ap.get();
            if (imageView != null) {
                if (this.mDefaultResId == 0) {
                    imageView.setImageDrawable(null);
                } else {
                    imageView.setImageResource(this.mDefaultResId);
                }
            }
            if (uri == null) {
                ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.ak.remove(this));
                if (imageReceiver != null) {
                    imageReceiver.removeOnImageLoadedListenerHolder(this);
                }
                return false;
            }
            return true;
        }

        public void onImageLoaded(Uri uri, Drawable drawable2) {
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.ak.remove(this));
            ImageView imageView = (ImageView)this.ap.get();
            if (imageView == null) {
                return;
            }
            if (imageReceiver != null && imageReceiver.getUri().equals((Object)uri)) {
                imageView.setImageDrawable(drawable2);
            }
        }

        public boolean equals(Object o2) {
            if (o2 instanceof b) {
                b b2 = (b)o2;
                return this.ap != null && b2.ap != null && this.mHashCode == b2.mHashCode;
            }
            return false;
        }
    }

    final class a
    extends ListenerHolder {
        private final WeakReference<OnImageLoadedListener> am;

        private a(OnImageLoadedListener onImageLoadedListener, int n2) {
            super(onImageLoadedListener.hashCode(), n2);
            this.am = new WeakReference<OnImageLoadedListener>(onImageLoadedListener);
        }

        public void handleCachedDrawable(Uri uri, Drawable drawable2) {
            OnImageLoadedListener onImageLoadedListener = (OnImageLoadedListener)this.am.get();
            if (onImageLoadedListener != null) {
                onImageLoadedListener.onImageLoaded(uri, drawable2);
            }
        }

        public boolean shouldLoadImage(Uri uri) {
            if (uri == null) {
                OnImageLoadedListener onImageLoadedListener = (OnImageLoadedListener)this.am.get();
                if (onImageLoadedListener != null) {
                    if (this.mDefaultResId == 0) {
                        onImageLoadedListener.onImageLoaded(uri, null);
                    } else {
                        onImageLoadedListener.onImageLoaded(uri, ImageManager.this.mContext.getResources().getDrawable(this.mDefaultResId));
                    }
                }
                return false;
            }
            return true;
        }

        public void onImageLoaded(Uri uri, Drawable drawable2) {
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.ak.remove(this));
            OnImageLoadedListener onImageLoadedListener = (OnImageLoadedListener)this.am.get();
            if (onImageLoadedListener != null) {
                onImageLoadedListener.onImageLoaded(uri, drawable2);
            }
        }

        public boolean equals(Object o2) {
            if (o2 instanceof a) {
                a a2 = (a)o2;
                return this.am != null && a2.am != null && this.mHashCode == a2.mHashCode;
            }
            return false;
        }
    }

    abstract class ListenerHolder
    implements OnImageLoadedListener {
        protected final int mHashCode;
        protected final int mDefaultResId;

        private ListenerHolder(int hashCode, int defaultResId) {
            this.mHashCode = hashCode;
            this.mDefaultResId = defaultResId;
        }

        public abstract void handleCachedDrawable(Uri var1, Drawable var2);

        public abstract boolean shouldLoadImage(Uri var1);

        public abstract void onImageLoaded(Uri var1, Drawable var2);

        public int hashCode() {
            return this.mHashCode;
        }
    }

    public final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<ListenerHolder> ao;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.ao = new ArrayList();
        }

        public void addOnImageLoadedListenerHolder(ListenerHolder imageViewLoadListener) {
            this.ao.add(imageViewLoadListener);
        }

        public void removeOnImageLoadedListenerHolder(ListenerHolder imageViewLoadListener) {
            this.ao.remove(imageViewLoadListener);
        }

        public Uri getUri() {
            return this.mUri;
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            BitmapDrawable bitmapDrawable = null;
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            if (parcelFileDescriptor != null) {
                Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)parcelFileDescriptor.getFileDescriptor());
                try {
                    parcelFileDescriptor.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
                bitmapDrawable = new BitmapDrawable(ImageManager.this.mContext.getResources(), bitmap);
                ImageManager.this.aj.put(this.mUri, new WeakReference<Drawable.ConstantState>(bitmapDrawable.getConstantState()));
            }
            ImageManager.this.al.remove(this.mUri);
            int n2 = this.ao.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.ao.get(i2).onImageLoaded(this.mUri, (Drawable)bitmapDrawable);
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2);
    }
}

