/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.RequestHandler;
import com.squareup.picasso.Utils;
import java.io.IOException;

class ResourceRequestHandler
extends RequestHandler {
    private final Context context;

    ResourceRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request data) {
        if (data.resourceId != 0) {
            return true;
        }
        return "android.resource".equals(data.uri.getScheme());
    }

    @Override
    public RequestHandler.Result load(Request data) throws IOException {
        Resources res = Utils.getResources(this.context, data);
        int id = Utils.getResourceId(res, data);
        return new RequestHandler.Result(ResourceRequestHandler.decodeResource(res, id, data), Picasso.LoadedFrom.DISK);
    }

    private static Bitmap decodeResource(Resources resources, int id, Request data) {
        BitmapFactory.Options options = ResourceRequestHandler.createBitmapOptions(data);
        if (ResourceRequestHandler.requiresInSampleSize(options)) {
            BitmapFactory.decodeResource((Resources)resources, (int)id, (BitmapFactory.Options)options);
            ResourceRequestHandler.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)id, (BitmapFactory.Options)options);
    }
}

