/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.NetworkInfo;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.MarkableInputStream;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.RequestHandler;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class NetworkRequestHandler
extends RequestHandler {
    static final int RETRY_COUNT = 2;
    private static final int MARKER = 65536;
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private final Downloader downloader;
    private final Stats stats;

    public NetworkRequestHandler(Downloader downloader, Stats stats) {
        this.downloader = downloader;
        this.stats = stats;
    }

    @Override
    public boolean canHandleRequest(Request data) {
        String scheme = data.uri.getScheme();
        return SCHEME_HTTP.equals(scheme) || SCHEME_HTTPS.equals(scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestHandler.Result load(Request data) throws IOException {
        Downloader.Response response = this.downloader.load(data.uri, data.loadFromLocalCacheOnly);
        if (response == null) {
            return null;
        }
        Picasso.LoadedFrom loadedFrom = response.cached ? Picasso.LoadedFrom.DISK : Picasso.LoadedFrom.NETWORK;
        Bitmap bitmap = response.getBitmap();
        if (bitmap != null) {
            return new RequestHandler.Result(bitmap, loadedFrom);
        }
        InputStream is = response.getInputStream();
        if (is == null) {
            return null;
        }
        if (response.getContentLength() == 0L) {
            Utils.closeQuietly(is);
            throw new IOException("Received response with 0 content-length header.");
        }
        if (loadedFrom == Picasso.LoadedFrom.NETWORK && response.getContentLength() > 0L) {
            this.stats.dispatchDownloadFinished(response.getContentLength());
        }
        try {
            RequestHandler.Result result = new RequestHandler.Result(this.decodeStream(is, data), loadedFrom);
            return result;
        }
        finally {
            Utils.closeQuietly(is);
        }
    }

    @Override
    int getRetryCount() {
        return 2;
    }

    @Override
    boolean shouldRetry(boolean airplaneMode, NetworkInfo info) {
        return info == null || info.isConnected();
    }

    @Override
    boolean supportsReplay() {
        return true;
    }

    private Bitmap decodeStream(InputStream stream, Request data) throws IOException {
        Bitmap bitmap;
        MarkableInputStream markStream = new MarkableInputStream(stream);
        stream = markStream;
        long mark = markStream.savePosition(65536);
        BitmapFactory.Options options = NetworkRequestHandler.createBitmapOptions(data);
        boolean calculateSize = NetworkRequestHandler.requiresInSampleSize(options);
        boolean isWebPFile = Utils.isWebPFile(stream);
        markStream.reset(mark);
        if (isWebPFile) {
            byte[] bytes = Utils.toByteArray(stream);
            if (calculateSize) {
                BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
                NetworkRequestHandler.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
            }
            return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        }
        if (calculateSize) {
            BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
            NetworkRequestHandler.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
            markStream.reset(mark);
        }
        if ((bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options)) == null) {
            throw new IOException("Failed to decode stream.");
        }
        return bitmap;
    }
}

