/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.RequestHandler;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class ContentStreamRequestHandler
extends RequestHandler {
    final Context context;

    ContentStreamRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request data) {
        return "content".equals(data.uri.getScheme());
    }

    @Override
    public RequestHandler.Result load(Request data) throws IOException {
        return new RequestHandler.Result(this.decodeContentStream(data), Picasso.LoadedFrom.DISK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap decodeContentStream(Request data) throws IOException {
        InputStream is;
        ContentResolver contentResolver = this.context.getContentResolver();
        BitmapFactory.Options options = ContentStreamRequestHandler.createBitmapOptions(data);
        if (ContentStreamRequestHandler.requiresInSampleSize(options)) {
            is = null;
            try {
                is = contentResolver.openInputStream(data.uri);
                BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            }
            finally {
                Utils.closeQuietly(is);
            }
            ContentStreamRequestHandler.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
        }
        is = contentResolver.openInputStream(data.uri);
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            Utils.closeQuietly(is);
        }
    }
}

