/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.UriMatcher;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.RequestHandler;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class ContactsPhotoRequestHandler
extends RequestHandler {
    private static final int ID_LOOKUP = 1;
    private static final int ID_THUMBNAIL = 2;
    private static final int ID_CONTACT = 3;
    private static final int ID_DISPLAY_PHOTO = 4;
    private static final UriMatcher matcher = new UriMatcher(-1);
    final Context context;

    ContactsPhotoRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request data) {
        Uri uri = data.uri;
        return "content".equals(uri.getScheme()) && ContactsContract.Contacts.CONTENT_URI.getHost().equals(uri.getHost()) && !uri.getPathSegments().contains("photo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestHandler.Result load(Request data) throws IOException {
        InputStream is = null;
        try {
            is = this.getInputStream(data);
            RequestHandler.Result result = new RequestHandler.Result(this.decodeStream(is, data), Picasso.LoadedFrom.DISK);
            return result;
        }
        finally {
            Utils.closeQuietly(is);
        }
    }

    private InputStream getInputStream(Request data) throws IOException {
        ContentResolver contentResolver = this.context.getContentResolver();
        Uri uri = data.uri;
        switch (matcher.match(uri)) {
            case 1: {
                uri = ContactsContract.Contacts.lookupContact((ContentResolver)contentResolver, (Uri)uri);
                if (uri == null) {
                    return null;
                }
            }
            case 3: {
                if (Build.VERSION.SDK_INT < 14) {
                    return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri);
                }
                return ContactPhotoStreamIcs.get(contentResolver, uri);
            }
            case 2: 
            case 4: {
                return contentResolver.openInputStream(uri);
            }
        }
        throw new IllegalStateException("Invalid uri: " + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap decodeStream(InputStream stream, Request data) throws IOException {
        if (stream == null) {
            return null;
        }
        BitmapFactory.Options options = ContactsPhotoRequestHandler.createBitmapOptions(data);
        if (ContactsPhotoRequestHandler.requiresInSampleSize(options)) {
            InputStream is = this.getInputStream(data);
            try {
                BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            }
            finally {
                Utils.closeQuietly(is);
            }
            ContactsPhotoRequestHandler.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
        }
        return BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
    }

    static {
        matcher.addURI("com.android.contacts", "contacts/lookup/*/#", 1);
        matcher.addURI("com.android.contacts", "contacts/lookup/*", 1);
        matcher.addURI("com.android.contacts", "contacts/#/photo", 2);
        matcher.addURI("com.android.contacts", "contacts/#", 3);
        matcher.addURI("com.android.contacts", "display_photo/#", 4);
    }

    @TargetApi(value=14)
    private static class ContactPhotoStreamIcs {
        private ContactPhotoStreamIcs() {
        }

        static InputStream get(ContentResolver contentResolver, Uri uri) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri, (boolean)true);
        }
    }
}

