/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.RequestHandler;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class AssetRequestHandler
extends RequestHandler {
    protected static final String ANDROID_ASSET = "android_asset";
    private static final int ASSET_PREFIX_LENGTH = "file:///android_asset/".length();
    private final AssetManager assetManager;

    public AssetRequestHandler(Context context) {
        this.assetManager = context.getAssets();
    }

    @Override
    public boolean canHandleRequest(Request data) {
        Uri uri = data.uri;
        return "file".equals(uri.getScheme()) && !uri.getPathSegments().isEmpty() && ANDROID_ASSET.equals(uri.getPathSegments().get(0));
    }

    @Override
    public RequestHandler.Result load(Request data) throws IOException {
        String filePath = data.uri.toString().substring(ASSET_PREFIX_LENGTH);
        return new RequestHandler.Result(this.decodeAsset(data, filePath), Picasso.LoadedFrom.DISK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap decodeAsset(Request data, String filePath) throws IOException {
        InputStream is;
        BitmapFactory.Options options = AssetRequestHandler.createBitmapOptions(data);
        if (AssetRequestHandler.requiresInSampleSize(options)) {
            is = null;
            try {
                is = this.assetManager.open(filePath);
                BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            }
            finally {
                Utils.closeQuietly(is);
            }
            AssetRequestHandler.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
        }
        is = this.assetManager.open(filePath);
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            Utils.closeQuietly(is);
        }
    }
}

