/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;

public class DeliveryReceiptManager
implements PacketListener {
    private static Map<Connection, DeliveryReceiptManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private Connection connection;
    private boolean auto_receipts_enabled = false;
    private Set<ReceiptReceivedListener> receiptReceivedListeners = Collections.synchronizedSet(new HashSet());

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                DeliveryReceiptManager.getInstanceFor(connection);
            }
        });
    }

    private DeliveryReceiptManager(Connection connection) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        serviceDiscoveryManager.addFeature("urn:xmpp:receipts");
        this.connection = connection;
        instances.put(connection, this);
        connection.addPacketListener(this, new PacketExtensionFilter("urn:xmpp:receipts"));
    }

    public static synchronized DeliveryReceiptManager getInstanceFor(Connection connection) {
        DeliveryReceiptManager deliveryReceiptManager = instances.get(connection);
        if (deliveryReceiptManager == null) {
            deliveryReceiptManager = new DeliveryReceiptManager(connection);
        }
        return deliveryReceiptManager;
    }

    public boolean isSupported(String string) {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(string);
            return discoverInfo.containsFeature("urn:xmpp:receipts");
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }

    @Override
    public void processPacket(Packet packet) {
        DeliveryReceiptRequest deliveryReceiptRequest;
        DeliveryReceipt deliveryReceipt = (DeliveryReceipt)packet.getExtension("received", "urn:xmpp:receipts");
        if (deliveryReceipt != null) {
            for (ReceiptReceivedListener object2 : this.receiptReceivedListeners) {
                object2.onReceiptReceived(packet.getFrom(), packet.getTo(), deliveryReceipt.getId());
            }
        }
        if (this.auto_receipts_enabled && (deliveryReceiptRequest = (DeliveryReceiptRequest)packet.getExtension("request", "urn:xmpp:receipts")) != null) {
            Message message = new Message(packet.getFrom(), Message.Type.normal);
            message.addExtension(new DeliveryReceipt(packet.getPacketID()));
            this.connection.sendPacket(message);
        }
    }

    public void setAutoReceiptsEnabled(boolean bl) {
        this.auto_receipts_enabled = bl;
    }

    public void enableAutoReceipts() {
        this.setAutoReceiptsEnabled(true);
    }

    public void disableAutoReceipts() {
        this.setAutoReceiptsEnabled(false);
    }

    public boolean getAutoReceiptsEnabled() {
        return this.auto_receipts_enabled;
    }

    public void addReceiptReceivedListener(ReceiptReceivedListener receiptReceivedListener) {
        this.receiptReceivedListeners.add(receiptReceivedListener);
    }

    public void removeReceiptReceivedListener(ReceiptReceivedListener receiptReceivedListener) {
        this.receiptReceivedListeners.remove(receiptReceivedListener);
    }

    public static boolean hasDeliveryReceiptRequest(Packet packet) {
        return packet.getExtension("request", "urn:xmpp:receipts") != null;
    }

    public static void addDeliveryReceiptRequest(Message message) {
        message.addExtension(new DeliveryReceiptRequest());
    }
}

