/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.lang.ref.WeakReference;
import java.util.Set;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.PingManager;

class ServerPingTask
implements Runnable {
    private WeakReference<Connection> weakConnection;
    private int delta = 1000;
    private int tries = 3;

    protected ServerPingTask(Connection connection) {
        this.weakConnection = new WeakReference<Connection>(connection);
    }

    @Override
    public void run() {
        Connection connection = (Connection)this.weakConnection.get();
        if (connection == null) {
            return;
        }
        if (connection.isAuthenticated()) {
            PingManager pingManager = PingManager.getInstanceFor(connection);
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.tries) {
                if (n2 != 0) {
                    try {
                        Thread.sleep(this.delta);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                if (bl = pingManager.pingMyServer()) {
                    pingManager.lastSuccessfulPingByTask = System.currentTimeMillis();
                    break;
                }
                ++n2;
            }
            if (!bl) {
                Set<PingFailedListener> set = pingManager.getPingFailedListeners();
                for (PingFailedListener pingFailedListener : set) {
                    pingFailedListener.pingFailed();
                }
            } else {
                pingManager.maybeSchedulePingServerTask();
            }
        }
    }
}

