/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.ServerPingTask;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.jivesoftware.smackx.ping.packet.Pong;

public class PingManager {
    public static final String NAMESPACE = "urn:xmpp:ping";
    public static final String ELEMENT = "ping";
    private static final Map<Connection, PingManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private static final ScheduledExecutorService periodicPingExecutorService = new ScheduledThreadPoolExecutor(1);
    private Connection connection;
    private int pingInterval = SmackConfiguration.getDefaultPingInterval();
    private Set<PingFailedListener> pingFailedListeners = Collections.synchronizedSet(new HashSet());
    private ScheduledFuture<?> periodicPingTask;
    protected volatile long lastSuccessfulPingByTask = -1L;
    private long pingMinDelta = 100L;
    private long lastPingStamp = 0L;
    private long lastSuccessfulManualPing = -1L;

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                PingManager.getInstanceFor(connection);
            }
        });
    }

    private PingManager(final Connection connection) {
        this.connection = connection;
        instances.put(connection, this);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        serviceDiscoveryManager.addFeature(NAMESPACE);
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(Ping.class);
        connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                if (PingManager.this.pingMinDelta > 0L) {
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - PingManager.this.lastPingStamp;
                    PingManager.this.lastPingStamp = l2;
                    if (l3 < PingManager.this.pingMinDelta) {
                        return;
                    }
                }
                Pong pong = new Pong((Ping)packet);
                connection.sendPacket(pong);
            }
        }, packetTypeFilter);
        connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                PingManager.this.maybeStopPingServerTask();
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                PingManager.this.maybeStopPingServerTask();
            }

            @Override
            public void reconnectionSuccessful() {
                PingManager.this.maybeSchedulePingServerTask();
            }

            @Override
            public void reconnectingIn(int n2) {
            }

            @Override
            public void reconnectionFailed(Exception exception) {
            }
        });
        this.maybeSchedulePingServerTask();
    }

    public static synchronized PingManager getInstanceFor(Connection connection) {
        PingManager pingManager = instances.get(connection);
        if (pingManager == null) {
            pingManager = new PingManager(connection);
        }
        return pingManager;
    }

    public void setPingIntervall(int n2) {
        this.pingInterval = n2;
    }

    public int getPingIntervall() {
        return this.pingInterval;
    }

    public void registerPingFailedListener(PingFailedListener pingFailedListener) {
        this.pingFailedListeners.add(pingFailedListener);
    }

    public void unregisterPingFailedListener(PingFailedListener pingFailedListener) {
        this.pingFailedListeners.remove(pingFailedListener);
    }

    public void disablePingFloodProtection() {
        this.setPingMinimumInterval(-1L);
    }

    public void setPingMinimumInterval(long l2) {
        this.pingMinDelta = l2;
    }

    public long getPingMinimumInterval() {
        return this.pingMinDelta;
    }

    public IQ ping(String string, long l2) {
        if (!this.connection.isAuthenticated()) {
            return null;
        }
        Ping ping = new Ping(this.connection.getUser(), string);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(ping.getPacketID()));
        this.connection.sendPacket(ping);
        IQ iQ = (IQ)packetCollector.nextResult(l2);
        packetCollector.cancel();
        return iQ;
    }

    public IQ ping(String string) {
        return this.ping(string, SmackConfiguration.getPacketReplyTimeout());
    }

    public boolean pingEntity(String string, long l2) {
        IQ iQ = this.ping(string, l2);
        if (iQ == null || iQ.getType() == IQ.Type.ERROR) {
            return false;
        }
        this.pongReceived();
        return true;
    }

    public boolean pingEntity(String string) {
        return this.pingEntity(string, SmackConfiguration.getPacketReplyTimeout());
    }

    public boolean pingMyServer(long l2) {
        IQ iQ = this.ping(this.connection.getServiceName(), l2);
        if (iQ == null) {
            for (PingFailedListener pingFailedListener : this.pingFailedListeners) {
                pingFailedListener.pingFailed();
            }
            return false;
        }
        this.pongReceived();
        return true;
    }

    public boolean pingMyServer() {
        return this.pingMyServer(SmackConfiguration.getPacketReplyTimeout());
    }

    public boolean isPingSupported(String string) {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(string);
            return discoverInfo.containsFeature(NAMESPACE);
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }

    public long getLastSuccessfulPing() {
        return Math.max(this.lastSuccessfulPingByTask, this.lastSuccessfulManualPing);
    }

    protected Set<PingFailedListener> getPingFailedListeners() {
        return this.pingFailedListeners;
    }

    protected synchronized void maybeSchedulePingServerTask() {
        this.maybeStopPingServerTask();
        if (this.pingInterval > 0) {
            this.periodicPingTask = periodicPingExecutorService.schedule(new ServerPingTask(this.connection), (long)this.pingInterval, TimeUnit.SECONDS);
        }
    }

    private void maybeStopPingServerTask() {
        if (this.periodicPingTask != null) {
            this.periodicPingTask.cancel(true);
            this.periodicPingTask = null;
        }
    }

    private void pongReceived() {
        this.lastSuccessfulManualPing = System.currentTimeMillis();
    }
}

