/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import org.jivesoftware.smack.packet.PacketExtension;

public class MUCUser
implements PacketExtension {
    private Invite invite;
    private Decline decline;
    private Apply apply;
    private Accept accept;
    private Item item;
    private String password;
    private Status status;
    private Destroy destroy;

    @Override
    public String getElementName() {
        return "x";
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/muc#user";
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        if (this.getInvite() != null) {
            stringBuilder.append(this.getInvite().toXML());
        }
        if (this.getDecline() != null) {
            stringBuilder.append(this.getDecline().toXML());
        }
        if (this.getApply() != null) {
            stringBuilder.append(this.getApply().toXML());
        }
        if (this.getAccept() != null) {
            stringBuilder.append(this.getAccept().toXML());
        }
        if (this.getItem() != null) {
            stringBuilder.append(this.getItem().toXML());
        }
        if (this.getPassword() != null) {
            stringBuilder.append("<password>").append(this.getPassword()).append("</password>");
        }
        if (this.getStatus() != null) {
            stringBuilder.append(this.getStatus().toXML());
        }
        if (this.getDestroy() != null) {
            stringBuilder.append(this.getDestroy().toXML());
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }

    public Invite getInvite() {
        return this.invite;
    }

    public Apply getApply() {
        return this.apply;
    }

    public Decline getDecline() {
        return this.decline;
    }

    public Item getItem() {
        return this.item;
    }

    public String getPassword() {
        return this.password;
    }

    public Status getStatus() {
        return this.status;
    }

    public Destroy getDestroy() {
        return this.destroy;
    }

    public void setInvite(Invite invite) {
        this.invite = invite;
    }

    public void setApply(Apply apply) {
        this.apply = apply;
    }

    public Accept getAccept() {
        return this.accept;
    }

    public void setAccept(Accept accept) {
        this.accept = accept;
    }

    public void setDecline(Decline decline) {
        this.decline = decline;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setDestroy(Destroy destroy) {
        this.destroy = destroy;
    }

    public static class Accept {
        private String reason;
        private String from;
        private String to;
        private String fromNick;

        public String getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public String getTo() {
            return this.to;
        }

        public void setFrom(String string) {
            this.from = string;
        }

        public void setReason(String string) {
            this.reason = string;
        }

        public void setTo(String string) {
            this.to = string;
        }

        public String getFromNick() {
            return this.fromNick;
        }

        public void setFromNick(String string) {
            this.fromNick = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<accept ");
            if (this.getTo() != null) {
                stringBuilder.append(" to=\"").append(this.getTo()).append("\"");
            }
            if (this.getFrom() != null) {
                stringBuilder.append(" from=\"").append(this.getFrom()).append("\"");
            }
            if (this.getFromNick() != null) {
                stringBuilder.append(" fromNick=\"").append(this.getFromNick()).append("\"");
            }
            stringBuilder.append(">");
            if (this.getReason() != null) {
                stringBuilder.append("<reason>").append(this.getReason()).append("</reason>");
            }
            stringBuilder.append("</accept>");
            return stringBuilder.toString();
        }
    }

    public static class Apply {
        private String reason;
        private String from;
        private String to;
        private String toNick;

        public String getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public String getTo() {
            return this.to;
        }

        public void setFrom(String string) {
            this.from = string;
        }

        public void setReason(String string) {
            this.reason = string;
        }

        public void setTo(String string) {
            this.to = string;
        }

        public String getToNick() {
            return this.toNick;
        }

        public void setToNick(String string) {
            this.toNick = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<apply ");
            if (this.getTo() != null) {
                stringBuilder.append(" to=\"").append(this.getTo()).append("\"");
            }
            if (this.getFrom() != null) {
                stringBuilder.append(" from=\"").append(this.getFrom()).append("\"");
            }
            if (this.getToNick() != null) {
                stringBuilder.append(" toNick=\"").append(this.getToNick()).append("\"");
            }
            stringBuilder.append(">");
            if (this.getReason() != null) {
                stringBuilder.append("<reason>").append(this.getReason()).append("</reason>");
            }
            stringBuilder.append("</apply>");
            return stringBuilder.toString();
        }
    }

    public static class Decline {
        private String reason;
        private String from;
        private String to;
        private String fromNick;
        private MucType type;

        public String getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public String getTo() {
            return this.to;
        }

        public void setFrom(String string) {
            this.from = string;
        }

        public void setReason(String string) {
            this.reason = string;
        }

        public void setTo(String string) {
            this.to = string;
        }

        public String getFromNick() {
            return this.fromNick;
        }

        public void setFromNick(String string) {
            this.fromNick = string;
        }

        public MucType getType() {
            return this.type;
        }

        public void setType(MucType mucType) {
            this.type = mucType;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<decline ");
            if (this.getTo() != null) {
                stringBuilder.append(" to=\"").append(this.getTo()).append("\"");
            }
            if (this.getFrom() != null) {
                stringBuilder.append(" from=\"").append(this.getFrom()).append("\"");
            }
            if (this.getFromNick() != null) {
                stringBuilder.append(" fromNick=\"").append(this.getFromNick()).append("\"");
            }
            if (this.getType() != null) {
                stringBuilder.append(" type=\"").append(this.getType().toString()).append("\"");
            }
            stringBuilder.append(">");
            if (this.getReason() != null) {
                stringBuilder.append("<reason>").append(this.getReason()).append("</reason>");
            }
            stringBuilder.append("</decline>");
            return stringBuilder.toString();
        }
    }

    public static class Destroy {
        private String reason;
        private String jid;

        public String getJid() {
            return this.jid;
        }

        public String getReason() {
            return this.reason;
        }

        public void setJid(String string) {
            this.jid = string;
        }

        public void setReason(String string) {
            this.reason = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<destroy");
            if (this.getJid() != null) {
                stringBuilder.append(" jid=\"").append(this.getJid()).append("\"");
            }
            if (this.getReason() == null) {
                stringBuilder.append("/>");
            } else {
                stringBuilder.append(">");
                if (this.getReason() != null) {
                    stringBuilder.append("<reason>").append(this.getReason()).append("</reason>");
                }
                stringBuilder.append("</destroy>");
            }
            return stringBuilder.toString();
        }
    }

    public static class Invite {
        private String reason;
        private String from;
        private String to;

        public String getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public String getTo() {
            return this.to;
        }

        public void setFrom(String string) {
            this.from = string;
        }

        public void setReason(String string) {
            this.reason = string;
        }

        public void setTo(String string) {
            this.to = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<invite ");
            if (this.getTo() != null) {
                stringBuilder.append(" to=\"").append(this.getTo()).append("\"");
            }
            if (this.getFrom() != null) {
                stringBuilder.append(" from=\"").append(this.getFrom()).append("\"");
            }
            stringBuilder.append(">");
            if (this.getReason() != null) {
                stringBuilder.append("<reason>").append(this.getReason()).append("</reason>");
            }
            stringBuilder.append("</invite>");
            return stringBuilder.toString();
        }
    }

    public static class Item {
        private String actor;
        private String reason;
        private String affiliation;
        private String jid;
        private String nick;
        private String role;

        public Item(String string, String string2) {
            this.affiliation = string;
            this.role = string2;
        }

        public String getActor() {
            return this.actor == null ? "" : this.actor;
        }

        public String getReason() {
            return this.reason == null ? "" : this.reason;
        }

        public String getAffiliation() {
            return this.affiliation;
        }

        public String getJid() {
            return this.jid;
        }

        public String getNick() {
            return this.nick;
        }

        public String getRole() {
            return this.role;
        }

        public void setActor(String string) {
            this.actor = string;
        }

        public void setReason(String string) {
            this.reason = string;
        }

        public void setJid(String string) {
            this.jid = string;
        }

        public void setNick(String string) {
            this.nick = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<item");
            if (this.getAffiliation() != null) {
                stringBuilder.append(" affiliation=\"").append(this.getAffiliation()).append("\"");
            }
            if (this.getJid() != null) {
                stringBuilder.append(" jid=\"").append(this.getJid()).append("\"");
            }
            if (this.getNick() != null) {
                stringBuilder.append(" nick=\"").append(this.getNick()).append("\"");
            }
            if (this.getRole() != null) {
                stringBuilder.append(" role=\"").append(this.getRole()).append("\"");
            }
            if (this.getReason() == null && this.getActor() == null) {
                stringBuilder.append("/>");
            } else {
                stringBuilder.append(">");
                if (this.getReason() != null) {
                    stringBuilder.append("<reason>").append(this.getReason()).append("</reason>");
                }
                if (this.getActor() != null) {
                    stringBuilder.append("<actor jid=\"").append(this.getActor()).append("\"/>");
                }
                stringBuilder.append("</item>");
            }
            return stringBuilder.toString();
        }
    }

    public static enum MucType {
        Invite,
        Apply;

    }

    public static class Status {
        private String code;

        public Status(String string) {
            this.code = string;
        }

        public String getCode() {
            return this.code;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<status code=\"").append(this.getCode()).append("\"/>");
            return stringBuilder.toString();
        }
    }
}

