/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;

public class MUCOwner
extends IQ {
    private List<Item> items = new ArrayList<Item>();
    private Destroy destroy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.items)).iterator();
        }
    }

    public Destroy getDestroy() {
        return this.destroy;
    }

    public void setDestroy(Destroy destroy) {
        this.destroy = destroy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"http://jabber.org/protocol/muc#owner\">");
        List<Item> list = this.items;
        synchronized (list) {
            int n2 = 0;
            while (n2 < this.items.size()) {
                Item item = this.items.get(n2);
                stringBuilder.append(item.toXML());
                ++n2;
            }
        }
        if (this.getDestroy() != null) {
            stringBuilder.append(this.getDestroy().toXML());
        }
        stringBuilder.append(this.getExtensionsXML());
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }

    public static class Destroy {
        private String reason;
        private String jid;

        public String getJid() {
            return this.jid;
        }

        public String getReason() {
            return this.reason;
        }

        public void setJid(String string) {
            this.jid = string;
        }

        public void setReason(String string) {
            this.reason = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<destroy");
            if (this.getJid() != null) {
                stringBuilder.append(" jid=\"").append(this.getJid()).append("\"");
            }
            if (this.getReason() == null) {
                stringBuilder.append("/>");
            } else {
                stringBuilder.append(">");
                if (this.getReason() != null) {
                    stringBuilder.append("<reason>").append(this.getReason()).append("</reason>");
                }
                stringBuilder.append("</destroy>");
            }
            return stringBuilder.toString();
        }
    }

    public static class Item {
        private String actor;
        private String reason;
        private String affiliation;
        private String jid;
        private String nick;
        private String role;

        public Item(String string) {
            this.affiliation = string;
        }

        public String getActor() {
            return this.actor;
        }

        public String getReason() {
            return this.reason;
        }

        public String getAffiliation() {
            return this.affiliation;
        }

        public String getJid() {
            return this.jid;
        }

        public String getNick() {
            return this.nick;
        }

        public String getRole() {
            return this.role;
        }

        public void setActor(String string) {
            this.actor = string;
        }

        public void setReason(String string) {
            this.reason = string;
        }

        public void setJid(String string) {
            this.jid = string;
        }

        public void setNick(String string) {
            this.nick = string;
        }

        public void setRole(String string) {
            this.role = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<item");
            if (this.getAffiliation() != null) {
                stringBuilder.append(" affiliation=\"").append(this.getAffiliation()).append("\"");
            }
            if (this.getJid() != null) {
                stringBuilder.append(" jid=\"").append(this.getJid()).append("\"");
            }
            if (this.getNick() != null) {
                stringBuilder.append(" nick=\"").append(this.getNick()).append("\"");
            }
            if (this.getRole() != null) {
                stringBuilder.append(" role=\"").append(this.getRole()).append("\"");
            }
            if (this.getReason() == null && this.getActor() == null) {
                stringBuilder.append("/>");
            } else {
                stringBuilder.append(">");
                if (this.getReason() != null) {
                    stringBuilder.append("<reason>").append(this.getReason()).append("</reason>");
                }
                if (this.getActor() != null) {
                    stringBuilder.append("<actor jid=\"").append(this.getActor()).append("\"/>");
                }
                stringBuilder.append("</item>");
            }
            return stringBuilder.toString();
        }
    }
}

