/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;

public class MUCInitialPresence
implements PacketExtension {
    private String password;
    private History history;

    @Override
    public String getElementName() {
        return "x";
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/muc";
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        if (this.getPassword() != null) {
            stringBuilder.append("<password>").append(this.getPassword()).append("</password>");
        }
        if (this.getHistory() != null) {
            stringBuilder.append(this.getHistory().toXML());
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }

    public History getHistory() {
        return this.history;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public static class History {
        private int maxChars = -1;
        private int maxStanzas = -1;
        private int seconds = -1;
        private Date since;

        public int getMaxChars() {
            return this.maxChars;
        }

        public int getMaxStanzas() {
            return this.maxStanzas;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public Date getSince() {
            return this.since;
        }

        public void setMaxChars(int n2) {
            this.maxChars = n2;
        }

        public void setMaxStanzas(int n2) {
            this.maxStanzas = n2;
        }

        public void setSeconds(int n2) {
            this.seconds = n2;
        }

        public void setSince(Date date) {
            this.since = date;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<history");
            if (this.getMaxChars() != -1) {
                stringBuilder.append(" maxchars=\"").append(this.getMaxChars()).append("\"");
            }
            if (this.getMaxStanzas() != -1) {
                stringBuilder.append(" maxstanzas=\"").append(this.getMaxStanzas()).append("\"");
            }
            if (this.getSeconds() != -1) {
                stringBuilder.append(" seconds=\"").append(this.getSeconds()).append("\"");
            }
            if (this.getSince() != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                stringBuilder.append(" since=\"").append(simpleDateFormat.format(this.getSince())).append("\"");
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }
}

