/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.io.IOException;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LastActivity
extends IQ {
    public static final String NAMESPACE = "jabber:iq:last";
    public long lastActivity = -1L;
    public String message;

    public LastActivity() {
        this.setType(IQ.Type.GET);
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"jabber:iq:last\"");
        if (this.lastActivity != -1L) {
            stringBuilder.append(" seconds=\"").append(this.lastActivity).append("\"");
        }
        stringBuilder.append("></query>");
        return stringBuilder.toString();
    }

    public void setLastActivity(long l2) {
        this.lastActivity = l2;
    }

    private void setMessage(String string) {
        this.message = string;
    }

    public long getIdleTime() {
        return this.lastActivity;
    }

    public String getStatusMessage() {
        return this.message;
    }

    public static LastActivity getLastActivity(Connection connection, String string) throws XMPPException {
        LastActivity lastActivity = new LastActivity();
        string = StringUtils.parseBareAddress(string);
        lastActivity.setTo(string);
        PacketCollector packetCollector = connection.createPacketCollector(new PacketIDFilter(lastActivity.getPacketID()));
        connection.sendPacket(lastActivity);
        LastActivity lastActivity2 = (LastActivity)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (lastActivity2 == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (lastActivity2.getError() != null) {
            throw new XMPPException(lastActivity2.getError());
        }
        return lastActivity2;
    }

    public static class Provider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser xmlPullParser) throws XMPPException, XmlPullParserException {
            if (xmlPullParser.getEventType() != 2) {
                throw new XMPPException("Parser not in proper position, or bad XML.");
            }
            LastActivity lastActivity = new LastActivity();
            String string = xmlPullParser.getAttributeValue("", "seconds");
            String string2 = null;
            try {
                string2 = xmlPullParser.nextText();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string != null) {
                try {
                    lastActivity.setLastActivity(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string2 != null) {
                lastActivity.setMessage(string2);
            }
            return lastActivity;
        }
    }
}

