/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;

public class DiscoverItems
extends IQ {
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#items";
    private final List<Item> items = new CopyOnWriteArrayList<Item>();
    private String node;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public void addItems(Collection<Item> collection) {
        if (collection == null) {
            return;
        }
        for (Item item : collection) {
            this.addItem(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(this.items).iterator();
        }
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String string) {
        this.node = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"http://jabber.org/protocol/disco#items\"");
        if (this.getNode() != null) {
            stringBuilder.append(" node=\"");
            stringBuilder.append(StringUtils.escapeForXML(this.getNode()));
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        List<Item> list = this.items;
        synchronized (list) {
            for (Item item : this.items) {
                stringBuilder.append(item.toXML());
            }
        }
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }

    public static class Item {
        public static final String UPDATE_ACTION = "update";
        public static final String REMOVE_ACTION = "remove";
        private String entityID;
        private String name;
        private String node;
        private String action;

        public Item(String string) {
            this.entityID = string;
        }

        public String getEntityID() {
            return this.entityID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String string) {
            this.node = string;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String string) {
            this.action = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<item jid=\"").append(this.entityID).append("\"");
            if (this.name != null) {
                stringBuilder.append(" name=\"").append(StringUtils.escapeForXML(this.name)).append("\"");
            }
            if (this.node != null) {
                stringBuilder.append(" node=\"").append(StringUtils.escapeForXML(this.node)).append("\"");
            }
            if (this.action != null) {
                stringBuilder.append(" action=\"").append(StringUtils.escapeForXML(this.action)).append("\"");
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }
}

