/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;

public class DiscoverInfo
extends IQ {
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#info";
    private final List<Feature> features = new CopyOnWriteArrayList<Feature>();
    private final List<Identity> identities = new CopyOnWriteArrayList<Identity>();
    private String node;

    public DiscoverInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoverInfo(DiscoverInfo discoverInfo) {
        super(discoverInfo);
        this.setNode(discoverInfo.getNode());
        List<Object> list = discoverInfo.features;
        synchronized (list) {
            for (Feature object : discoverInfo.features) {
                this.addFeature(object);
            }
        }
        list = discoverInfo.identities;
        synchronized (list) {
            for (Identity identity : discoverInfo.identities) {
                this.addIdentity(identity);
            }
        }
    }

    public void addFeature(String string) {
        this.addFeature(new Feature(string));
    }

    public void addFeatures(Collection<String> collection) {
        if (collection == null) {
            return;
        }
        for (String string : collection) {
            this.addFeature(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFeature(Feature feature) {
        List<Feature> list = this.features;
        synchronized (list) {
            this.features.add(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Feature> getFeatures() {
        List<Feature> list = this.features;
        synchronized (list) {
            return Collections.unmodifiableList(this.features).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(Identity identity) {
        List<Identity> list = this.identities;
        synchronized (list) {
            this.identities.add(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentities(Collection<Identity> collection) {
        if (collection == null) {
            return;
        }
        List<Identity> list = this.identities;
        synchronized (list) {
            this.identities.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Identity> getIdentities() {
        List<Identity> list = this.identities;
        synchronized (list) {
            return Collections.unmodifiableList(this.identities).iterator();
        }
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String string) {
        this.node = string;
    }

    public boolean containsFeature(String string) {
        Iterator<Feature> iterator = this.getFeatures();
        while (iterator.hasNext()) {
            if (!string.equals(iterator.next().getVar())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"http://jabber.org/protocol/disco#info\"");
        if (this.getNode() != null) {
            stringBuilder.append(" node=\"");
            stringBuilder.append(StringUtils.escapeForXML(this.getNode()));
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        List<Object> list = this.identities;
        synchronized (list) {
            for (Identity object : this.identities) {
                stringBuilder.append(object.toXML());
            }
        }
        list = this.features;
        synchronized (list) {
            for (Feature feature : this.features) {
                stringBuilder.append(feature.toXML());
            }
        }
        stringBuilder.append(this.getExtensionsXML());
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }

    public boolean containsDuplicateIdentities() {
        LinkedList<Identity> linkedList = new LinkedList<Identity>();
        for (Identity identity : this.identities) {
            for (Identity identity2 : linkedList) {
                if (!identity.equals(identity2)) continue;
                return true;
            }
            linkedList.add(identity);
        }
        return false;
    }

    public boolean containsDuplicateFeatures() {
        LinkedList<Feature> linkedList = new LinkedList<Feature>();
        for (Feature feature : this.features) {
            for (Feature feature2 : linkedList) {
                if (!feature.equals(feature2)) continue;
                return true;
            }
            linkedList.add(feature);
        }
        return false;
    }

    public static class Feature {
        private String variable;

        public Feature(String string) {
            if (string == null) {
                throw new IllegalArgumentException("variable cannot be null");
            }
            this.variable = string;
        }

        public String getVar() {
            return this.variable;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<feature var=\"").append(StringUtils.escapeForXML(this.variable)).append("\"/>");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Feature feature = (Feature)object;
            return this.variable.equals(feature.variable);
        }

        public int hashCode() {
            return 37 * this.variable.hashCode();
        }
    }

    public static class Identity
    implements Comparable<Identity> {
        private String category;
        private String name;
        private String type;
        private String lang;

        public Identity(String string, String string2) {
            this.category = string;
            this.name = string2;
        }

        public Identity(String string, String string2, String string3) {
            if (string == null || string3 == null) {
                throw new IllegalArgumentException("category and type cannot be null");
            }
            this.category = string;
            this.name = string2;
            this.type = string3;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public void setLanguage(String string) {
            this.lang = string;
        }

        public String getLanguage() {
            return this.lang;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<identity");
            if (this.lang != null) {
                stringBuilder.append(" xml:lang=\"").append(StringUtils.escapeForXML(this.lang)).append("\"");
            }
            stringBuilder.append(" category=\"").append(StringUtils.escapeForXML(this.category)).append("\"");
            stringBuilder.append(" name=\"").append(StringUtils.escapeForXML(this.name)).append("\"");
            if (this.type != null) {
                stringBuilder.append(" type=\"").append(StringUtils.escapeForXML(this.type)).append("\"");
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            String string;
            String string2;
            String string3;
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Identity identity = (Identity)object;
            if (!this.category.equals(identity.category)) {
                return false;
            }
            String string4 = identity.lang == null ? "" : identity.lang;
            String string5 = string3 = this.lang == null ? "" : this.lang;
            if (!string4.equals(string3)) {
                return false;
            }
            String string6 = identity.type == null ? "" : identity.type;
            String string7 = string2 = this.type == null ? "" : this.type;
            if (!string6.equals(string2)) {
                return false;
            }
            String string8 = identity.name == null ? "" : identity.name;
            String string9 = string = this.name == null ? "" : identity.name;
            return string.equals(string8);
        }

        public int hashCode() {
            int n2 = 1;
            n2 = 37 * n2 + this.category.hashCode();
            n2 = 37 * n2 + (this.lang == null ? 0 : this.lang.hashCode());
            n2 = 37 * n2 + (this.type == null ? 0 : this.type.hashCode());
            n2 = 37 * n2 + (this.name == null ? 0 : this.name.hashCode());
            return n2;
        }

        @Override
        public int compareTo(Identity identity) {
            String string;
            String string2 = identity.lang == null ? "" : identity.lang;
            String string3 = this.lang == null ? "" : this.lang;
            String string4 = identity.type == null ? "" : identity.type;
            String string5 = string = this.type == null ? "" : this.type;
            if (this.category.equals(identity.category)) {
                if (string.equals(string4)) {
                    if (string3.equals(string2)) {
                        return 0;
                    }
                    return string3.compareTo(string2);
                }
                return string.compareTo(string4);
            }
            return this.category.compareTo(identity.category);
        }
    }
}

