/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.FormField;

public class DataForm
implements PacketExtension {
    private String type;
    private String title;
    private List<String> instructions = new ArrayList<String>();
    private ReportedData reportedData;
    private final List<Item> items = new ArrayList<Item>();
    private final List<FormField> fields = new ArrayList<FormField>();

    public DataForm(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getInstructions() {
        List<String> list = this.instructions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.instructions)).iterator();
        }
    }

    public ReportedData getReportedData() {
        return this.reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.items)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<FormField> getFields() {
        List<FormField> list = this.fields;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields)).iterator();
        }
    }

    @Override
    public String getElementName() {
        return "x";
    }

    @Override
    public String getNamespace() {
        return "jabber:x:data";
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setInstructions(List<String> list) {
        this.instructions = list;
    }

    public void setReportedData(ReportedData reportedData) {
        this.reportedData = reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(FormField formField) {
        List<FormField> list = this.fields;
        synchronized (list) {
            this.fields.add(formField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstruction(String string) {
        List<String> list = this.instructions;
        synchronized (list) {
            this.instructions.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public boolean hasHiddenFormTypeField() {
        boolean bl = false;
        for (FormField formField : this.fields) {
            if (!formField.getVariable().equals("FORM_TYPE") || formField.getType() == null || !formField.getType().equals("hidden")) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public String toXML() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\" type=\"" + this.getType() + "\">");
        if (this.getTitle() != null) {
            stringBuilder.append("<title>").append(this.getTitle()).append("</title>");
        }
        Iterator<Object> iterator = this.getInstructions();
        while (iterator.hasNext()) {
            stringBuilder.append("<instructions>").append(iterator.next()).append("</instructions>");
        }
        if (this.getReportedData() != null) {
            stringBuilder.append(this.getReportedData().toXML());
        }
        iterator = this.getItems();
        while (iterator.hasNext()) {
            object = (Item)iterator.next();
            stringBuilder.append(((Item)object).toXML());
        }
        iterator = this.getFields();
        while (iterator.hasNext()) {
            object = (FormField)iterator.next();
            stringBuilder.append(((FormField)object).toXML());
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }

    public static class Item {
        private List<FormField> fields = new ArrayList<FormField>();

        public Item(List<FormField> list) {
            this.fields = list;
        }

        public Iterator<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields)).iterator();
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<item>");
            Iterator<FormField> iterator = this.getFields();
            while (iterator.hasNext()) {
                FormField formField = iterator.next();
                stringBuilder.append(formField.toXML());
            }
            stringBuilder.append("</item>");
            return stringBuilder.toString();
        }
    }

    public static class ReportedData {
        private List<FormField> fields = new ArrayList<FormField>();

        public ReportedData(List<FormField> list) {
            this.fields = list;
        }

        public Iterator<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields)).iterator();
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<reported>");
            Iterator<FormField> iterator = this.getFields();
            while (iterator.hasNext()) {
                FormField formField = iterator.next();
                stringBuilder.append(formField.toXML());
            }
            stringBuilder.append("</reported>");
            return stringBuilder.toString();
        }
    }
}

