/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.MUCAdmin;
import org.jivesoftware.smackx.packet.MUCUser;

public class Occupant {
    private String affiliation;
    private String role;
    private String jid;
    private String nick;

    Occupant(MUCAdmin.Item item) {
        this.jid = item.getJid();
        this.affiliation = item.getAffiliation();
        this.role = item.getRole();
        this.nick = item.getNick();
    }

    Occupant(Presence presence) {
        MUCUser mUCUser = (MUCUser)presence.getExtension("x", "http://jabber.org/protocol/muc#user");
        MUCUser.Item item = mUCUser.getItem();
        this.jid = item.getJid();
        this.affiliation = item.getAffiliation();
        this.role = item.getRole();
        this.nick = StringUtils.parseResource(presence.getFrom());
    }

    public String getJid() {
        return this.jid;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public String getRole() {
        return this.role;
    }

    public String getNick() {
        return this.nick;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Occupant)) {
            return false;
        }
        Occupant occupant = (Occupant)object;
        return this.jid.equals(occupant.jid);
    }

    public int hashCode() {
        int n2 = this.affiliation.hashCode();
        n2 = 17 * n2 + this.role.hashCode();
        n2 = 17 * n2 + this.jid.hashCode();
        n2 = 17 * n2 + (this.nick != null ? this.nick.hashCode() : 0);
        return n2;
    }
}

