/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import com.easemob.util.EMLog;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.ConnectionDetachedPacketCollector;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.PacketMultiplexListener;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.RoomListenerMultiplexor;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.MUCAdmin;
import org.jivesoftware.smackx.packet.MUCCreatePresence;
import org.jivesoftware.smackx.packet.MUCInitialPresence;
import org.jivesoftware.smackx.packet.MUCJoinPresence;
import org.jivesoftware.smackx.packet.MUCOwner;
import org.jivesoftware.smackx.packet.MUCUser;

public class MultiUserChat {
    private static final String discoNamespace = "http://jabber.org/protocol/muc";
    private static final String discoNode = "http://jabber.org/protocol/muc#rooms";
    private static Map<Connection, List<String>> joinedRooms = new WeakHashMap<Connection, List<String>>();
    private Connection connection;
    private String room;
    private String subject;
    private String nickname = null;
    private boolean joined = false;
    private Map<String, Presence> occupantsMap = new ConcurrentHashMap<String, Presence>();
    private final List<InvitationRejectionListener> invitationRejectionListeners = new ArrayList<InvitationRejectionListener>();
    private final List<SubjectUpdatedListener> subjectUpdatedListeners = new ArrayList<SubjectUpdatedListener>();
    private final List<UserStatusListener> userStatusListeners = new ArrayList<UserStatusListener>();
    private final List<ParticipantStatusListener> participantStatusListeners = new ArrayList<ParticipantStatusListener>();
    private PacketFilter presenceFilter;
    private List<PacketInterceptor> presenceInterceptors = new ArrayList<PacketInterceptor>();
    private PacketFilter messageFilter;
    private RoomListenerMultiplexor roomListenerMultiplexor;
    private ConnectionDetachedPacketCollector messageCollector;
    private List<PacketListener> connectionListeners = new ArrayList<PacketListener>();

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(final Connection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection).addFeature(MultiUserChat.discoNamespace);
                ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(MultiUserChat.discoNode, new NodeInformationProvider(){

                    @Override
                    public List<DiscoverItems.Item> getNodeItems() {
                        ArrayList<DiscoverItems.Item> arrayList = new ArrayList<DiscoverItems.Item>();
                        Iterator iterator = MultiUserChat.getJoinedRooms(connection);
                        while (iterator.hasNext()) {
                            arrayList.add(new DiscoverItems.Item((String)iterator.next()));
                        }
                        return arrayList;
                    }

                    @Override
                    public List<String> getNodeFeatures() {
                        return null;
                    }

                    @Override
                    public List<DiscoverInfo.Identity> getNodeIdentities() {
                        return null;
                    }

                    @Override
                    public List<PacketExtension> getNodePacketExtensions() {
                        return null;
                    }
                });
            }
        });
    }

    public MultiUserChat(Connection connection, String string) {
        this.connection = connection;
        this.room = string.toLowerCase();
        this.init();
    }

    public static boolean isServiceEnabled(Connection connection, String string) {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(string);
            return discoverInfo.containsFeature(discoNamespace);
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            return false;
        }
    }

    private static Iterator<String> getJoinedRooms(Connection connection) {
        List<String> list = joinedRooms.get(connection);
        if (list != null) {
            return list.iterator();
        }
        return new ArrayList().iterator();
    }

    public static Iterator<String> getJoinedRooms(Connection connection, String string) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            DiscoverItems discoverItems = ServiceDiscoveryManager.getInstanceFor(connection).discoverItems(string, discoNode);
            Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().getEntityID());
            }
            return arrayList.iterator();
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            return new ArrayList().iterator();
        }
    }

    public static RoomInfo getRoomInfo(Connection connection, String string) throws XMPPException {
        DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(string);
        return new RoomInfo(discoverInfo);
    }

    public static Collection<String> getServiceNames(Connection connection) throws XMPPException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(connection.getServiceName());
        Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
        while (iterator.hasNext()) {
            DiscoverItems.Item item = iterator.next();
            try {
                DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
                if (!discoverInfo.containsFeature(discoNamespace)) continue;
                arrayList.add(item.getEntityID());
            }
            catch (XMPPException xMPPException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static Collection<HostedRoom> getHostedRooms(Connection connection, String string) throws XMPPException {
        ArrayList<HostedRoom> arrayList = new ArrayList<HostedRoom>();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(string);
        Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
        while (iterator.hasNext()) {
            arrayList.add(new HostedRoom(iterator.next()));
        }
        return arrayList;
    }

    public static Collection<HostedRoom> getPublicRooms(Connection connection, String string, String string2) throws XMPPException {
        ArrayList<HostedRoom> arrayList = new ArrayList<HostedRoom>();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        String string3 = string2;
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(string, string3);
        Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
        while (iterator.hasNext()) {
            arrayList.add(new HostedRoom(iterator.next()));
        }
        return arrayList;
    }

    public String getRoom() {
        return this.room;
    }

    public synchronized void create(String string) throws XMPPException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (this.joined) {
            throw new IllegalStateException("Creation failed - User already joined the room.");
        }
        Presence presence = new Presence(Presence.Type.available);
        presence.setTo(String.valueOf(this.room) + "/" + string);
        presence.addExtension(new MUCInitialPresence());
        presence.addExtension(new MUCCreatePresence());
        for (PacketInterceptor object2 : this.presenceInterceptors) {
            object2.interceptPacket(presence);
        }
        AndFilter andFilter = new AndFilter(new FromMatchesFilter(String.valueOf(this.room) + "/" + string), new PacketTypeFilter(Presence.class));
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(presence);
        Presence presence2 = (Presence)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (presence2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence2.getError() != null) {
            throw new XMPPException(presence2.getError());
        }
        this.nickname = string;
        this.joined = true;
        this.userHasJoined();
        MUCUser mUCUser = this.getMUCUserExtension(presence2);
        if (mUCUser != null && mUCUser.getStatus() != null && "201".equals(mUCUser.getStatus().getCode())) {
            return;
        }
        this.leave();
        throw new XMPPException("Creation failed - Missing acknowledge of room creation.");
    }

    public void join(String string) throws XMPPException {
        this.join(string, null, null, SmackConfiguration.getPacketReplyTimeout());
    }

    public void join(String string, long l2) throws XMPPException {
        this.join(string, null, null, l2);
    }

    public void join(String string, String string2) throws XMPPException {
        this.join(string, string2, null, SmackConfiguration.getPacketReplyTimeout());
    }

    public synchronized void join(String string, String string2, DiscussionHistory discussionHistory, long l2) throws XMPPException {
        Presence presence;
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (this.joined) {
            this.leave();
        }
        Presence presence2 = new Presence(Presence.Type.available);
        presence2.setTo(String.valueOf(this.room) + "/" + string);
        MUCInitialPresence mUCInitialPresence = new MUCInitialPresence();
        if (string2 != null) {
            mUCInitialPresence.setPassword(string2);
        }
        if (discussionHistory != null) {
            mUCInitialPresence.setHistory(discussionHistory.getMUCHistory());
        }
        presence2.addExtension(mUCInitialPresence);
        MUCJoinPresence mUCJoinPresence = new MUCJoinPresence();
        presence2.addExtension(mUCJoinPresence);
        for (PacketInterceptor object2 : this.presenceInterceptors) {
            object2.interceptPacket(presence2);
        }
        AndFilter andFilter = new AndFilter(new FromMatchesFilter(String.valueOf(this.room) + "/" + string), new PacketTypeFilter(Presence.class));
        Object object3 = null;
        try {
            try {
                object3 = this.connection.createPacketCollector(andFilter);
                this.connection.sendPacket(presence2);
                presence = (Presence)((PacketCollector)object3).nextResult(l2);
            }
            catch (IllegalStateException illegalStateException) {
                throw new XMPPException("not connected to server");
            }
        }
        finally {
            if (object3 != null) {
                ((PacketCollector)object3).cancel();
            }
        }
        if (presence == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
        this.nickname = string;
        this.joined = true;
        this.userHasJoined();
    }

    public boolean isJoined() {
        return this.joined;
    }

    public synchronized void leave() {
        if (!this.joined) {
            return;
        }
        Presence presence = new Presence(Presence.Type.unavailable);
        presence.setTo(String.valueOf(this.room) + "/" + this.nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(presence);
        }
        this.connection.sendPacket(presence);
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public void leaveAndWait(long l2) throws XMPPException {
        Presence presence;
        Presence presence2 = new Presence(Presence.Type.unavailable);
        presence2.setTo(String.valueOf(this.room) + "/" + this.nickname);
        for (PacketInterceptor object2 : this.presenceInterceptors) {
            object2.interceptPacket(presence2);
        }
        PacketFilter packetFilter = new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                String string;
                Presence presence;
                MUCUser mUCUser;
                return packet instanceof Presence && (mUCUser = (MUCUser)(presence = (Presence)packet).getExtension("x", "http://jabber.org/protocol/muc#user")) != null && (string = mUCUser.toXML()) != null && string.contains("role=\"none\"");
            }
        };
        Object object3 = null;
        try {
            try {
                object3 = this.connection.createPacketCollector(packetFilter);
                this.connection.sendPacket(presence2);
                presence = (Presence)((PacketCollector)object3).nextResult(l2);
            }
            catch (IllegalStateException illegalStateException) {
                throw new XMPPException("not connected to server");
            }
        }
        finally {
            if (object3 != null) {
                ((PacketCollector)object3).cancel();
            }
        }
        if (presence == null) {
            throw new XMPPException("No response from server.");
        }
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public Form getConfigurationForm() throws XMPPException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.GET);
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCOwner.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCOwner);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
        return Form.getFormFrom(iQ);
    }

    public void sendConfigurationForm(Form form) throws XMPPException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.SET);
        mUCOwner.addExtension(form.getDataFormToSend());
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCOwner.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCOwner);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
    }

    public Form getRegistrationForm() throws XMPPException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.GET);
        registration.setTo(this.room);
        AndFilter andFilter = new AndFilter(new PacketIDFilter(registration.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(registration);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        return Form.getFormFrom(iQ);
    }

    public void sendRegistrationForm(Form form) throws XMPPException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(this.room);
        registration.addExtension(form.getDataFormToSend());
        AndFilter andFilter = new AndFilter(new PacketIDFilter(registration.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(registration);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
    }

    public void destroy(String string, String string2) throws XMPPException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.SET);
        MUCOwner.Destroy destroy = new MUCOwner.Destroy();
        destroy.setReason(string);
        destroy.setJid(string2);
        mUCOwner.setDestroy(destroy);
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCOwner.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCOwner);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public void invite(String string, String string2) {
        this.invite(new Message(), string, string2);
    }

    public void invite(Message message, String string, String string2) {
        message.setTo(this.room);
        MUCUser mUCUser = new MUCUser();
        MUCUser.Invite invite = new MUCUser.Invite();
        invite.setTo(string);
        invite.setReason(string2);
        mUCUser.setInvite(invite);
        message.addExtension(mUCUser);
        this.connection.sendPacket(message);
    }

    public static void decline(Connection connection, String string, String string2, String string3) {
        Message message = new Message(string);
        MUCUser mUCUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setTo(string2);
        decline.setReason(string3);
        mUCUser.setDecline(decline);
        message.addExtension(mUCUser);
        connection.sendPacket(message);
    }

    public static void addInvitationListener(Connection connection, InvitationListener invitationListener) {
        InvitationsMonitor.getInvitationsMonitor(connection).addInvitationListener(invitationListener);
    }

    public static void removeInvitationListener(Connection connection, InvitationListener invitationListener) {
        InvitationsMonitor.getInvitationsMonitor(connection).removeInvitationListener(invitationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationRejectionListener(InvitationRejectionListener invitationRejectionListener) {
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            if (!this.invitationRejectionListeners.contains(invitationRejectionListener)) {
                this.invitationRejectionListeners.add(invitationRejectionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationRejectionListener(InvitationRejectionListener invitationRejectionListener) {
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            this.invitationRejectionListeners.remove(invitationRejectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationRejectionListeners(String string, String string2) {
        InvitationRejectionListener[] invitationRejectionListenerArray;
        Object object = this.invitationRejectionListeners;
        synchronized (object) {
            invitationRejectionListenerArray = new InvitationRejectionListener[this.invitationRejectionListeners.size()];
            this.invitationRejectionListeners.toArray(invitationRejectionListenerArray);
        }
        InvitationRejectionListener[] invitationRejectionListenerArray2 = invitationRejectionListenerArray;
        int n2 = invitationRejectionListenerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = invitationRejectionListenerArray2[n3];
            object.invitationDeclined(string, string2);
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubjectUpdatedListener(SubjectUpdatedListener subjectUpdatedListener) {
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            if (!this.subjectUpdatedListeners.contains(subjectUpdatedListener)) {
                this.subjectUpdatedListeners.add(subjectUpdatedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubjectUpdatedListener(SubjectUpdatedListener subjectUpdatedListener) {
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            this.subjectUpdatedListeners.remove(subjectUpdatedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSubjectUpdatedListeners(String string, String string2) {
        SubjectUpdatedListener[] subjectUpdatedListenerArray;
        Object object = this.subjectUpdatedListeners;
        synchronized (object) {
            subjectUpdatedListenerArray = new SubjectUpdatedListener[this.subjectUpdatedListeners.size()];
            this.subjectUpdatedListeners.toArray(subjectUpdatedListenerArray);
        }
        SubjectUpdatedListener[] subjectUpdatedListenerArray2 = subjectUpdatedListenerArray;
        int n2 = subjectUpdatedListenerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = subjectUpdatedListenerArray2[n3];
            object.subjectUpdated(string, string2);
            ++n3;
        }
    }

    public void addPresenceInterceptor(PacketInterceptor packetInterceptor) {
        this.presenceInterceptors.add(packetInterceptor);
    }

    public void removePresenceInterceptor(PacketInterceptor packetInterceptor) {
        this.presenceInterceptors.remove(packetInterceptor);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReservedNickname() {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(this.room, "x-roomuser-item");
            Iterator<DiscoverInfo.Identity> iterator = discoverInfo.getIdentities();
            if (iterator.hasNext()) {
                DiscoverInfo.Identity identity = iterator.next();
                return identity.getName();
            }
            return null;
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            return null;
        }
    }

    public String getNickname() {
        return this.nickname;
    }

    public void changeNickname(String string) throws XMPPException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change nickname.");
        }
        Presence presence = new Presence(Presence.Type.available);
        presence.setTo(String.valueOf(this.room) + "/" + string);
        for (PacketInterceptor object2 : this.presenceInterceptors) {
            object2.interceptPacket(presence);
        }
        AndFilter andFilter = new AndFilter(new FromMatchesFilter(String.valueOf(this.room) + "/" + string), new PacketTypeFilter(Presence.class));
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(presence);
        Presence presence2 = (Presence)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (presence2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence2.getError() != null) {
            throw new XMPPException(presence2.getError());
        }
        this.nickname = string;
    }

    public void changeAvailabilityStatus(String string, Presence.Mode mode) {
        if (this.nickname == null || this.nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change the availability status.");
        }
        Presence presence = new Presence(Presence.Type.available);
        presence.setStatus(string);
        presence.setMode(mode);
        presence.setTo(String.valueOf(this.room) + "/" + this.nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(presence);
        }
        this.connection.sendPacket(presence);
    }

    public void kickParticipant(String string, String string2) throws XMPPException {
        this.changeRole(string, "none", string2);
    }

    public void grantVoice(Collection<String> collection) throws XMPPException {
        this.changeRole(collection, "participant");
    }

    public void grantVoice(String string) throws XMPPException {
        this.changeRole(string, "participant", null);
    }

    public void revokeVoice(Collection<String> collection) throws XMPPException {
        this.changeRole(collection, "visitor");
    }

    public void revokeVoice(String string) throws XMPPException {
        this.changeRole(string, "visitor", null);
    }

    public void banUsers(Collection<String> collection) throws XMPPException {
        this.changeAffiliationByAdmin(collection, "outcast");
    }

    public void banUser(String string, String string2) throws XMPPException {
        this.changeAffiliationByAdmin(string, "outcast", string2);
    }

    public void grantMembership(Collection<String> collection) throws XMPPException {
        this.changeAffiliationByAdmin(collection, "member");
    }

    public void grantMembership(String string) throws XMPPException {
        this.changeAffiliationByAdmin(string, "member", null);
    }

    public void revokeMembership(Collection<String> collection) throws XMPPException {
        this.changeAffiliationByAdmin(collection, "none");
    }

    public void revokeMembership(String string) throws XMPPException {
        this.changeAffiliationByAdmin(string, "none", null);
    }

    public void grantModerator(Collection<String> collection) throws XMPPException {
        this.changeRole(collection, "moderator");
    }

    public void grantModerator(String string) throws XMPPException {
        this.changeRole(string, "moderator", null);
    }

    public void revokeModerator(Collection<String> collection) throws XMPPException {
        this.changeRole(collection, "participant");
    }

    public void revokeModerator(String string) throws XMPPException {
        this.changeRole(string, "participant", null);
    }

    public void grantOwnership(Collection<String> collection) throws XMPPException {
        this.changeAffiliationByAdmin(collection, "owner");
    }

    public void grantOwnership(String string) throws XMPPException {
        this.changeAffiliationByAdmin(string, "owner", null);
    }

    public void revokeOwnership(Collection<String> collection) throws XMPPException {
        this.changeAffiliationByAdmin(collection, "admin");
    }

    public void revokeOwnership(String string) throws XMPPException {
        this.changeAffiliationByAdmin(string, "admin", null);
    }

    public void grantAdmin(Collection<String> collection) throws XMPPException {
        this.changeAffiliationByOwner(collection, "admin");
    }

    public void grantAdmin(String string) throws XMPPException {
        this.changeAffiliationByOwner(string, "admin");
    }

    public void revokeAdmin(Collection<String> collection) throws XMPPException {
        this.changeAffiliationByOwner(collection, "member");
    }

    public void revokeAdmin(String string) throws XMPPException {
        this.changeAffiliationByOwner(string, "member");
    }

    private void changeAffiliationByOwner(String string, String string2) throws XMPPException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.SET);
        MUCOwner.Item item = new MUCOwner.Item(string2);
        item.setJid(string);
        mUCOwner.addItem(item);
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCOwner.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCOwner);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
    }

    private void changeAffiliationByOwner(Collection<String> collection, String string) throws XMPPException {
        Object object;
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.SET);
        for (String object22 : collection) {
            object = new MUCOwner.Item(string);
            ((MUCOwner.Item)object).setJid(object22);
            mUCOwner.addItem((MUCOwner.Item)object);
        }
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCOwner.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCOwner);
        object = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (object == null) {
            throw new XMPPException("No response from server.");
        }
        if (((Packet)object).getError() != null) {
            throw new XMPPException(((Packet)object).getError());
        }
    }

    private void changeAffiliationByAdmin(String string, String string2, String string3) throws XMPPException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(string2, null);
        item.setJid(string);
        if (string3 != null) {
            item.setReason(string3);
        }
        mUCAdmin.addItem(item);
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCAdmin.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCAdmin);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
    }

    private void changeAffiliationByAdmin(Collection<String> collection, String string) throws XMPPException {
        Object object;
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.SET);
        for (String object22 : collection) {
            object = new MUCAdmin.Item(string, null);
            ((MUCAdmin.Item)object).setJid(object22);
            mUCAdmin.addItem((MUCAdmin.Item)object);
        }
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCAdmin.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCAdmin);
        object = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (object == null) {
            throw new XMPPException("No response from server.");
        }
        if (((Packet)object).getError() != null) {
            throw new XMPPException(((Packet)object).getError());
        }
    }

    private void changeRole(String string, String string2, String string3) throws XMPPException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, string2);
        item.setNick(string);
        item.setReason(string3);
        mUCAdmin.addItem(item);
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCAdmin.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCAdmin);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
    }

    private void changeRole(Collection<String> collection, String string) throws XMPPException {
        Object object;
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.SET);
        for (String object22 : collection) {
            object = new MUCAdmin.Item(null, string);
            ((MUCAdmin.Item)object).setNick(object22);
            mUCAdmin.addItem((MUCAdmin.Item)object);
        }
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCAdmin.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCAdmin);
        object = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (object == null) {
            throw new XMPPException("No response from server.");
        }
        if (((Packet)object).getError() != null) {
            throw new XMPPException(((Packet)object).getError());
        }
    }

    public int getOccupantsCount() {
        return this.occupantsMap.size();
    }

    public Iterator<String> getOccupants() {
        return Collections.unmodifiableList(new ArrayList<String>(this.occupantsMap.keySet())).iterator();
    }

    public Presence getOccupantPresence(String string) {
        return this.occupantsMap.get(string);
    }

    public Occupant getOccupant(String string) {
        Presence presence = this.occupantsMap.get(string);
        if (presence != null) {
            return new Occupant(presence);
        }
        return null;
    }

    public void addParticipantListener(PacketListener packetListener) {
        this.connection.addPacketListener(packetListener, this.presenceFilter);
        this.connectionListeners.add(packetListener);
    }

    public void removeParticipantListener(PacketListener packetListener) {
        this.connection.removePacketListener(packetListener);
        this.connectionListeners.remove(packetListener);
    }

    public Collection<Affiliate> getOwners() throws XMPPException {
        return this.getAffiliatesByAdmin("owner");
    }

    public Collection<Affiliate> getAdmins() throws XMPPException {
        return this.getAffiliatesByOwner("admin");
    }

    public Collection<Affiliate> getMembers() throws XMPPException {
        return this.getAffiliatesByAdmin("member");
    }

    public Collection<Affiliate> getOutcasts() throws XMPPException {
        return this.getAffiliatesByAdmin("outcast");
    }

    private Collection<Affiliate> getAffiliatesByOwner(String string) throws XMPPException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.GET);
        MUCOwner.Item item = new MUCOwner.Item(string);
        mUCOwner.addItem(item);
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCOwner.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCOwner);
        MUCOwner mUCOwner2 = (MUCOwner)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (mUCOwner2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (mUCOwner2.getError() != null) {
            throw new XMPPException(mUCOwner2.getError());
        }
        ArrayList<Affiliate> arrayList = new ArrayList<Affiliate>();
        Iterator<MUCOwner.Item> iterator = mUCOwner2.getItems();
        while (iterator.hasNext()) {
            arrayList.add(new Affiliate(iterator.next()));
        }
        return arrayList;
    }

    private Collection<Affiliate> getAffiliatesByAdmin(String string) throws XMPPException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(string, null);
        mUCAdmin.addItem(item);
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCAdmin.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCAdmin);
        MUCAdmin mUCAdmin2 = (MUCAdmin)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (mUCAdmin2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (mUCAdmin2.getError() != null) {
            throw new XMPPException(mUCAdmin2.getError());
        }
        ArrayList<Affiliate> arrayList = new ArrayList<Affiliate>();
        Iterator<MUCAdmin.Item> iterator = mUCAdmin2.getItems();
        while (iterator.hasNext()) {
            arrayList.add(new Affiliate(iterator.next()));
        }
        return arrayList;
    }

    public Collection<Occupant> getModerators() throws XMPPException {
        return this.getOccupants("moderator");
    }

    public Collection<Occupant> getParticipants() throws XMPPException {
        return this.getOccupants("participant");
    }

    private Collection<Occupant> getOccupants(String string) throws XMPPException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, string);
        mUCAdmin.addItem(item);
        PacketIDFilter packetIDFilter = new PacketIDFilter(mUCAdmin.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(mUCAdmin);
        MUCAdmin mUCAdmin2 = (MUCAdmin)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (mUCAdmin2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (mUCAdmin2.getError() != null) {
            throw new XMPPException(mUCAdmin2.getError());
        }
        ArrayList<Occupant> arrayList = new ArrayList<Occupant>();
        Iterator<MUCAdmin.Item> iterator = mUCAdmin2.getItems();
        while (iterator.hasNext()) {
            arrayList.add(new Occupant(iterator.next()));
        }
        return arrayList;
    }

    public void sendMessage(String string) throws XMPPException {
        Message message = new Message(this.room, Message.Type.groupchat);
        message.setBody(string);
        this.connection.sendPacket(message);
    }

    public Chat createPrivateChat(String string, MessageListener messageListener) {
        return this.connection.getChatManager().createChat(string, messageListener);
    }

    public Message createMessage() {
        return new Message(this.room, Message.Type.groupchat);
    }

    public void sendMessage(Message message) throws XMPPException {
        this.connection.sendPacket(message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() {
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long l2) {
        return (Message)this.messageCollector.nextResult(l2);
    }

    public void addMessageListener(PacketListener packetListener) {
        this.connection.addPacketListener(packetListener, this.messageFilter);
        this.connectionListeners.add(packetListener);
    }

    public void removeMessageListener(PacketListener packetListener) {
        this.connection.removePacketListener(packetListener);
        this.connectionListeners.remove(packetListener);
    }

    public void changeSubject(final String string) throws XMPPException {
        Message message = new Message(this.room, Message.Type.groupchat);
        message.setSubject(string);
        AndFilter andFilter = new AndFilter(new FromMatchesFilter(this.room), new PacketTypeFilter(Message.class));
        andFilter = new AndFilter(andFilter, new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                Message message = (Message)packet;
                return string.equals(message.getSubject());
            }
        });
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(message);
        Message message2 = (Message)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (message2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (message2.getError() != null) {
            throw new XMPPException(message2.getError());
        }
    }

    private synchronized void userHasJoined() {
        List<String> list = joinedRooms.get(this.connection);
        if (list == null) {
            list = new ArrayList<String>();
            joinedRooms.put(this.connection, list);
        }
        list.add(this.room);
    }

    private synchronized void userHasLeft() {
        List<String> list = joinedRooms.get(this.connection);
        if (list == null) {
            return;
        }
        list.remove(this.room);
        this.cleanup();
    }

    private MUCUser getMUCUserExtension(Packet packet) {
        if (packet != null) {
            return (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserStatusListener(UserStatusListener userStatusListener) {
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            if (!this.userStatusListeners.contains(userStatusListener)) {
                this.userStatusListeners.add(userStatusListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserStatusListener(UserStatusListener userStatusListener) {
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            this.userStatusListeners.remove(userStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUserStatusListeners(String string, Object[] objectArray) {
        Class[] classArray = this.userStatusListeners;
        synchronized (this.userStatusListeners) {
            UserStatusListener[] userStatusListenerArray = new UserStatusListener[this.userStatusListeners.size()];
            this.userStatusListeners.toArray(userStatusListenerArray);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            classArray = new Class[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                classArray[n2] = objectArray[n2].getClass();
                ++n2;
            }
            try {
                Method method = UserStatusListener.class.getDeclaredMethod(string, classArray);
                UserStatusListener[] userStatusListenerArray2 = userStatusListenerArray;
                int n3 = userStatusListenerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    UserStatusListener userStatusListener = userStatusListenerArray2[n4];
                    method.invoke((Object)userStatusListener, objectArray);
                    ++n4;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipantStatusListener(ParticipantStatusListener participantStatusListener) {
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            if (!this.participantStatusListeners.contains(participantStatusListener)) {
                this.participantStatusListeners.add(participantStatusListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipantStatusListener(ParticipantStatusListener participantStatusListener) {
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            this.participantStatusListeners.remove(participantStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireParticipantStatusListeners(String string, List<String> list) {
        Class[] classArray = this.participantStatusListeners;
        synchronized (this.participantStatusListeners) {
            ParticipantStatusListener[] participantStatusListenerArray = new ParticipantStatusListener[this.participantStatusListeners.size()];
            this.participantStatusListeners.toArray(participantStatusListenerArray);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            try {
                classArray = new Class[list.size()];
                int n2 = 0;
                while (n2 < list.size()) {
                    classArray[n2] = String.class;
                    ++n2;
                }
                Method method = ParticipantStatusListener.class.getDeclaredMethod(string, classArray);
                ParticipantStatusListener[] participantStatusListenerArray2 = participantStatusListenerArray;
                int n3 = participantStatusListenerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ParticipantStatusListener participantStatusListener = participantStatusListenerArray2[n4];
                    method.invoke((Object)participantStatusListener, list.toArray());
                    ++n4;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return;
        }
    }

    private void init() {
        this.messageFilter = new AndFilter(new FromMatchesFilter(this.room), new MessageTypeFilter(Message.Type.groupchat));
        this.messageFilter = new AndFilter(this.messageFilter, new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                Message message = (Message)packet;
                return message.getBody() != null;
            }
        });
        this.presenceFilter = new AndFilter(new FromMatchesFilter(this.room), new PacketTypeFilter(Presence.class));
        this.messageCollector = new ConnectionDetachedPacketCollector();
        PacketListener packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                MultiUserChat.this.subject = message.getSubject();
                MultiUserChat.this.fireSubjectUpdatedListeners(message.getSubject(), message.getFrom());
            }
        };
        PacketListener packetListener2 = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                String string = presence.getFrom();
                String string2 = String.valueOf(MultiUserChat.this.room) + "/" + MultiUserChat.this.nickname;
                boolean bl = presence.getFrom().equals(string2);
                if (presence.getType() == Presence.Type.available) {
                    Presence presence2 = MultiUserChat.this.occupantsMap.put(string, presence);
                    if (presence2 != null) {
                        MUCUser mUCUser = MultiUserChat.this.getMUCUserExtension(presence2);
                        String string3 = mUCUser.getItem().getAffiliation();
                        String string4 = mUCUser.getItem().getRole();
                        mUCUser = MultiUserChat.this.getMUCUserExtension(presence);
                        String string5 = mUCUser.getItem().getAffiliation();
                        String string6 = mUCUser.getItem().getRole();
                        MultiUserChat.this.checkRoleModifications(string4, string6, bl, string);
                        MultiUserChat.this.checkAffiliationModifications(string3, string5, bl, string);
                    } else if (!bl) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string);
                        MultiUserChat.this.fireParticipantStatusListeners("joined", arrayList);
                    }
                } else if (presence.getType() == Presence.Type.unavailable) {
                    MultiUserChat.this.occupantsMap.remove(string);
                    MUCUser mUCUser = MultiUserChat.this.getMUCUserExtension(presence);
                    if (mUCUser != null && mUCUser.getStatus() != null) {
                        MultiUserChat.this.checkPresenceCode(mUCUser.getStatus().getCode(), presence.getFrom().equals(string2), mUCUser, string);
                    } else if (!bl) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string);
                        MultiUserChat.this.fireParticipantStatusListeners("left", arrayList);
                    }
                }
            }
        };
        PacketListener packetListener3 = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                MUCUser mUCUser = MultiUserChat.this.getMUCUserExtension(packet);
                if (mUCUser.getDecline() != null && ((Message)packet).getType() != Message.Type.error) {
                    MultiUserChat.this.fireInvitationRejectionListeners(mUCUser.getDecline().getFrom(), mUCUser.getDecline().getReason());
                }
            }
        };
        PacketMultiplexListener packetMultiplexListener = new PacketMultiplexListener(this.messageCollector, packetListener2, packetListener, packetListener3);
        this.roomListenerMultiplexor = RoomListenerMultiplexor.getRoomMultiplexor(this.connection);
        this.roomListenerMultiplexor.addRoom(this.room, packetMultiplexListener);
    }

    private void checkRoleModifications(String string, String string2, boolean bl, String string3) {
        ArrayList<String> arrayList;
        if (("visitor".equals(string) || "none".equals(string)) && "participant".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("voiceGranted", new Object[0]);
            } else {
                arrayList = new ArrayList<String>();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("voiceGranted", arrayList);
            }
        } else if ("participant".equals(string) && ("visitor".equals(string2) || "none".equals(string2))) {
            if (bl) {
                this.fireUserStatusListeners("voiceRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("voiceRevoked", arrayList);
            }
        }
        if (!"moderator".equals(string) && "moderator".equals(string2)) {
            if ("visitor".equals(string) || "none".equals(string)) {
                if (bl) {
                    this.fireUserStatusListeners("voiceGranted", new Object[0]);
                } else {
                    arrayList = new ArrayList();
                    arrayList.add(string3);
                    this.fireParticipantStatusListeners("voiceGranted", arrayList);
                }
            }
            if (bl) {
                this.fireUserStatusListeners("moderatorGranted", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("moderatorGranted", arrayList);
            }
        } else if ("moderator".equals(string) && !"moderator".equals(string2)) {
            if ("visitor".equals(string2) || "none".equals(string2)) {
                if (bl) {
                    this.fireUserStatusListeners("voiceRevoked", new Object[0]);
                } else {
                    arrayList = new ArrayList();
                    arrayList.add(string3);
                    this.fireParticipantStatusListeners("voiceRevoked", arrayList);
                }
            }
            if (bl) {
                this.fireUserStatusListeners("moderatorRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("moderatorRevoked", arrayList);
            }
        }
    }

    private void checkAffiliationModifications(String string, String string2, boolean bl, String string3) {
        ArrayList<String> arrayList;
        if ("owner".equals(string) && !"owner".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("ownershipRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList<String>();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("ownershipRevoked", arrayList);
            }
        } else if ("admin".equals(string) && !"admin".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("adminRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("adminRevoked", arrayList);
            }
        } else if ("member".equals(string) && !"member".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("membershipRevoked", arrayList);
            }
        }
        if (!"owner".equals(string) && "owner".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("ownershipGranted", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("ownershipGranted", arrayList);
            }
        } else if (!"admin".equals(string) && "admin".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("adminGranted", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("adminGranted", arrayList);
            }
        } else if (!"member".equals(string) && "member".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("membershipGranted", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("membershipGranted", arrayList);
            }
        }
    }

    private void checkPresenceCode(String string, boolean bl, MUCUser mUCUser, String string2) {
        if ("307".equals(string)) {
            if (bl) {
                this.joined = false;
                this.fireUserStatusListeners("kicked", new Object[]{mUCUser.getItem().getActor(), mUCUser.getItem().getReason()});
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                arrayList.add(mUCUser.getItem().getActor());
                arrayList.add(mUCUser.getItem().getReason());
                this.fireParticipantStatusListeners("kicked", arrayList);
            }
        } else if ("301".equals(string)) {
            if (bl) {
                this.joined = false;
                this.fireUserStatusListeners("banned", new Object[]{mUCUser.getItem().getActor(), mUCUser.getItem().getReason()});
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                arrayList.add(mUCUser.getItem().getActor());
                arrayList.add(mUCUser.getItem().getReason());
                this.fireParticipantStatusListeners("banned", arrayList);
            }
        } else if ("321".equals(string)) {
            if (bl) {
                this.joined = false;
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            }
        } else if ("303".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            arrayList.add(mUCUser.getItem().getNick());
            this.fireParticipantStatusListeners("nicknameChanged", arrayList);
        }
    }

    private void cleanup() {
        try {
            if (this.connection != null) {
                this.roomListenerMultiplexor.removeRoom(this.room);
                for (PacketListener packetListener : this.connectionListeners) {
                    this.connection.removePacketListener(packetListener);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    private static class InvitationsMonitor
    implements ConnectionListener {
        private static final Map<Connection, WeakReference<InvitationsMonitor>> monitors = new WeakHashMap<Connection, WeakReference<InvitationsMonitor>>();
        private final List<InvitationListener> invitationsListeners = new ArrayList<InvitationListener>();
        private Connection connection;
        private PacketFilter invitationFilter;
        private PacketListener invitationPacketListener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InvitationsMonitor getInvitationsMonitor(Connection connection) {
            Map<Connection, WeakReference<InvitationsMonitor>> map = monitors;
            synchronized (map) {
                if (!monitors.containsKey(connection) || monitors.get(connection).get() == null) {
                    EMLog.d("InvitationsMonitor", "create a new monitor");
                    InvitationsMonitor invitationsMonitor = new InvitationsMonitor(connection);
                    monitors.put(connection, new WeakReference<InvitationsMonitor>(invitationsMonitor));
                    return invitationsMonitor;
                }
                return (InvitationsMonitor)monitors.get(connection).get();
            }
        }

        private InvitationsMonitor(Connection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInvitationListener(InvitationListener invitationListener) {
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.size() == 0) {
                    this.init();
                }
                if (!this.invitationsListeners.contains(invitationListener)) {
                    this.invitationsListeners.add(invitationListener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeInvitationListener(InvitationListener invitationListener) {
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.contains(invitationListener)) {
                    this.invitationsListeners.remove(invitationListener);
                }
                if (this.invitationsListeners.size() == 0) {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireInvitationListeners(String string, String string2, String string3, String string4, Message message) {
            InvitationListener[] invitationListenerArray;
            Object object = this.invitationsListeners;
            synchronized (object) {
                invitationListenerArray = new InvitationListener[this.invitationsListeners.size()];
                this.invitationsListeners.toArray(invitationListenerArray);
            }
            InvitationListener[] invitationListenerArray2 = invitationListenerArray;
            int n2 = invitationListenerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = invitationListenerArray2[n3];
                object.invitationReceived(this.connection, string, string2, string3, string4, message);
                ++n3;
            }
        }

        @Override
        public void connectionClosed() {
        }

        @Override
        public void connectionClosedOnError(Exception exception) {
        }

        @Override
        public void reconnectingIn(int n2) {
        }

        @Override
        public void reconnectionSuccessful() {
        }

        @Override
        public void reconnectionFailed(Exception exception) {
        }

        private void init() {
            this.invitationFilter = new PacketExtensionFilter("x", "http://jabber.org/protocol/muc#user");
            this.invitationPacketListener = new PacketListener(){

                @Override
                public void processPacket(Packet packet) {
                    MUCUser mUCUser = (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
                    if (mUCUser.getInvite() != null && ((Message)packet).getType() != Message.Type.error) {
                        InvitationsMonitor.this.fireInvitationListeners(packet.getFrom(), mUCUser.getInvite().getFrom(), mUCUser.getInvite().getReason(), mUCUser.getPassword(), (Message)packet);
                    }
                }
            };
            this.connection.addPacketListener(this.invitationPacketListener, this.invitationFilter);
            this.connection.addConnectionListener(this);
        }

        private void cancel() {
            EMLog.d("InvitationsMonitor", "invitationPacketListener = " + this.invitationPacketListener);
            if (this.invitationPacketListener != null) {
                this.connection.removePacketListener(this.invitationPacketListener);
            }
            this.connection.removeConnectionListener(this);
        }
    }
}

