/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.entitycaps.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Base32Encoder;
import org.jivesoftware.smack.util.StringEncoder;
import org.jivesoftware.smackx.entitycaps.EntityCapsManager;
import org.jivesoftware.smackx.entitycaps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.provider.DiscoverInfoProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SimpleDirectoryPersistentCache
implements EntityCapsPersistentCache {
    private File cacheDir;
    private StringEncoder filenameEncoder;

    public SimpleDirectoryPersistentCache(File file) {
        this(file, Base32Encoder.getInstance());
    }

    public SimpleDirectoryPersistentCache(File file, StringEncoder stringEncoder) {
        if (!file.exists()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" is not a directory");
        }
        this.cacheDir = file;
        this.filenameEncoder = stringEncoder;
    }

    @Override
    public void addDiscoverInfoByNodePersistent(String string, DiscoverInfo discoverInfo) {
        String string2 = this.filenameEncoder.encode(string);
        File file = new File(this.cacheDir, string2);
        try {
            if (file.createNewFile()) {
                SimpleDirectoryPersistentCache.writeInfoToFile(file, discoverInfo);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void replay() throws IOException {
        File[] fileArray;
        File[] fileArray2 = fileArray = this.cacheDir.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray2[n3];
            String string = this.filenameEncoder.decode(file.getName());
            DiscoverInfo discoverInfo = SimpleDirectoryPersistentCache.restoreInfoFromFile(file);
            if (discoverInfo != null) {
                EntityCapsManager.addDiscoverInfoByNode(string, discoverInfo);
            }
            ++n3;
        }
    }

    @Override
    public void emptyCache() {
        File[] fileArray;
        File[] fileArray2 = fileArray = this.cacheDir.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray2[n3];
            file.delete();
            ++n3;
        }
    }

    private static void writeInfoToFile(File file, DiscoverInfo discoverInfo) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        try {
            dataOutputStream.writeUTF(discoverInfo.toXML());
        }
        finally {
            dataOutputStream.close();
        }
    }

    private static DiscoverInfo restoreInfoFromFile(File file) throws IOException {
        DiscoverInfo discoverInfo;
        String string;
        String string2;
        String string3;
        XmlPullParser xmlPullParser;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        String string4 = null;
        try {
            string4 = dataInputStream.readUTF();
        }
        finally {
            dataInputStream.close();
        }
        if (string4 == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string4);
        try {
            xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            xmlPullParser.setInput((Reader)stringReader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            return null;
        }
        DiscoverInfoProvider discoverInfoProvider = new DiscoverInfoProvider();
        try {
            xmlPullParser.next();
            string3 = xmlPullParser.getAttributeValue("", "id");
            string2 = xmlPullParser.getAttributeValue("", "from");
            string = xmlPullParser.getAttributeValue("", "to");
            xmlPullParser.next();
        }
        catch (XmlPullParserException xmlPullParserException) {
            return null;
        }
        try {
            discoverInfo = (DiscoverInfo)discoverInfoProvider.parseIQ(xmlPullParser);
        }
        catch (Exception exception) {
            return null;
        }
        discoverInfo.setPacketID(string3);
        discoverInfo.setFrom(string2);
        discoverInfo.setTo(string);
        discoverInfo.setType(IQ.Type.RESULT);
        return discoverInfo;
    }
}

