/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.entitycaps;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.entitycaps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.entitycaps.packet.CapsExtension;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class EntityCapsManager {
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    public static final String ELEMENT = "c";
    private static final String ENTITY_NODE = "http://www.igniterealtime.org/projects/smack";
    private static final Map<String, MessageDigest> SUPPORTED_HASHES = new HashMap<String, MessageDigest>();
    protected static EntityCapsPersistentCache persistentCache;
    private static Map<Connection, EntityCapsManager> instances;
    protected static Map<String, DiscoverInfo> caps;
    protected static Map<String, NodeVerHash> jidCaps;
    private WeakReference<Connection> weakRefConnection;
    private ServiceDiscoveryManager sdm;
    private boolean entityCapsEnabled;
    private String currentCapsVersion;
    private boolean presenceSend = false;
    private Queue<String> lastLocalCapsVersions = new ConcurrentLinkedQueue<String>();

    static {
        instances = Collections.synchronizedMap(new WeakHashMap());
        caps = new Cache<String, DiscoverInfo>(1000, -1L);
        jidCaps = new Cache<String, NodeVerHash>(10000, -1L);
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                EntityCapsManager.getInstanceFor(connection);
            }
        });
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            SUPPORTED_HASHES.put("sha-1", messageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static void addDiscoverInfoByNode(String string, DiscoverInfo discoverInfo) {
        caps.put(string, discoverInfo);
        if (persistentCache != null) {
            persistentCache.addDiscoverInfoByNodePersistent(string, discoverInfo);
        }
    }

    public static String getNodeVersionByJid(String string) {
        NodeVerHash nodeVerHash = jidCaps.get(string);
        if (nodeVerHash != null) {
            return nodeVerHash.nodeVer;
        }
        return null;
    }

    public static NodeVerHash getNodeVerHashByJid(String string) {
        return jidCaps.get(string);
    }

    public static DiscoverInfo getDiscoverInfoByUser(String string) {
        NodeVerHash nodeVerHash = jidCaps.get(string);
        if (nodeVerHash == null) {
            return null;
        }
        return EntityCapsManager.getDiscoveryInfoByNodeVer(nodeVerHash.nodeVer);
    }

    public static DiscoverInfo getDiscoveryInfoByNodeVer(String string) {
        DiscoverInfo discoverInfo = caps.get(string);
        if (discoverInfo != null) {
            discoverInfo = new DiscoverInfo(discoverInfo);
        }
        return discoverInfo;
    }

    public static void setPersistentCache(EntityCapsPersistentCache entityCapsPersistentCache) throws IOException {
        if (persistentCache != null) {
            throw new IllegalStateException("Entity Caps Persistent Cache was already set");
        }
        persistentCache = entityCapsPersistentCache;
        persistentCache.replay();
    }

    public static void setJidCapsMaxCacheSize(int n2) {
        ((Cache)jidCaps).setMaxCacheSize(n2);
    }

    public static void setCapsMaxCacheSize(int n2) {
        ((Cache)caps).setMaxCacheSize(n2);
    }

    private EntityCapsManager(Connection connection) {
        this.weakRefConnection = new WeakReference<Connection>(connection);
        this.sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        instances.put(connection, this);
        connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                EntityCapsManager.this.presenceSend = false;
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                EntityCapsManager.this.presenceSend = false;
            }

            @Override
            public void reconnectionFailed(Exception exception) {
            }

            @Override
            public void reconnectingIn(int n2) {
            }

            @Override
            public void reconnectionSuccessful() {
            }
        });
        this.updateLocalEntityCaps();
        if (SmackConfiguration.autoEnableEntityCaps()) {
            this.enableEntityCaps();
        }
        PacketFilter packetFilter = new AndFilter(new PacketTypeFilter(Presence.class), new PacketExtensionFilter(ELEMENT, NAMESPACE));
        connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                CapsExtension capsExtension = null;
                try {
                    capsExtension = (CapsExtension)packet.getExtension(EntityCapsManager.ELEMENT, EntityCapsManager.NAMESPACE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (capsExtension == null) {
                    return;
                }
                String string = capsExtension.getHash().toLowerCase();
                if (!SUPPORTED_HASHES.containsKey(string)) {
                    return;
                }
                String string2 = packet.getFrom();
                String string3 = capsExtension.getNode();
                String string4 = capsExtension.getVer();
                jidCaps.put(string2, new NodeVerHash(string3, string4, string));
            }
        }, packetFilter);
        packetFilter = new AndFilter(new PacketTypeFilter(Presence.class), new NotFilter(new PacketExtensionFilter(ELEMENT, NAMESPACE)));
        connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                String string = packet.getFrom();
                jidCaps.remove(string);
            }
        }, packetFilter);
        packetFilter = new PacketTypeFilter(Presence.class);
        connection.addPacketSendingListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                EntityCapsManager.this.presenceSend = true;
            }
        }, packetFilter);
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(Presence.class);
        PacketInterceptor packetInterceptor = new PacketInterceptor(){

            @Override
            public void interceptPacket(Packet packet) {
                if (!EntityCapsManager.this.entityCapsEnabled) {
                    return;
                }
                CapsExtension capsExtension = new CapsExtension(EntityCapsManager.ENTITY_NODE, EntityCapsManager.this.getCapsVersion(), "sha-1");
                packet.addExtension(capsExtension);
            }
        };
        connection.addPacketInterceptor(packetInterceptor, packetTypeFilter);
        this.sdm.setEntityCapsManager(this);
    }

    public static synchronized EntityCapsManager getInstanceFor(Connection connection) {
        if (SUPPORTED_HASHES.size() <= 0) {
            throw new IllegalStateException("No supported hashes for EntityCapsManager");
        }
        EntityCapsManager entityCapsManager = instances.get(connection);
        if (entityCapsManager == null) {
            entityCapsManager = new EntityCapsManager(connection);
        }
        return entityCapsManager;
    }

    public void enableEntityCaps() {
        this.sdm.addFeature(NAMESPACE);
        this.updateLocalEntityCaps();
        this.entityCapsEnabled = true;
    }

    public void disableEntityCaps() {
        this.entityCapsEnabled = false;
        this.sdm.removeFeature(NAMESPACE);
    }

    public boolean entityCapsEnabled() {
        return this.entityCapsEnabled;
    }

    public void removeUserCapsNode(String string) {
        jidCaps.remove(string);
    }

    public String getCapsVersion() {
        return this.currentCapsVersion;
    }

    public String getLocalNodeVer() {
        return "http://www.igniterealtime.org/projects/smack#" + this.getCapsVersion();
    }

    public boolean areEntityCapsSupported(String string) {
        if (string == null) {
            return false;
        }
        try {
            DiscoverInfo discoverInfo = this.sdm.discoverInfo(string);
            return discoverInfo.containsFeature(NAMESPACE);
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }

    public boolean areEntityCapsSupportedByServer() {
        return this.areEntityCapsSupported(((Connection)this.weakRefConnection.get()).getServiceName());
    }

    public void updateLocalEntityCaps() {
        Object object;
        Connection connection = (Connection)this.weakRefConnection.get();
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setType(IQ.Type.RESULT);
        discoverInfo.setNode(this.getLocalNodeVer());
        if (connection != null) {
            discoverInfo.setFrom(connection.getUser());
        }
        this.sdm.addDiscoverInfoTo(discoverInfo);
        this.currentCapsVersion = EntityCapsManager.generateVerificationString(discoverInfo, "sha-1");
        EntityCapsManager.addDiscoverInfoByNode("http://www.igniterealtime.org/projects/smack#" + this.currentCapsVersion, discoverInfo);
        if (this.lastLocalCapsVersions.size() > 10) {
            object = this.lastLocalCapsVersions.poll();
            this.sdm.removeNodeInformationProvider("http://www.igniterealtime.org/projects/smack#" + (String)object);
        }
        this.lastLocalCapsVersions.add(this.currentCapsVersion);
        caps.put(this.currentCapsVersion, discoverInfo);
        if (connection != null) {
            jidCaps.put(connection.getUser(), new NodeVerHash(ENTITY_NODE, this.currentCapsVersion, "sha-1"));
        }
        object = new LinkedList<DiscoverInfo.Identity>(ServiceDiscoveryManager.getInstanceFor(connection).getIdentities());
        this.sdm.setNodeInformationProvider("http://www.igniterealtime.org/projects/smack#" + this.currentCapsVersion, new NodeInformationProvider((List)object){
            List<String> features;
            List<PacketExtension> packetExtensions;
            private final /* synthetic */ List val$identities;
            {
                this.val$identities = list;
                this.features = EntityCapsManager.this.sdm.getFeaturesList();
                this.packetExtensions = EntityCapsManager.this.sdm.getExtendedInfoAsList();
            }

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                return null;
            }

            @Override
            public List<String> getNodeFeatures() {
                return this.features;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return this.val$identities;
            }

            @Override
            public List<PacketExtension> getNodePacketExtensions() {
                return this.packetExtensions;
            }
        });
        if (connection != null && connection.isAuthenticated() && this.presenceSend) {
            Presence presence = new Presence(Presence.Type.available);
            connection.sendPacket(presence);
        }
    }

    public static boolean verifyDiscoverInfoVersion(String string, String string2, DiscoverInfo discoverInfo) {
        if (discoverInfo.containsDuplicateIdentities()) {
            return false;
        }
        if (discoverInfo.containsDuplicateFeatures()) {
            return false;
        }
        if (EntityCapsManager.verifyPacketExtensions(discoverInfo)) {
            return false;
        }
        String string3 = EntityCapsManager.generateVerificationString(discoverInfo, string2);
        return string.equals(string3);
    }

    protected static boolean verifyPacketExtensions(DiscoverInfo discoverInfo) {
        LinkedList<FormField> linkedList = new LinkedList<FormField>();
        for (PacketExtension packetExtension : discoverInfo.getExtensions()) {
            if (!packetExtension.getNamespace().equals("jabber:x:data")) continue;
            DataForm dataForm = (DataForm)packetExtension;
            Iterator<FormField> iterator = dataForm.getFields();
            while (iterator.hasNext()) {
                FormField formField = iterator.next();
                if (!formField.getVariable().equals("FORM_TYPE")) continue;
                for (FormField formField2 : linkedList) {
                    if (!formField.equals(formField2)) continue;
                    return true;
                }
                linkedList.add(formField);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String generateVerificationString(DiscoverInfo discoverInfo, String string) {
        MessageDigest messageDigest = SUPPORTED_HASHES.get(string.toLowerCase());
        if (messageDigest == null) {
            return null;
        }
        DataForm dataForm = (DataForm)discoverInfo.getExtension("x", "jabber:x:data");
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet<DiscoverInfo.Identity> treeSet = new TreeSet<DiscoverInfo.Identity>();
        Object object2 = discoverInfo.getIdentities();
        while (object2.hasNext()) {
            treeSet.add(object2.next());
        }
        for (DiscoverInfo.Identity object3 : treeSet) {
            stringBuilder.append(object3.getCategory());
            stringBuilder.append("/");
            stringBuilder.append(object3.getType());
            stringBuilder.append("/");
            stringBuilder.append(object3.getLanguage() == null ? "" : object3.getLanguage());
            stringBuilder.append("/");
            stringBuilder.append(object3.getName() == null ? "" : object3.getName());
            stringBuilder.append("<");
        }
        object2 = new TreeSet();
        Iterator<DiscoverInfo.Feature> iterator = discoverInfo.getFeatures();
        while (iterator.hasNext()) {
            object2.add(iterator.next().getVar());
        }
        Object object = object2.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            stringBuilder.append(string2);
            stringBuilder.append("<");
        }
        if (dataForm != null && dataForm.hasHiddenFormTypeField()) {
            DataForm dataForm2 = dataForm;
            synchronized (dataForm2) {
                Object object3;
                object = new TreeSet<FormField>(new Comparator<FormField>(){

                    @Override
                    public int compare(FormField formField, FormField formField2) {
                        return formField.getVariable().compareTo(formField2.getVariable());
                    }
                });
                Object object4 = null;
                Object object5 = dataForm.getFields();
                while (object5.hasNext()) {
                    object3 = object5.next();
                    if (!((FormField)object3).getVariable().equals("FORM_TYPE")) {
                        object.add(object3);
                        continue;
                    }
                    object4 = object3;
                }
                if (object4 != null) {
                    EntityCapsManager.formFieldValuesToCaps(((FormField)object4).getValues(), stringBuilder);
                }
                object3 = object.iterator();
                while (object3.hasNext()) {
                    object5 = (FormField)object3.next();
                    stringBuilder.append(((FormField)object5).getVariable());
                    stringBuilder.append("<");
                    EntityCapsManager.formFieldValuesToCaps(((FormField)object5).getValues(), stringBuilder);
                }
            }
        }
        byte[] byArray = messageDigest.digest(stringBuilder.toString().getBytes());
        return Base64.encodeBytes(byArray);
    }

    private static void formFieldValuesToCaps(Iterator<String> iterator, StringBuilder stringBuilder) {
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        for (String string : treeSet) {
            stringBuilder.append(string);
            stringBuilder.append("<");
        }
    }

    public static class NodeVerHash {
        private String node;
        private String hash;
        private String ver;
        private String nodeVer;

        NodeVerHash(String string, String string2, String string3) {
            this.node = string;
            this.ver = string2;
            this.hash = string3;
            this.nodeVer = String.valueOf(string) + "#" + string2;
        }

        public String getNodeVer() {
            return this.nodeVer;
        }

        public String getNode() {
            return this.node;
        }

        public String getHash() {
            return this.hash;
        }

        public String getVer() {
            return this.ver;
        }
    }
}

