/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.RemoteRosterEntry;
import org.jivesoftware.smackx.RosterExchangeListener;
import org.jivesoftware.smackx.packet.RosterExchange;

public class RosterExchangeManager {
    private List<RosterExchangeListener> rosterExchangeListeners = new ArrayList<RosterExchangeListener>();
    private Connection con;
    private PacketFilter packetFilter = new PacketExtensionFilter("x", "jabber:x:roster");
    private PacketListener packetListener;

    public RosterExchangeManager(Connection connection) {
        this.con = connection;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterListener(RosterExchangeListener rosterExchangeListener) {
        List<RosterExchangeListener> list = this.rosterExchangeListeners;
        synchronized (list) {
            if (!this.rosterExchangeListeners.contains(rosterExchangeListener)) {
                this.rosterExchangeListeners.add(rosterExchangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRosterListener(RosterExchangeListener rosterExchangeListener) {
        List<RosterExchangeListener> list = this.rosterExchangeListeners;
        synchronized (list) {
            this.rosterExchangeListeners.remove(rosterExchangeListener);
        }
    }

    public void send(Roster roster, String string) {
        Message message = new Message(string);
        RosterExchange rosterExchange = new RosterExchange(roster);
        message.addExtension(rosterExchange);
        this.con.sendPacket(message);
    }

    public void send(RosterEntry rosterEntry, String string) {
        Message message = new Message(string);
        RosterExchange rosterExchange = new RosterExchange();
        rosterExchange.addRosterEntry(rosterEntry);
        message.addExtension(rosterExchange);
        this.con.sendPacket(message);
    }

    public void send(RosterGroup rosterGroup, String string) {
        Message message = new Message(string);
        RosterExchange rosterExchange = new RosterExchange();
        for (RosterEntry rosterEntry : rosterGroup.getEntries()) {
            rosterExchange.addRosterEntry(rosterEntry);
        }
        message.addExtension(rosterExchange);
        this.con.sendPacket(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterExchangeListeners(String string, Iterator<RemoteRosterEntry> iterator) {
        RosterExchangeListener[] rosterExchangeListenerArray = null;
        List<RosterExchangeListener> list = this.rosterExchangeListeners;
        synchronized (list) {
            rosterExchangeListenerArray = new RosterExchangeListener[this.rosterExchangeListeners.size()];
            this.rosterExchangeListeners.toArray(rosterExchangeListenerArray);
        }
        int n2 = 0;
        while (n2 < rosterExchangeListenerArray.length) {
            rosterExchangeListenerArray[n2].entriesReceived(string, iterator);
            ++n2;
        }
    }

    private void init() {
        this.packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                RosterExchange rosterExchange = (RosterExchange)message.getExtension("x", "jabber:x:roster");
                RosterExchangeManager.this.fireRosterExchangeListeners(message.getFrom(), rosterExchange.getRosterEntries());
            }
        };
        this.con.addPacketListener(this.packetListener, this.packetFilter);
    }

    public void destroy() {
        if (this.con != null) {
            this.con.removePacketListener(this.packetListener);
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }
}

