/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.LastActivity;

public class LastActivityManager {
    private long lastMessageSent;
    private Connection connection;

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new LastActivityManager(connection, null);
            }
        });
    }

    private LastActivityManager(Connection connection) {
        this.connection = connection;
        connection.addPacketSendingListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                Presence.Mode mode = presence.getMode();
                if (mode == null) {
                    return;
                }
                switch (mode) {
                    case chat: 
                    case available: {
                        LastActivityManager.this.resetIdleTime();
                    }
                }
            }
        }, new PacketTypeFilter(Presence.class));
        connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                if (message.getType() == Message.Type.error) {
                    return;
                }
                LastActivityManager.this.resetIdleTime();
            }
        }, new PacketTypeFilter(Message.class));
        connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                LastActivity lastActivity = new LastActivity();
                lastActivity.setType(IQ.Type.RESULT);
                lastActivity.setTo(packet.getFrom());
                lastActivity.setFrom(packet.getTo());
                lastActivity.setPacketID(packet.getPacketID());
                lastActivity.setLastActivity(LastActivityManager.this.getIdleTime());
                LastActivityManager.this.connection.sendPacket(lastActivity);
            }
        }, new AndFilter(new IQTypeFilter(IQ.Type.GET), new PacketTypeFilter(LastActivity.class)));
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature("jabber:iq:last");
        this.resetIdleTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIdleTime() {
        long l2 = System.currentTimeMillis();
        LastActivityManager lastActivityManager = this;
        synchronized (lastActivityManager) {
            this.lastMessageSent = l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIdleTime() {
        long l2;
        long l3 = System.currentTimeMillis();
        LastActivityManager lastActivityManager = this;
        synchronized (lastActivityManager) {
            l2 = this.lastMessageSent;
        }
        return (l3 - l2) / 1000L;
    }

    public static LastActivity getLastActivity(Connection connection, String string) throws XMPPException {
        LastActivity lastActivity = new LastActivity();
        lastActivity.setTo(string);
        PacketCollector packetCollector = connection.createPacketCollector(new PacketIDFilter(lastActivity.getPacketID()));
        connection.sendPacket(lastActivity);
        LastActivity lastActivity2 = (LastActivity)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (lastActivity2 == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (lastActivity2.getError() != null) {
            throw new XMPPException(lastActivity2.getError());
        }
        return lastActivity2;
    }

    public static boolean isLastActivitySupported(Connection connection, String string) {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(string);
            return discoverInfo.containsFeature("jabber:iq:last");
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }

    /* synthetic */ LastActivityManager(Connection connection, LastActivityManager lastActivityManager) {
        this(connection);
    }
}

