/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import org.jivesoftware.smack.util.dns.HostAddress;

public class SRVRecord
extends HostAddress
implements Comparable<SRVRecord> {
    private int weight;
    private int priority;

    public SRVRecord(String string, int n2, int n3, int n4) {
        super(string, n2);
        if (n4 < 0 || n4 > 65535) {
            throw new IllegalArgumentException("DNS SRV records weight must be a 16-bit unsiged integer (i.e. between 0-65535. Weight was: " + n4);
        }
        if (n3 < 0 || n3 > 65535) {
            throw new IllegalArgumentException("DNS SRV records priority must be a 16-bit unsiged integer (i.e. between 0-65535. Priority was: " + n3);
        }
        this.priority = n3;
        this.weight = n4;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(SRVRecord sRVRecord) {
        int n2 = sRVRecord.priority - this.priority;
        if (n2 == 0) {
            n2 = this.weight - sRVRecord.weight;
        }
        return n2;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " prio:" + this.priority + ":w:" + this.weight;
    }
}

