/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

public class HostAddress {
    private String fqdn;
    private int port;
    private Exception exception;

    public HostAddress(String string) {
        if (string == null) {
            throw new IllegalArgumentException("FQDN is null");
        }
        this.fqdn = string.charAt(string.length() - 1) == '.' ? string.substring(0, string.length() - 1) : string;
        this.port = 5222;
    }

    public HostAddress(String string, int n2) {
        this(string);
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("DNS SRV records weight must be a 16-bit unsiged integer (i.e. between 0-65535. Port was: " + n2);
        }
        this.port = n2;
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public int getPort() {
        return this.port;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String toString() {
        return String.valueOf(this.fqdn) + ":" + this.port;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HostAddress)) {
            return false;
        }
        HostAddress hostAddress = (HostAddress)object;
        if (!this.fqdn.equals(hostAddress.fqdn)) {
            return false;
        }
        return this.port == hostAddress.port;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 37 * n2 + this.fqdn.hashCode();
        return n2 * 37 + this.port;
    }

    public String getErrorMessage() {
        String string = this.exception == null ? "No error logged" : this.exception.getMessage();
        return String.valueOf(this.toString()) + " Exception: " + string;
    }
}

