/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jivesoftware.smack.util.collections.EmptyIterator;
import org.jivesoftware.smack.util.collections.EmptyMapIterator;
import org.jivesoftware.smack.util.collections.IterableMap;
import org.jivesoftware.smack.util.collections.KeyValue;
import org.jivesoftware.smack.util.collections.MapIterator;

public class AbstractHashedMap<K, V>
extends AbstractMap<K, V>
implements IterableMap<K, V> {
    protected static final String NO_NEXT_ENTRY = "No next() entry in the iteration";
    protected static final String NO_PREVIOUS_ENTRY = "No previous() entry in the iteration";
    protected static final String REMOVE_INVALID = "remove() can only be called once after next()";
    protected static final String GETKEY_INVALID = "getKey() can only be called after next() and before remove()";
    protected static final String GETVALUE_INVALID = "getValue() can only be called after next() and before remove()";
    protected static final String SETVALUE_INVALID = "setValue() can only be called after next() and before remove()";
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final int DEFAULT_THRESHOLD = 12;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final Object NULL = new Object();
    protected transient float loadFactor;
    protected transient int size;
    protected transient HashEntry<K, V>[] data;
    protected transient int threshold;
    protected transient int modCount;
    protected transient EntrySet<K, V> entrySet;
    protected transient KeySet<K, V> keySet;
    protected transient Values<K, V> values;

    protected AbstractHashedMap() {
    }

    protected AbstractHashedMap(int n2, float f2, int n3) {
        this.loadFactor = f2;
        this.data = new HashEntry[n2];
        this.threshold = n3;
        this.init();
    }

    protected AbstractHashedMap(int n2) {
        this(n2, 0.75f);
    }

    protected AbstractHashedMap(int n2, float f2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Load factor must be greater than 0");
        }
        this.loadFactor = f2;
        this.threshold = this.calculateThreshold(n2, f2);
        n2 = this.calculateNewCapacity(n2);
        this.data = new HashEntry[n2];
        this.init();
    }

    protected AbstractHashedMap(Map<? extends K, ? extends V> map) {
        this(Math.max(2 * map.size(), 16), 0.75f);
        this.putAll(map);
    }

    protected void init() {
    }

    @Override
    public V get(Object object) {
        int n2 = this.hash(object == null ? NULL : object);
        HashEntry<K, V> hashEntry = this.data[this.hashIndex(n2, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(object, ((HashEntry)hashEntry).key)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        int n2 = this.hash(object == null ? NULL : object);
        HashEntry<K, V> hashEntry = this.data[this.hashIndex(n2, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(object, hashEntry.getKey())) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            int n2 = 0;
            int n3 = this.data.length;
            while (n2 < n3) {
                HashEntry<K, V> hashEntry = this.data[n2];
                while (hashEntry != null) {
                    if (hashEntry.getValue() == null) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            int n5 = this.data.length;
            while (n4 < n5) {
                HashEntry<K, V> hashEntry = this.data[n4];
                while (hashEntry != null) {
                    if (this.isEqualValue(object, hashEntry.getValue())) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
                ++n4;
            }
        }
        return false;
    }

    @Override
    public V put(K k2, V v2) {
        int n2 = this.hash(k2 == null ? NULL : k2);
        int n3 = this.hashIndex(n2, this.data.length);
        HashEntry<K, V> hashEntry = this.data[n3];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(k2, hashEntry.getKey())) {
                V v3 = hashEntry.getValue();
                this.updateEntry(hashEntry, v2);
                return v3;
            }
            hashEntry = hashEntry.next;
        }
        this.addMapping(n3, n2, k2, v2);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        int n3 = (int)((float)(this.size + n2) / this.loadFactor + 1.0f);
        this.ensureCapacity(this.calculateNewCapacity(n3));
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n2 = this.hash(object == null ? NULL : object);
        int n3 = this.hashIndex(n2, this.data.length);
        HashEntry<K, V> hashEntry = this.data[n3];
        HashEntry<K, V> hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(object, hashEntry.getKey())) {
                V v2 = hashEntry.getValue();
                this.removeMapping(hashEntry, n3, hashEntry2);
                return v2;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        HashEntry<K, V>[] hashEntryArray = this.data;
        int n2 = hashEntryArray.length - 1;
        while (n2 >= 0) {
            hashEntryArray[n2] = null;
            --n2;
        }
        this.size = 0;
    }

    protected int hash(Object object) {
        int n2 = object.hashCode();
        n2 += ~(n2 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2;
    }

    protected boolean isEqualKey(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    protected boolean isEqualValue(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected int hashIndex(int n2, int n3) {
        return n2 & n3 - 1;
    }

    protected HashEntry<K, V> getEntry(Object object) {
        int n2 = this.hash(object == null ? NULL : object);
        HashEntry<K, V> hashEntry = this.data[this.hashIndex(n2, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(object, hashEntry.getKey())) {
                return hashEntry;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected void updateEntry(HashEntry<K, V> hashEntry, V v2) {
        hashEntry.setValue(v2);
    }

    protected void reuseEntry(HashEntry<K, V> hashEntry, int n2, int n3, K k2, V v2) {
        hashEntry.next = this.data[n2];
        hashEntry.hashCode = n3;
        ((HashEntry)hashEntry).key = k2;
        ((HashEntry)hashEntry).value = v2;
    }

    protected void addMapping(int n2, int n3, K k2, V v2) {
        ++this.modCount;
        HashEntry<K, V> hashEntry = this.createEntry(this.data[n2], n3, k2, v2);
        this.addEntry(hashEntry, n2);
        ++this.size;
        this.checkCapacity();
    }

    protected HashEntry<K, V> createEntry(HashEntry<K, V> hashEntry, int n2, K k2, V v2) {
        return new HashEntry<K, V>(hashEntry, n2, k2, v2);
    }

    protected void addEntry(HashEntry<K, V> hashEntry, int n2) {
        this.data[n2] = hashEntry;
    }

    protected void removeMapping(HashEntry<K, V> hashEntry, int n2, HashEntry<K, V> hashEntry2) {
        ++this.modCount;
        this.removeEntry(hashEntry, n2, hashEntry2);
        --this.size;
        this.destroyEntry(hashEntry);
    }

    protected void removeEntry(HashEntry<K, V> hashEntry, int n2, HashEntry<K, V> hashEntry2) {
        if (hashEntry2 == null) {
            this.data[n2] = hashEntry.next;
        } else {
            hashEntry2.next = hashEntry.next;
        }
    }

    protected void destroyEntry(HashEntry<K, V> hashEntry) {
        hashEntry.next = null;
        ((HashEntry)hashEntry).key = null;
        ((HashEntry)hashEntry).value = null;
    }

    protected void checkCapacity() {
        int n2;
        if (this.size >= this.threshold && (n2 = this.data.length * 2) <= 0x40000000) {
            this.ensureCapacity(n2);
        }
    }

    protected void ensureCapacity(int n2) {
        int n3 = this.data.length;
        if (n2 <= n3) {
            return;
        }
        if (this.size == 0) {
            this.threshold = this.calculateThreshold(n2, this.loadFactor);
            this.data = new HashEntry[n2];
        } else {
            HashEntry<K, V>[] hashEntryArray = this.data;
            HashEntry[] hashEntryArray2 = new HashEntry[n2];
            ++this.modCount;
            int n4 = n3 - 1;
            while (n4 >= 0) {
                HashEntry<K, V> hashEntry = hashEntryArray[n4];
                if (hashEntry != null) {
                    HashEntry hashEntry2;
                    hashEntryArray[n4] = null;
                    do {
                        hashEntry2 = hashEntry.next;
                        int n5 = this.hashIndex(hashEntry.hashCode, n2);
                        hashEntry.next = hashEntryArray2[n5];
                        hashEntryArray2[n5] = hashEntry;
                    } while ((hashEntry = hashEntry2) != null);
                }
                --n4;
            }
            this.threshold = this.calculateThreshold(n2, this.loadFactor);
            this.data = hashEntryArray2;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int calculateNewCapacity(int var1_1) {
        block2: {
            var2_2 = 1;
            if (var1_1 <= 0x40000000) ** GOTO lbl6
            var2_2 = 0x40000000;
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_2 <<= 1;
lbl6:
                // 2 sources

                ** while (var2_2 < var1_1)
            }
lbl7:
            // 1 sources

            if (var2_2 > 0x40000000) {
                var2_2 = 0x40000000;
            }
        }
        return var2_2;
    }

    protected int calculateThreshold(int n2, float f2) {
        return (int)((float)n2 * f2);
    }

    protected HashEntry<K, V> entryNext(HashEntry<K, V> hashEntry) {
        return hashEntry.next;
    }

    protected int entryHashCode(HashEntry<K, V> hashEntry) {
        return hashEntry.hashCode;
    }

    protected K entryKey(HashEntry<K, V> hashEntry) {
        return (K)((HashEntry)hashEntry).key;
    }

    protected V entryValue(HashEntry<K, V> hashEntry) {
        return (V)((HashEntry)hashEntry).value;
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        if (this.size == 0) {
            return EmptyMapIterator.INSTANCE;
        }
        return new HashMapIterator(this);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new EntrySetIterator(this);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    protected Iterator<K> createKeySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new KeySetIterator(this);
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected Iterator<V> createValuesIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(this);
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.writeInt(this.size);
        MapIterator<K, V> mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            objectOutputStream.writeObject(mapIterator.next());
            objectOutputStream.writeObject(mapIterator.getValue());
        }
    }

    protected void doReadObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.loadFactor = objectInputStream.readFloat();
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        this.init();
        this.data = new HashEntry[n2];
        int n4 = 0;
        while (n4 < n3) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n4;
        }
        this.threshold = this.calculateThreshold(this.data.length, this.loadFactor);
    }

    @Override
    protected Object clone() {
        try {
            AbstractHashedMap abstractHashedMap = (AbstractHashedMap)super.clone();
            abstractHashedMap.data = new HashEntry[this.data.length];
            abstractHashedMap.entrySet = null;
            abstractHashedMap.keySet = null;
            abstractHashedMap.values = null;
            abstractHashedMap.modCount = 0;
            abstractHashedMap.size = 0;
            abstractHashedMap.init();
            abstractHashedMap.putAll(this);
            return abstractHashedMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        MapIterator<K, V> mapIterator = this.mapIterator();
        try {
            while (true) {
                if (!mapIterator.hasNext()) {
                    return true;
                }
                K k2 = mapIterator.next();
                V v2 = mapIterator.getValue();
                if (v2 == null) {
                    if (map.get(k2) != null) return false;
                    if (map.containsKey(k2)) continue;
                    return false;
                }
                if (!v2.equals(map.get(k2))) break;
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Iterator<Map.Entry<K, V>> iterator = this.createEntrySetIterator();
        while (iterator.hasNext()) {
            n2 += ((Object)iterator.next()).hashCode();
        }
        return n2;
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32 * this.size());
        stringBuilder.append('{');
        MapIterator<K, V> mapIterator = this.mapIterator();
        boolean bl = mapIterator.hasNext();
        while (bl) {
            K k2 = mapIterator.next();
            V v2 = mapIterator.getValue();
            stringBuilder.append((Object)(k2 == this ? "(this Map)" : k2)).append('=').append((Object)(v2 == this ? "(this Map)" : v2));
            bl = mapIterator.hasNext();
            if (!bl) continue;
            stringBuilder.append(',').append(' ');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    protected static class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        protected final AbstractHashedMap<K, V> parent;

        protected EntrySet(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Map.Entry<K, V> entry) {
            Map.Entry<K, V> entry2 = entry;
            HashEntry<K, V> hashEntry = this.parent.getEntry(entry2.getKey());
            return hashEntry != null && hashEntry.equals(entry2);
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            if (!this.contains(object)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = entry.getKey();
            this.parent.remove(k2);
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.parent.createEntrySetIterator();
        }
    }

    protected static class EntrySetIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        protected EntrySetIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public HashEntry<K, V> next() {
            return super.nextEntry();
        }
    }

    protected static class HashEntry<K, V>
    implements Map.Entry<K, V>,
    KeyValue<K, V> {
        protected HashEntry<K, V> next;
        protected int hashCode;
        private K key;
        private V value;

        protected HashEntry(HashEntry<K, V> hashEntry, int n2, K k2, V v2) {
            this.next = hashEntry;
            this.hashCode = n2;
            this.key = k2;
            this.value = v2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public void setKey(K k2) {
            this.key = k2;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    protected static abstract class HashIterator<K, V> {
        protected final AbstractHashedMap parent;
        protected int hashIndex;
        protected HashEntry<K, V> last;
        protected HashEntry<K, V> next;
        protected int expectedModCount;

        protected HashIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
            HashEntry<K, V>[] hashEntryArray = abstractHashedMap.data;
            int n2 = hashEntryArray.length;
            HashEntry hashEntry = null;
            while (n2 > 0 && hashEntry == null) {
                hashEntry = hashEntryArray[--n2];
            }
            this.next = hashEntry;
            this.hashIndex = n2;
            this.expectedModCount = abstractHashedMap.modCount;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        protected HashEntry<K, V> nextEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            HashEntry<K, V> hashEntry = this.next;
            if (hashEntry == null) {
                throw new NoSuchElementException(AbstractHashedMap.NO_NEXT_ENTRY);
            }
            HashEntry<K, V>[] hashEntryArray = this.parent.data;
            int n2 = this.hashIndex;
            HashEntry hashEntry2 = hashEntry.next;
            while (hashEntry2 == null && n2 > 0) {
                hashEntry2 = hashEntryArray[--n2];
            }
            this.next = hashEntry2;
            this.hashIndex = n2;
            this.last = hashEntry;
            return hashEntry;
        }

        protected HashEntry<K, V> currentEntry() {
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException(AbstractHashedMap.REMOVE_INVALID);
            }
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.parent.remove(this.last.getKey());
            this.last = null;
            this.expectedModCount = this.parent.modCount;
        }

        public String toString() {
            if (this.last != null) {
                return "Iterator[" + this.last.getKey() + "=" + this.last.getValue() + "]";
            }
            return "Iterator[]";
        }
    }

    protected static class HashMapIterator<K, V>
    extends HashIterator<K, V>
    implements MapIterator<K, V> {
        protected HashMapIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public K next() {
            return super.nextEntry().getKey();
        }

        @Override
        public K getKey() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETKEY_INVALID);
            }
            return hashEntry.getKey();
        }

        @Override
        public V getValue() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETVALUE_INVALID);
            }
            return hashEntry.getValue();
        }

        @Override
        public V setValue(V v2) {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.SETVALUE_INVALID);
            }
            return hashEntry.setValue(v2);
        }
    }

    protected static class KeySet<K, V>
    extends AbstractSet<K> {
        protected final AbstractHashedMap<K, V> parent;

        protected KeySet(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.parent.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = this.parent.containsKey(object);
            this.parent.remove(object);
            return bl;
        }

        @Override
        public Iterator<K> iterator() {
            return this.parent.createKeySetIterator();
        }
    }

    protected static class KeySetIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<K> {
        protected KeySetIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public K next() {
            return super.nextEntry().getKey();
        }
    }

    protected static class Values<K, V>
    extends AbstractCollection<V> {
        protected final AbstractHashedMap<K, V> parent;

        protected Values(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.parent.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return this.parent.createValuesIterator();
        }
    }

    protected static class ValuesIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<V> {
        protected ValuesIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public V next() {
            return super.nextEntry().getValue();
        }
    }
}

