/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import com.easemob.util.EMLog;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smack.util.DateFormatType;

public class StringUtils {
    private static final String TAG = "StringUtils";
    public static final DateFormat XEP_0082_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateFormat dateFormatter = DateFormatType.XEP_0082_DATE_PROFILE.createFormatter();
    private static final Pattern datePattern = Pattern.compile("^\\d+-\\d+-\\d+$");
    private static final DateFormat timeFormatter = DateFormatType.XEP_0082_TIME_MILLIS_ZONE_PROFILE.createFormatter();
    private static final Pattern timePattern = Pattern.compile("^(\\d+:){2}\\d+.\\d+(Z|([+-](\\d+:\\d+)))$");
    private static final DateFormat timeNoZoneFormatter = DateFormatType.XEP_0082_TIME_MILLIS_PROFILE.createFormatter();
    private static final Pattern timeNoZonePattern = Pattern.compile("^(\\d+:){2}\\d+.\\d+$");
    private static final DateFormat timeNoMillisFormatter = DateFormatType.XEP_0082_TIME_ZONE_PROFILE.createFormatter();
    private static final Pattern timeNoMillisPattern = Pattern.compile("^(\\d+:){2}\\d+(Z|([+-](\\d+:\\d+)))$");
    private static final DateFormat timeNoMillisNoZoneFormatter = DateFormatType.XEP_0082_TIME_PROFILE.createFormatter();
    private static final Pattern timeNoMillisNoZonePattern = Pattern.compile("^(\\d+:){2}\\d+$");
    private static final DateFormat dateTimeFormatter = DateFormatType.XEP_0082_DATETIME_MILLIS_PROFILE.createFormatter();
    private static final Pattern dateTimePattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+.\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final DateFormat dateTimeNoMillisFormatter = DateFormatType.XEP_0082_DATETIME_PROFILE.createFormatter();
    private static final Pattern dateTimeNoMillisPattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final DateFormat xep0091Formatter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private static final DateFormat xep0091Date6DigitFormatter = new SimpleDateFormat("yyyyMd'T'HH:mm:ss");
    private static final DateFormat xep0091Date7Digit1MonthFormatter = new SimpleDateFormat("yyyyMdd'T'HH:mm:ss");
    private static final DateFormat xep0091Date7Digit2MonthFormatter = new SimpleDateFormat("yyyyMMd'T'HH:mm:ss");
    private static final Pattern xep0091Pattern = Pattern.compile("^\\d+T\\d+:\\d+:\\d+$");
    private static final List<PatternCouplings> couplings = new ArrayList<PatternCouplings>();
    private static final char[] QUOTE_ENCODE;
    private static final char[] APOS_ENCODE;
    private static final char[] AMP_ENCODE;
    private static final char[] LT_ENCODE;
    private static final char[] GT_ENCODE;
    private static MessageDigest digest;
    private static Random randGen;
    private static char[] numbersAndLetters;

    static {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        XEP_0082_UTC_FORMAT.setTimeZone(timeZone);
        dateFormatter.setTimeZone(timeZone);
        timeFormatter.setTimeZone(timeZone);
        timeNoZoneFormatter.setTimeZone(timeZone);
        timeNoMillisFormatter.setTimeZone(timeZone);
        timeNoMillisNoZoneFormatter.setTimeZone(timeZone);
        dateTimeFormatter.setTimeZone(timeZone);
        dateTimeNoMillisFormatter.setTimeZone(timeZone);
        xep0091Formatter.setTimeZone(timeZone);
        xep0091Date6DigitFormatter.setTimeZone(timeZone);
        xep0091Date7Digit1MonthFormatter.setTimeZone(timeZone);
        xep0091Date7Digit1MonthFormatter.setLenient(false);
        xep0091Date7Digit2MonthFormatter.setTimeZone(timeZone);
        xep0091Date7Digit2MonthFormatter.setLenient(false);
        couplings.add(new PatternCouplings(datePattern, dateFormatter));
        couplings.add(new PatternCouplings(dateTimePattern, dateTimeFormatter, true));
        couplings.add(new PatternCouplings(dateTimeNoMillisPattern, dateTimeNoMillisFormatter, true));
        couplings.add(new PatternCouplings(timePattern, timeFormatter, true));
        couplings.add(new PatternCouplings(timeNoZonePattern, timeNoZoneFormatter));
        couplings.add(new PatternCouplings(timeNoMillisPattern, timeNoMillisFormatter, true));
        couplings.add(new PatternCouplings(timeNoMillisNoZonePattern, timeNoMillisNoZoneFormatter));
        QUOTE_ENCODE = "&quot;".toCharArray();
        APOS_ENCODE = "&apos;".toCharArray();
        AMP_ENCODE = "&amp;".toCharArray();
        LT_ENCODE = "&lt;".toCharArray();
        GT_ENCODE = "&gt;".toCharArray();
        digest = null;
        randGen = new Random();
        numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }

    public static Date parseXEP0082Date(String string) throws ParseException {
        return StringUtils.parseDate(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date parseDate(String string) throws ParseException {
        block15: {
            Matcher matcher = xep0091Pattern.matcher(string);
            if (matcher.matches()) {
                int n2 = string.split("T")[0].length();
                if (n2 < 8) {
                    Date date = StringUtils.handleDateWithMissingLeadingZeros(string, n2);
                    if (date != null) {
                        return date;
                    }
                    break block15;
                } else {
                    DateFormat dateFormat = xep0091Formatter;
                    synchronized (dateFormat) {
                        return xep0091Formatter.parse(string);
                    }
                }
            }
            for (PatternCouplings patternCouplings : couplings) {
                matcher = patternCouplings.pattern.matcher(string);
                if (!matcher.matches()) continue;
                if (patternCouplings.needToConvertTimeZone) {
                    string = patternCouplings.convertTime(string);
                }
                DateFormat dateFormat = patternCouplings.formatter;
                synchronized (dateFormat) {
                    return patternCouplings.formatter.parse(string);
                }
            }
        }
        DateFormat dateFormat = dateTimeNoMillisFormatter;
        synchronized (dateFormat) {
            return dateTimeNoMillisFormatter.parse(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date handleDateWithMissingLeadingZeros(String string, int n2) throws ParseException {
        if (n2 == 6) {
            DateFormat dateFormat = xep0091Date6DigitFormatter;
            synchronized (dateFormat) {
                return xep0091Date6DigitFormatter.parse(string);
            }
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = StringUtils.parseXEP91Date(string, xep0091Date7Digit1MonthFormatter);
        Calendar calendar3 = StringUtils.parseXEP91Date(string, xep0091Date7Digit2MonthFormatter);
        List<Calendar> list = StringUtils.filterDatesBefore(calendar, calendar2, calendar3);
        if (!list.isEmpty()) {
            return StringUtils.determineNearestDate(calendar, list).getTime();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Calendar parseXEP91Date(String string, DateFormat dateFormat) {
        try {
            DateFormat dateFormat2 = dateFormat;
            synchronized (dateFormat2) {
                dateFormat.parse(string);
                return dateFormat.getCalendar();
            }
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static List<Calendar> filterDatesBefore(Calendar calendar, Calendar ... calendarArray) {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        Calendar[] calendarArray2 = calendarArray;
        int n2 = calendarArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Calendar calendar2 = calendarArray2[n3];
            if (calendar2 != null && calendar2.before(calendar)) {
                arrayList.add(calendar2);
            }
            ++n3;
        }
        return arrayList;
    }

    private static Calendar determineNearestDate(final Calendar calendar, List<Calendar> list) {
        Collections.sort(list, new Comparator<Calendar>(){

            @Override
            public int compare(Calendar calendar3, Calendar calendar2) {
                Long l2 = new Long(calendar.getTimeInMillis() - calendar3.getTimeInMillis());
                Long l3 = new Long(calendar.getTimeInMillis() - calendar2.getTimeInMillis());
                return l2.compareTo(l3);
            }
        });
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXEP0082Date(Date date) {
        DateFormat dateFormat = dateTimeFormatter;
        synchronized (dateFormat) {
            return dateTimeFormatter.format(date);
        }
    }

    public static String formatDate(Date date, DateFormatType dateFormatType) {
        return null;
    }

    public static String parseName(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf("@");
        if (n2 <= 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static String parseServer(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf("@");
        if (n2 + 1 > string.length()) {
            return "";
        }
        int n3 = string.indexOf("/");
        if (n3 > 0 && n3 > n2) {
            return string.substring(n2 + 1, n3);
        }
        return string.substring(n2 + 1);
    }

    public static String parseResource(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf("/");
        if (n2 + 1 > string.length() || n2 < 0) {
            return "";
        }
        return string.substring(n2 + 1);
    }

    public static String parseBareAddress(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf("/");
        if (n2 < 0) {
            return string;
        }
        if (n2 == 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static boolean isFullJID(String string) {
        return StringUtils.parseName(string).length() > 0 && StringUtils.parseServer(string).length() > 0 && StringUtils.parseResource(string).length() > 0;
    }

    public static String escapeNode(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 8);
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '\"': {
                    stringBuilder.append("\\22");
                    break;
                }
                case '&': {
                    stringBuilder.append("\\26");
                    break;
                }
                case '\'': {
                    stringBuilder.append("\\27");
                    break;
                }
                case '/': {
                    stringBuilder.append("\\2f");
                    break;
                }
                case ':': {
                    stringBuilder.append("\\3a");
                    break;
                }
                case '<': {
                    stringBuilder.append("\\3c");
                    break;
                }
                case '>': {
                    stringBuilder.append("\\3e");
                    break;
                }
                case '@': {
                    stringBuilder.append("\\40");
                    break;
                }
                case '\\': {
                    stringBuilder.append("\\5c");
                    break;
                }
                default: {
                    if (Character.isWhitespace(c2)) {
                        stringBuilder.append("\\20");
                        break;
                    }
                    stringBuilder.append(c2);
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String unescapeNode(String var0) {
        if (var0 == null) {
            return null;
        }
        var1_1 = var0.toCharArray();
        var2_2 = new StringBuilder(var1_1.length);
        var3_3 = 0;
        var4_4 = var1_1.length;
        while (var3_3 < var4_4) {
            block17: {
                block19: {
                    block18: {
                        block16: {
                            var5_5 = var0.charAt(var3_3);
                            if (var5_5 != '\\' || var3_3 + 2 >= var4_4) ** GOTO lbl-1000
                            var6_6 = var1_1[var3_3 + 1];
                            var7_7 = var1_1[var3_3 + 2];
                            if (var6_6 != '2') break block16;
                            switch (var7_7) {
                                case '0': {
                                    var2_2.append(' ');
                                    var3_3 += 2;
                                    break block17;
                                }
                                case '2': {
                                    var2_2.append('\"');
                                    var3_3 += 2;
                                    break block17;
                                }
                                case '6': {
                                    var2_2.append('&');
                                    var3_3 += 2;
                                    break block17;
                                }
                                case '7': {
                                    var2_2.append('\'');
                                    var3_3 += 2;
                                    break block17;
                                }
                                case 'f': {
                                    var2_2.append('/');
                                    var3_3 += 2;
                                    break block17;
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        if (var6_6 != '3') break block18;
                        switch (var7_7) {
                            case 'a': {
                                var2_2.append(':');
                                var3_3 += 2;
                                break block17;
                            }
                            case 'c': {
                                var2_2.append('<');
                                var3_3 += 2;
                                break block17;
                            }
                            case 'e': {
                                var2_2.append('>');
                                var3_3 += 2;
                                break block17;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    if (var6_6 != '4') break block19;
                    if (var7_7 != '0') ** GOTO lbl-1000
                    var2_2.append("@");
                    var3_3 += 2;
                    break block17;
                }
                if (var6_6 == '5' && var7_7 == 'c') {
                    var2_2.append("\\");
                    var3_3 += 2;
                } else lbl-1000:
                // 5 sources

                {
                    var2_2.append(var5_5);
                }
            }
            ++var3_3;
        }
        return var2_2.toString();
    }

    public static String escapeForXML(String string) {
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        StringBuilder stringBuilder = new StringBuilder((int)((double)n4 * 1.3));
        while (n2 < n4) {
            char c2 = cArray[n2];
            if (c2 <= '>') {
                if (c2 == '<') {
                    if (n2 > n3) {
                        stringBuilder.append(cArray, n3, n2 - n3);
                    }
                    n3 = n2 + 1;
                    stringBuilder.append(LT_ENCODE);
                } else if (c2 == '>') {
                    if (n2 > n3) {
                        stringBuilder.append(cArray, n3, n2 - n3);
                    }
                    n3 = n2 + 1;
                    stringBuilder.append(GT_ENCODE);
                } else if (c2 == '&') {
                    if (n2 > n3) {
                        stringBuilder.append(cArray, n3, n2 - n3);
                    }
                    if (!(n4 > n2 + 5 && cArray[n2 + 1] == '#' && Character.isDigit(cArray[n2 + 2]) && Character.isDigit(cArray[n2 + 3]) && Character.isDigit(cArray[n2 + 4]) && cArray[n2 + 5] == ';')) {
                        n3 = n2 + 1;
                        stringBuilder.append(AMP_ENCODE);
                    }
                } else if (c2 == '\"') {
                    if (n2 > n3) {
                        stringBuilder.append(cArray, n3, n2 - n3);
                    }
                    n3 = n2 + 1;
                    stringBuilder.append(QUOTE_ENCODE);
                } else if (c2 == '\'') {
                    if (n2 > n3) {
                        stringBuilder.append(cArray, n3, n2 - n3);
                    }
                    n3 = n2 + 1;
                    stringBuilder.append(APOS_ENCODE);
                }
            }
            ++n2;
        }
        if (n3 == 0) {
            return string;
        }
        if (n2 > n3) {
            stringBuilder.append(cArray, n3, n2 - n3);
        }
        return stringBuilder.toString();
    }

    public static synchronized String hash(String string) {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                EMLog.e(TAG, "Failed to load the SHA-1 MessageDigest. Jive will be unable to function normally.");
            }
        }
        try {
            digest.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            EMLog.e(TAG, "", unsupportedEncodingException);
        }
        return StringUtils.encodeHex(digest.digest());
    }

    public static String encodeHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray2[n3];
            if ((by & 0xFF) < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toString(by & 0xFF, 16));
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String encodeBase64(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return StringUtils.encodeBase64(byArray);
    }

    public static String encodeBase64(byte[] byArray) {
        return StringUtils.encodeBase64(byArray, false);
    }

    public static String encodeBase64(byte[] byArray, boolean bl) {
        return StringUtils.encodeBase64(byArray, 0, byArray.length, bl);
    }

    public static String encodeBase64(byte[] byArray, int n2, int n3, boolean bl) {
        return Base64.encodeBytes(byArray, n2, n3, bl ? 0 : 8);
    }

    public static byte[] decodeBase64(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        byArray = Base64.decode(byArray, 0, byArray.length, 0);
        return byArray;
    }

    public static String randomString(int n2) {
        if (n2 < 1) {
            return null;
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < cArray.length) {
            cArray[n3] = numbersAndLetters[randGen.nextInt(71)];
            ++n3;
        }
        return new String(cArray);
    }

    private StringUtils() {
    }

    private static class PatternCouplings {
        Pattern pattern;
        DateFormat formatter;
        boolean needToConvertTimeZone = false;

        public PatternCouplings(Pattern pattern, DateFormat dateFormat) {
            this.pattern = pattern;
            this.formatter = dateFormat;
        }

        public PatternCouplings(Pattern pattern, DateFormat dateFormat, boolean bl) {
            this.pattern = pattern;
            this.formatter = dateFormat;
            this.needToConvertTimeZone = bl;
        }

        public String convertTime(String string) {
            if (string.charAt(string.length() - 1) == 'Z') {
                return string.replace("Z", "+0000");
            }
            return string.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2");
        }
    }
}

