/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.WriterListener;

public class ObservableWriter
extends Writer {
    Writer wrappedWriter = null;
    List<WriterListener> listeners = new ArrayList<WriterListener>();

    public ObservableWriter(Writer writer) {
        this.wrappedWriter = writer;
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.wrappedWriter.write(cArray, n2, n3);
        String string = new String(cArray, n2, n3);
        this.notifyListeners(string);
    }

    @Override
    public void flush() throws IOException {
        this.wrappedWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrappedWriter.close();
    }

    @Override
    public void write(int n2) throws IOException {
        this.wrappedWriter.write(n2);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.wrappedWriter.write(cArray);
        String string = new String(cArray);
        this.notifyListeners(string);
    }

    @Override
    public void write(String string) throws IOException {
        this.wrappedWriter.write(string);
        this.notifyListeners(string);
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        this.wrappedWriter.write(string, n2, n3);
        string = string.substring(n2, n2 + n3);
        this.notifyListeners(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String string) {
        WriterListener[] writerListenerArray = null;
        List<WriterListener> list = this.listeners;
        synchronized (list) {
            writerListenerArray = new WriterListener[this.listeners.size()];
            this.listeners.toArray(writerListenerArray);
        }
        int n2 = 0;
        while (n2 < writerListenerArray.length) {
            writerListenerArray[n2].write(string);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriterListener(WriterListener writerListener) {
        if (writerListener == null) {
            return;
        }
        List<WriterListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(writerListener)) {
                this.listeners.add(writerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriterListener(WriterListener writerListener) {
        List<WriterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(writerListener);
        }
    }
}

