/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;

public class DNSUtil {
    private static Map<String, List<HostAddress>> cache = new Cache<String, List<HostAddress>>(100, 600000L);
    private static DNSResolver dnsResolver = null;

    public static void setDNSResolver(DNSResolver dNSResolver) {
        dnsResolver = dNSResolver;
    }

    public static DNSResolver getDNSResolver() {
        return dnsResolver;
    }

    public static List<HostAddress> resolveXMPPDomain(String string) {
        return DNSUtil.resolveDomain(string, 'c');
    }

    public static List<HostAddress> resolveXMPPServerDomain(String string) {
        return DNSUtil.resolveDomain(string, 's');
    }

    private static List<HostAddress> resolveDomain(String string, char c2) {
        List<HostAddress> list;
        String string2 = String.valueOf(c2) + string;
        if (cache.containsKey(string2) && (list = cache.get(string2)) != null) {
            return list;
        }
        if (dnsResolver == null) {
            throw new IllegalStateException("No DNS resolver active.");
        }
        list = new ArrayList<HostAddress>();
        String string3 = c2 == 's' ? "_xmpp-server._tcp." + string : (c2 == 'c' ? "_xmpp-client._tcp." + string : string);
        List<SRVRecord> list2 = dnsResolver.lookupSRVRecords(string3);
        List<HostAddress> list3 = DNSUtil.sortSRVRecords(list2);
        if (list3 != null) {
            list.addAll(list3);
        }
        list.add(new HostAddress(string));
        cache.put(string2, list);
        return list;
    }

    protected static List<HostAddress> sortSRVRecords(List<SRVRecord> list) {
        List list2;
        if (list.size() == 1 && list.get(0).getFQDN().equals(".")) {
            return null;
        }
        Collections.sort(list);
        TreeMap<Object, LinkedList<SRVRecord>> treeMap = new TreeMap<Object, LinkedList<SRVRecord>>();
        for (SRVRecord object2 : list) {
            Integer n2 = object2.getPriority();
            list2 = (LinkedList<SRVRecord>)treeMap.get(n2);
            if (list2 == null) {
                list2 = new LinkedList<SRVRecord>();
                treeMap.put(n2, (LinkedList<SRVRecord>)list2);
            }
            list2.add(object2);
        }
        ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>(list.size());
        for (Object object3 : treeMap.keySet()) {
            int n3;
            list2 = (List)treeMap.get(object3);
            while ((n3 = list2.size()) > 0) {
                int sRVRecord;
                int[] nArray = new int[list2.size()];
                int n4 = 0;
                int n5 = 0;
                int n6 = 1;
                for (SRVRecord sRVRecord2 : list2) {
                    if (sRVRecord2.getWeight() <= 0) continue;
                    n6 = 0;
                }
                for (SRVRecord sRVRecord2 : list2) {
                    nArray[n5] = n4 += sRVRecord2.getWeight() + n6;
                    ++n5;
                }
                if (n4 == 0) {
                    sRVRecord = (int)(Math.random() * (double)n3);
                } else {
                    double d2 = Math.random() * (double)n4;
                    sRVRecord = DNSUtil.bisect(nArray, d2);
                }
                SRVRecord d2 = (SRVRecord)list2.remove(sRVRecord);
                arrayList.add(d2);
            }
        }
        return arrayList;
    }

    private static int bisect(int[] nArray, double d2) {
        int n2 = 0;
        int[] nArray2 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray2[n4];
            if (d2 < (double)n5) break;
            ++n2;
            ++n4;
        }
        return n2;
    }
}

