/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import com.easemob.util.EMLog;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.util.collections.AbstractMapEntry;

public class Cache<K, V>
implements Map<K, V> {
    private static final String TAG = "Cache";
    protected Map<K, CacheObject<V>> map;
    protected LinkedList lastAccessedList;
    protected LinkedList ageList;
    protected int maxCacheSize;
    protected long maxLifetime;
    protected long cacheHits;
    protected long cacheMisses = 0L;

    public Cache(int n2, long l2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Max cache size cannot be 0.");
        }
        this.maxCacheSize = n2;
        this.maxLifetime = l2;
        this.map = new HashMap<K, CacheObject<V>>(103);
        this.lastAccessedList = new LinkedList();
        this.ageList = new LinkedList();
    }

    @Override
    public synchronized V put(K k2, V v2) {
        V v3 = null;
        if (this.map.containsKey(k2)) {
            v3 = this.remove(k2, true);
        }
        CacheObject<V> cacheObject = new CacheObject<V>(v2);
        this.map.put(k2, cacheObject);
        cacheObject.lastAccessedListNode = this.lastAccessedList.addFirst(k2);
        LinkedListNode linkedListNode = this.ageList.addFirst(k2);
        linkedListNode.timestamp = System.currentTimeMillis();
        cacheObject.ageListNode = linkedListNode;
        this.cullCache();
        return v3;
    }

    @Override
    public synchronized V get(Object object) {
        this.deleteExpiredEntries();
        CacheObject<V> cacheObject = this.map.get(object);
        if (cacheObject == null) {
            ++this.cacheMisses;
            return null;
        }
        cacheObject.lastAccessedListNode.remove();
        this.lastAccessedList.addFirst(cacheObject.lastAccessedListNode);
        ++this.cacheHits;
        ++cacheObject.readCount;
        return cacheObject.object;
    }

    @Override
    public synchronized V remove(Object object) {
        return this.remove(object, false);
    }

    public synchronized V remove(Object object, boolean bl) {
        CacheObject<V> cacheObject = this.map.remove(object);
        if (cacheObject == null) {
            return null;
        }
        cacheObject.lastAccessedListNode.remove();
        cacheObject.ageListNode.remove();
        cacheObject.ageListNode = null;
        cacheObject.lastAccessedListNode = null;
        return cacheObject.object;
    }

    @Override
    public synchronized void clear() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.map.keySet().toArray();
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectArray2[n3];
            this.remove(object);
            ++n3;
        }
        this.map.clear();
        this.lastAccessedList.clear();
        this.ageList.clear();
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
    }

    @Override
    public synchronized int size() {
        this.deleteExpiredEntries();
        return this.map.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        this.deleteExpiredEntries();
        return this.map.isEmpty();
    }

    @Override
    public synchronized Collection<V> values() {
        this.deleteExpiredEntries();
        return Collections.unmodifiableCollection(new AbstractCollection<V>(){
            Collection<CacheObject<V>> values;
            {
                this.values = Cache.this.map.values();
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<CacheObject<V>> it;
                    {
                        this.it = values.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.it.next().object;
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.values.size();
            }
        });
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        this.deleteExpiredEntries();
        return this.map.containsKey(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v2 = entry.getValue();
            if (v2 instanceof CacheObject) {
                v2 = ((CacheObject)v2).object;
            }
            this.put(entry.getKey(), v2);
        }
    }

    @Override
    public synchronized boolean containsValue(Object object) {
        this.deleteExpiredEntries();
        CacheObject<Object> cacheObject = new CacheObject<Object>(object);
        return this.map.containsValue(cacheObject);
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        this.deleteExpiredEntries();
        return new AbstractSet<Map.Entry<K, V>>(){
            private final Set<Map.Entry<K, CacheObject<V>>> set;
            {
                this.set = Cache.this.map.entrySet();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, CacheObject<V>>> it;
                    {
                        this.it = set.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Map.Entry entry = this.it.next();
                        return new AbstractMapEntry<K, V>(entry.getKey(), entry.getValue().object){

                            @Override
                            public V setValue(V v2) {
                                throw new UnsupportedOperationException("Cannot set");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.set.size();
            }
        };
    }

    @Override
    public synchronized Set<K> keySet() {
        this.deleteExpiredEntries();
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public synchronized void setMaxCacheSize(int n2) {
        this.maxCacheSize = n2;
        this.cullCache();
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    public void setMaxLifetime(long l2) {
        this.maxLifetime = l2;
    }

    protected synchronized void deleteExpiredEntries() {
        if (this.maxLifetime <= 0L) {
            return;
        }
        LinkedListNode linkedListNode = this.ageList.getLast();
        if (linkedListNode == null) {
            return;
        }
        long l2 = System.currentTimeMillis() - this.maxLifetime;
        while (l2 > linkedListNode.timestamp) {
            if (this.remove(linkedListNode.object, true) == null) {
                EMLog.e(TAG, "Error attempting to remove(" + linkedListNode.object.toString() + ") - cacheObject not found in cache!");
                linkedListNode.remove();
            }
            if ((linkedListNode = this.ageList.getLast()) != null) continue;
            return;
        }
    }

    protected synchronized void cullCache() {
        if (this.maxCacheSize < 0) {
            return;
        }
        if (this.map.size() > this.maxCacheSize) {
            this.deleteExpiredEntries();
            int n2 = (int)((double)this.maxCacheSize * 0.9);
            int n3 = this.map.size();
            while (n3 > n2) {
                if (this.remove(this.lastAccessedList.getLast().object, true) == null) {
                    EMLog.e(TAG, "Error attempting to cullCache with remove(" + this.lastAccessedList.getLast().object.toString() + ") - " + "cacheObject not found in cache!");
                    this.lastAccessedList.getLast().remove();
                }
                --n3;
            }
        }
    }

    private static class CacheObject<V> {
        public V object;
        public LinkedListNode lastAccessedListNode;
        public LinkedListNode ageListNode;
        public int readCount = 0;

        public CacheObject(V v2) {
            this.object = v2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CacheObject)) {
                return false;
            }
            CacheObject cacheObject = (CacheObject)object;
            return this.object.equals(cacheObject.object);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }

    private static class LinkedList {
        private LinkedListNode head;

        public LinkedList() {
            this.head.next = this.head.previous = (this.head = new LinkedListNode("head", null, null));
        }

        public LinkedListNode getFirst() {
            LinkedListNode linkedListNode = this.head.next;
            if (linkedListNode == this.head) {
                return null;
            }
            return linkedListNode;
        }

        public LinkedListNode getLast() {
            LinkedListNode linkedListNode = this.head.previous;
            if (linkedListNode == this.head) {
                return null;
            }
            return linkedListNode;
        }

        public LinkedListNode addFirst(LinkedListNode linkedListNode) {
            linkedListNode.next = this.head.next;
            linkedListNode.previous = this.head;
            linkedListNode.previous.next = linkedListNode;
            linkedListNode.next.previous = linkedListNode;
            return linkedListNode;
        }

        public LinkedListNode addFirst(Object object) {
            LinkedListNode linkedListNode;
            linkedListNode.previous.next = linkedListNode = new LinkedListNode(object, this.head.next, this.head);
            linkedListNode.next.previous = linkedListNode;
            return linkedListNode;
        }

        public LinkedListNode addLast(Object object) {
            LinkedListNode linkedListNode;
            linkedListNode.previous.next = linkedListNode = new LinkedListNode(object, this.head, this.head.previous);
            linkedListNode.next.previous = linkedListNode;
            return linkedListNode;
        }

        public void clear() {
            LinkedListNode linkedListNode = this.getLast();
            while (linkedListNode != null) {
                linkedListNode.remove();
                linkedListNode = this.getLast();
            }
            this.head.next = this.head.previous = this.head;
        }

        public String toString() {
            LinkedListNode linkedListNode = this.head.next;
            StringBuilder stringBuilder = new StringBuilder();
            while (linkedListNode != this.head) {
                stringBuilder.append(linkedListNode.toString()).append(", ");
                linkedListNode = linkedListNode.next;
            }
            return stringBuilder.toString();
        }
    }

    private static class LinkedListNode {
        public LinkedListNode previous;
        public LinkedListNode next;
        public Object object;
        public long timestamp;

        public LinkedListNode(Object object, LinkedListNode linkedListNode, LinkedListNode linkedListNode2) {
            this.object = object;
            this.next = linkedListNode;
            this.previous = linkedListNode2;
        }

        public void remove() {
            this.previous.next = this.next;
            this.next.previous = this.previous;
        }

        public String toString() {
            return this.object.toString();
        }
    }
}

