/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import com.easemob.util.EMLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Base64 {
    private static final String TAG = "Base64";
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int GZIP = 2;
    public static final int DONT_BREAK_LINES = 8;
    public static final int URL_SAFE = 16;
    public static final int ORDERED = 32;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING = "UTF-8";
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] _STANDARD_DECODABET;
    private static final byte[] _URL_SAFE_ALPHABET;
    private static final byte[] _URL_SAFE_DECODABET;
    private static final byte[] _ORDERED_ALPHABET;
    private static final byte[] _ORDERED_DECODABET;

    static {
        byte[] byArray = new byte[127];
        byArray[0] = -9;
        byArray[1] = -9;
        byArray[2] = -9;
        byArray[3] = -9;
        byArray[4] = -9;
        byArray[5] = -9;
        byArray[6] = -9;
        byArray[7] = -9;
        byArray[8] = -9;
        byArray[9] = -5;
        byArray[10] = -5;
        byArray[11] = -9;
        byArray[12] = -9;
        byArray[13] = -5;
        byArray[14] = -9;
        byArray[15] = -9;
        byArray[16] = -9;
        byArray[17] = -9;
        byArray[18] = -9;
        byArray[19] = -9;
        byArray[20] = -9;
        byArray[21] = -9;
        byArray[22] = -9;
        byArray[23] = -9;
        byArray[24] = -9;
        byArray[25] = -9;
        byArray[26] = -9;
        byArray[27] = -9;
        byArray[28] = -9;
        byArray[29] = -9;
        byArray[30] = -9;
        byArray[31] = -9;
        byArray[32] = -5;
        byArray[33] = -9;
        byArray[34] = -9;
        byArray[35] = -9;
        byArray[36] = -9;
        byArray[37] = -9;
        byArray[38] = -9;
        byArray[39] = -9;
        byArray[40] = -9;
        byArray[41] = -9;
        byArray[42] = -9;
        byArray[43] = 62;
        byArray[44] = -9;
        byArray[45] = -9;
        byArray[46] = -9;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -9;
        byArray[59] = -9;
        byArray[60] = -9;
        byArray[61] = -1;
        byArray[62] = -9;
        byArray[63] = -9;
        byArray[64] = -9;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -9;
        byArray[92] = -9;
        byArray[93] = -9;
        byArray[94] = -9;
        byArray[95] = -9;
        byArray[96] = -9;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        byArray[123] = -9;
        byArray[124] = -9;
        byArray[125] = -9;
        byArray[126] = -9;
        _STANDARD_DECODABET = byArray;
        _URL_SAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
        byte[] byArray2 = new byte[127];
        byArray2[0] = -9;
        byArray2[1] = -9;
        byArray2[2] = -9;
        byArray2[3] = -9;
        byArray2[4] = -9;
        byArray2[5] = -9;
        byArray2[6] = -9;
        byArray2[7] = -9;
        byArray2[8] = -9;
        byArray2[9] = -5;
        byArray2[10] = -5;
        byArray2[11] = -9;
        byArray2[12] = -9;
        byArray2[13] = -5;
        byArray2[14] = -9;
        byArray2[15] = -9;
        byArray2[16] = -9;
        byArray2[17] = -9;
        byArray2[18] = -9;
        byArray2[19] = -9;
        byArray2[20] = -9;
        byArray2[21] = -9;
        byArray2[22] = -9;
        byArray2[23] = -9;
        byArray2[24] = -9;
        byArray2[25] = -9;
        byArray2[26] = -9;
        byArray2[27] = -9;
        byArray2[28] = -9;
        byArray2[29] = -9;
        byArray2[30] = -9;
        byArray2[31] = -9;
        byArray2[32] = -5;
        byArray2[33] = -9;
        byArray2[34] = -9;
        byArray2[35] = -9;
        byArray2[36] = -9;
        byArray2[37] = -9;
        byArray2[38] = -9;
        byArray2[39] = -9;
        byArray2[40] = -9;
        byArray2[41] = -9;
        byArray2[42] = -9;
        byArray2[43] = -9;
        byArray2[44] = -9;
        byArray2[45] = 62;
        byArray2[46] = -9;
        byArray2[47] = -9;
        byArray2[48] = 52;
        byArray2[49] = 53;
        byArray2[50] = 54;
        byArray2[51] = 55;
        byArray2[52] = 56;
        byArray2[53] = 57;
        byArray2[54] = 58;
        byArray2[55] = 59;
        byArray2[56] = 60;
        byArray2[57] = 61;
        byArray2[58] = -9;
        byArray2[59] = -9;
        byArray2[60] = -9;
        byArray2[61] = -1;
        byArray2[62] = -9;
        byArray2[63] = -9;
        byArray2[64] = -9;
        byArray2[66] = 1;
        byArray2[67] = 2;
        byArray2[68] = 3;
        byArray2[69] = 4;
        byArray2[70] = 5;
        byArray2[71] = 6;
        byArray2[72] = 7;
        byArray2[73] = 8;
        byArray2[74] = 9;
        byArray2[75] = 10;
        byArray2[76] = 11;
        byArray2[77] = 12;
        byArray2[78] = 13;
        byArray2[79] = 14;
        byArray2[80] = 15;
        byArray2[81] = 16;
        byArray2[82] = 17;
        byArray2[83] = 18;
        byArray2[84] = 19;
        byArray2[85] = 20;
        byArray2[86] = 21;
        byArray2[87] = 22;
        byArray2[88] = 23;
        byArray2[89] = 24;
        byArray2[90] = 25;
        byArray2[91] = -9;
        byArray2[92] = -9;
        byArray2[93] = -9;
        byArray2[94] = -9;
        byArray2[95] = 63;
        byArray2[96] = -9;
        byArray2[97] = 26;
        byArray2[98] = 27;
        byArray2[99] = 28;
        byArray2[100] = 29;
        byArray2[101] = 30;
        byArray2[102] = 31;
        byArray2[103] = 32;
        byArray2[104] = 33;
        byArray2[105] = 34;
        byArray2[106] = 35;
        byArray2[107] = 36;
        byArray2[108] = 37;
        byArray2[109] = 38;
        byArray2[110] = 39;
        byArray2[111] = 40;
        byArray2[112] = 41;
        byArray2[113] = 42;
        byArray2[114] = 43;
        byArray2[115] = 44;
        byArray2[116] = 45;
        byArray2[117] = 46;
        byArray2[118] = 47;
        byArray2[119] = 48;
        byArray2[120] = 49;
        byArray2[121] = 50;
        byArray2[122] = 51;
        byArray2[123] = -9;
        byArray2[124] = -9;
        byArray2[125] = -9;
        byArray2[126] = -9;
        _URL_SAFE_DECODABET = byArray2;
        _ORDERED_ALPHABET = new byte[]{45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        byte[] byArray3 = new byte[127];
        byArray3[0] = -9;
        byArray3[1] = -9;
        byArray3[2] = -9;
        byArray3[3] = -9;
        byArray3[4] = -9;
        byArray3[5] = -9;
        byArray3[6] = -9;
        byArray3[7] = -9;
        byArray3[8] = -9;
        byArray3[9] = -5;
        byArray3[10] = -5;
        byArray3[11] = -9;
        byArray3[12] = -9;
        byArray3[13] = -5;
        byArray3[14] = -9;
        byArray3[15] = -9;
        byArray3[16] = -9;
        byArray3[17] = -9;
        byArray3[18] = -9;
        byArray3[19] = -9;
        byArray3[20] = -9;
        byArray3[21] = -9;
        byArray3[22] = -9;
        byArray3[23] = -9;
        byArray3[24] = -9;
        byArray3[25] = -9;
        byArray3[26] = -9;
        byArray3[27] = -9;
        byArray3[28] = -9;
        byArray3[29] = -9;
        byArray3[30] = -9;
        byArray3[31] = -9;
        byArray3[32] = -5;
        byArray3[33] = -9;
        byArray3[34] = -9;
        byArray3[35] = -9;
        byArray3[36] = -9;
        byArray3[37] = -9;
        byArray3[38] = -9;
        byArray3[39] = -9;
        byArray3[40] = -9;
        byArray3[41] = -9;
        byArray3[42] = -9;
        byArray3[43] = -9;
        byArray3[44] = -9;
        byArray3[46] = -9;
        byArray3[47] = -9;
        byArray3[48] = 1;
        byArray3[49] = 2;
        byArray3[50] = 3;
        byArray3[51] = 4;
        byArray3[52] = 5;
        byArray3[53] = 6;
        byArray3[54] = 7;
        byArray3[55] = 8;
        byArray3[56] = 9;
        byArray3[57] = 10;
        byArray3[58] = -9;
        byArray3[59] = -9;
        byArray3[60] = -9;
        byArray3[61] = -1;
        byArray3[62] = -9;
        byArray3[63] = -9;
        byArray3[64] = -9;
        byArray3[65] = 11;
        byArray3[66] = 12;
        byArray3[67] = 13;
        byArray3[68] = 14;
        byArray3[69] = 15;
        byArray3[70] = 16;
        byArray3[71] = 17;
        byArray3[72] = 18;
        byArray3[73] = 19;
        byArray3[74] = 20;
        byArray3[75] = 21;
        byArray3[76] = 22;
        byArray3[77] = 23;
        byArray3[78] = 24;
        byArray3[79] = 25;
        byArray3[80] = 26;
        byArray3[81] = 27;
        byArray3[82] = 28;
        byArray3[83] = 29;
        byArray3[84] = 30;
        byArray3[85] = 31;
        byArray3[86] = 32;
        byArray3[87] = 33;
        byArray3[88] = 34;
        byArray3[89] = 35;
        byArray3[90] = 36;
        byArray3[91] = -9;
        byArray3[92] = -9;
        byArray3[93] = -9;
        byArray3[94] = -9;
        byArray3[95] = 37;
        byArray3[96] = -9;
        byArray3[97] = 38;
        byArray3[98] = 39;
        byArray3[99] = 40;
        byArray3[100] = 41;
        byArray3[101] = 42;
        byArray3[102] = 43;
        byArray3[103] = 44;
        byArray3[104] = 45;
        byArray3[105] = 46;
        byArray3[106] = 47;
        byArray3[107] = 48;
        byArray3[108] = 49;
        byArray3[109] = 50;
        byArray3[110] = 51;
        byArray3[111] = 52;
        byArray3[112] = 53;
        byArray3[113] = 54;
        byArray3[114] = 55;
        byArray3[115] = 56;
        byArray3[116] = 57;
        byArray3[117] = 58;
        byArray3[118] = 59;
        byArray3[119] = 60;
        byArray3[120] = 61;
        byArray3[121] = 62;
        byArray3[122] = 63;
        byArray3[123] = -9;
        byArray3[124] = -9;
        byArray3[125] = -9;
        byArray3[126] = -9;
        _ORDERED_DECODABET = byArray3;
    }

    private static final byte[] getAlphabet(int n2) {
        if ((n2 & 0x10) == 16) {
            return _URL_SAFE_ALPHABET;
        }
        if ((n2 & 0x20) == 32) {
            return _ORDERED_ALPHABET;
        }
        return _STANDARD_ALPHABET;
    }

    private static final byte[] getDecodabet(int n2) {
        if ((n2 & 0x10) == 16) {
            return _URL_SAFE_DECODABET;
        }
        if ((n2 & 0x20) == 32) {
            return _ORDERED_DECODABET;
        }
        return _STANDARD_DECODABET;
    }

    private Base64() {
    }

    private static final void usage(String string) {
        EMLog.e(TAG, string);
        EMLog.e(TAG, "Usage: java Base64 -e|-d inputfile outputfile");
    }

    private static byte[] encode3to4(byte[] byArray, byte[] byArray2, int n2, int n3) {
        Base64.encode3to4(byArray2, 0, n2, byArray, 0, n3);
        return byArray;
    }

    private static byte[] encode3to4(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        byte[] byArray3 = Base64.getAlphabet(n5);
        int n6 = (n3 > 0 ? byArray[n2] << 24 >>> 8 : 0) | (n3 > 1 ? byArray[n2 + 1] << 24 >>> 16 : 0) | (n3 > 2 ? byArray[n2 + 2] << 24 >>> 24 : 0);
        switch (n3) {
            case 3: {
                byArray2[n4] = byArray3[n6 >>> 18];
                byArray2[n4 + 1] = byArray3[n6 >>> 12 & 0x3F];
                byArray2[n4 + 2] = byArray3[n6 >>> 6 & 0x3F];
                byArray2[n4 + 3] = byArray3[n6 & 0x3F];
                return byArray2;
            }
            case 2: {
                byArray2[n4] = byArray3[n6 >>> 18];
                byArray2[n4 + 1] = byArray3[n6 >>> 12 & 0x3F];
                byArray2[n4 + 2] = byArray3[n6 >>> 6 & 0x3F];
                byArray2[n4 + 3] = 61;
                return byArray2;
            }
            case 1: {
                byArray2[n4] = byArray3[n6 >>> 18];
                byArray2[n4 + 1] = byArray3[n6 >>> 12 & 0x3F];
                byArray2[n4 + 2] = 61;
                byArray2[n4 + 3] = 61;
                return byArray2;
            }
        }
        return byArray2;
    }

    public static String encodeObject(Serializable serializable) {
        return Base64.encodeObject(serializable, 0);
    }

    public static String encodeObject(Serializable serializable, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        java.io.OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        int n3 = n2 & 2;
        int n4 = n2 & 8;
        try {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                outputStream = new OutputStream(byteArrayOutputStream, 1 | n2);
                if (n3 == 2) {
                    deflaterOutputStream = new GZIPOutputStream(outputStream);
                    objectOutputStream = new ObjectOutputStream(deflaterOutputStream);
                } else {
                    objectOutputStream = new ObjectOutputStream(outputStream);
                }
                objectOutputStream.writeObject(serializable);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    deflaterOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            try {
                objectOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                deflaterOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        try {
            return new String(byteArrayOutputStream.toByteArray(), PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byteArrayOutputStream.toByteArray());
        }
    }

    public static String encodeBytes(byte[] byArray) {
        return Base64.encodeBytes(byArray, 0, byArray.length, 0);
    }

    public static String encodeBytes(byte[] byArray, int n2) {
        return Base64.encodeBytes(byArray, 0, byArray.length, n2);
    }

    public static String encodeBytes(byte[] byArray, int n2, int n3) {
        return Base64.encodeBytes(byArray, n2, n3, 0);
    }

    public static String encodeBytes(byte[] byArray, int n2, int n3, int n4) {
        int n5 = n4 & 8;
        int n6 = n4 & 2;
        if (n6 == 2) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            DeflaterOutputStream deflaterOutputStream = null;
            OutputStream outputStream = null;
            try {
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    outputStream = new OutputStream(byteArrayOutputStream, 1 | n4);
                    deflaterOutputStream = new GZIPOutputStream(outputStream);
                    ((GZIPOutputStream)deflaterOutputStream).write(byArray, n2, n3);
                    deflaterOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    try {
                        deflaterOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            }
            finally {
                try {
                    deflaterOutputStream.close();
                }
                catch (Exception exception) {}
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
            try {
                return new String(byteArrayOutputStream.toByteArray(), PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byteArrayOutputStream.toByteArray());
            }
        }
        boolean bl = n5 == 0;
        int n7 = n3 * 4 / 3;
        byte[] byArray2 = new byte[n7 + (n3 % 3 > 0 ? 4 : 0) + (bl ? n7 / 76 : 0)];
        int n8 = 0;
        int n9 = 0;
        int n10 = n3 - 2;
        int n11 = 0;
        while (n8 < n10) {
            Base64.encode3to4(byArray, n8 + n2, 3, byArray2, n9, n4);
            if (bl && (n11 += 4) == 76) {
                byArray2[n9 + 4] = 10;
                ++n9;
                n11 = 0;
            }
            n8 += 3;
            n9 += 4;
        }
        if (n8 < n3) {
            Base64.encode3to4(byArray, n8 + n2, n3 - n8, byArray2, n9, n4);
            n9 += 4;
        }
        try {
            return new String(byArray2, 0, n9, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray2, 0, n9);
        }
    }

    private static int decode4to3(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = Base64.getDecodabet(n4);
        if (byArray[n2 + 2] == 61) {
            int n5 = (byArray3[byArray[n2]] & 0xFF) << 18 | (byArray3[byArray[n2 + 1]] & 0xFF) << 12;
            byArray2[n3] = (byte)(n5 >>> 16);
            return 1;
        }
        if (byArray[n2 + 3] == 61) {
            int n6 = (byArray3[byArray[n2]] & 0xFF) << 18 | (byArray3[byArray[n2 + 1]] & 0xFF) << 12 | (byArray3[byArray[n2 + 2]] & 0xFF) << 6;
            byArray2[n3] = (byte)(n6 >>> 16);
            byArray2[n3 + 1] = (byte)(n6 >>> 8);
            return 2;
        }
        try {
            int n7 = (byArray3[byArray[n2]] & 0xFF) << 18 | (byArray3[byArray[n2 + 1]] & 0xFF) << 12 | (byArray3[byArray[n2 + 2]] & 0xFF) << 6 | byArray3[byArray[n2 + 3]] & 0xFF;
            byArray2[n3] = (byte)(n7 >> 16);
            byArray2[n3 + 1] = (byte)(n7 >> 8);
            byArray2[n3 + 2] = (byte)n7;
            return 3;
        }
        catch (Exception exception) {
            EMLog.d(TAG, byArray[n2] + ": " + byArray3[byArray[n2]]);
            EMLog.d(TAG, byArray[n2 + 1] + ": " + byArray3[byArray[n2 + 1]]);
            EMLog.d(TAG, byArray[n2 + 2] + ": " + byArray3[byArray[n2 + 2]]);
            EMLog.d(TAG, byArray[n2 + 3] + ": " + byArray3[byArray[n2 + 3]]);
            return -1;
        }
    }

    public static byte[] decode(byte[] byArray, int n2, int n3, int n4) {
        byte[] byArray2 = Base64.getDecodabet(n4);
        int n5 = n3 * 3 / 4;
        byte[] byArray3 = new byte[n5];
        int n6 = 0;
        byte[] byArray4 = new byte[4];
        int n7 = 0;
        int n8 = 0;
        byte by = 0;
        byte by2 = 0;
        n8 = n2;
        while (n8 < n2 + n3) {
            by = (byte)(byArray[n8] & 0x7F);
            by2 = byArray2[by];
            if (by2 >= -5) {
                if (by2 >= -1) {
                    byArray4[n7++] = by;
                    if (n7 > 3) {
                        n6 += Base64.decode4to3(byArray4, 0, byArray3, n6, n4);
                        n7 = 0;
                        if (by == 61) {
                            break;
                        }
                    }
                }
            } else {
                System.err.println("Bad Base64 input character at " + n8 + ": " + byArray[n8] + "(decimal)");
                return null;
            }
            ++n8;
        }
        byte[] byArray5 = new byte[n6];
        System.arraycopy(byArray3, 0, byArray5, 0, n6);
        return byArray5;
    }

    public static byte[] decode(String string) {
        return Base64.decode(string, 0);
    }

    public static byte[] decode(String string, int n2) {
        int n3;
        byte[] byArray;
        try {
            byArray = string.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        byArray = Base64.decode(byArray, 0, byArray.length, n2);
        if (byArray != null && byArray.length >= 4 && 35615 == (n3 = byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00)) {
            ByteArrayInputStream byteArrayInputStream = null;
            GZIPInputStream gZIPInputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            byte[] byArray2 = new byte[2048];
            int n4 = 0;
            try {
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                    while ((n4 = gZIPInputStream.read(byArray2)) >= 0) {
                        byteArrayOutputStream.write(byArray2, 0, n4);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        gZIPInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
                try {
                    gZIPInputStream.close();
                }
                catch (Exception exception) {}
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray;
    }

    public static Object decodeToObject(String string) {
        byte[] byArray = Base64.decode(string);
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                object = null;
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                object = null;
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
            try {
                objectInputStream.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public static boolean encodeToFile(byte[] byArray, String string) {
        boolean bl = false;
        OutputStream outputStream = null;
        try {
            try {
                outputStream = new OutputStream(new FileOutputStream(string), 1);
                outputStream.write(byArray);
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static boolean decodeToFile(String string, String string2) {
        boolean bl = false;
        OutputStream outputStream = null;
        try {
            try {
                outputStream = new OutputStream(new FileOutputStream(string2), 0);
                outputStream.write(string.getBytes(PREFERRED_ENCODING));
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static byte[] decodeFromFile(String string) {
        byte[] byArray = null;
        FilterInputStream filterInputStream = null;
        try {
            File file = new File(string);
            byte[] byArray2 = null;
            int n2 = 0;
            int n3 = 0;
            if (file.length() > Integer.MAX_VALUE) {
                EMLog.e(TAG, "File is too big for this convenience method (" + file.length() + " bytes).");
                return null;
            }
            try {
                byArray2 = new byte[(int)file.length()];
                filterInputStream = new InputStream(new BufferedInputStream(new FileInputStream(file)), 0);
                while ((n3 = ((InputStream)filterInputStream).read(byArray2, n2, 4096)) >= 0) {
                    n2 += n3;
                }
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
            catch (IOException iOException) {
                EMLog.e(TAG, "Error decoding from file " + string);
            }
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static String encodeFromFile(String string) {
        String string2 = null;
        FilterInputStream filterInputStream = null;
        try {
            try {
                File file = new File(string);
                byte[] byArray = new byte[Math.max((int)((double)file.length() * 1.4), 40)];
                int n2 = 0;
                int n3 = 0;
                filterInputStream = new InputStream(new BufferedInputStream(new FileInputStream(file)), 1);
                while ((n3 = ((InputStream)filterInputStream).read(byArray, n2, 4096)) >= 0) {
                    n2 += n3;
                }
                string2 = new String(byArray, 0, n2, PREFERRED_ENCODING);
            }
            catch (IOException iOException) {
                EMLog.e(TAG, "Error encoding from file " + string);
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    public static void encodeFileToFile(String string, String string2) {
        String string3 = Base64.encodeFromFile(string);
        java.io.OutputStream outputStream = null;
        try {
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(string2));
                outputStream.write(string3.getBytes("US-ASCII"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void decodeFileToFile(String string, String string2) {
        byte[] byArray = Base64.decodeFromFile(string);
        java.io.OutputStream outputStream = null;
        try {
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(string2));
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static class InputStream
    extends FilterInputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int numSigBytes;
        private int lineLength;
        private boolean breakLines;
        private int options;
        private byte[] alphabet;
        private byte[] decodabet;

        public InputStream(java.io.InputStream inputStream) {
            this(inputStream, 0);
        }

        public InputStream(java.io.InputStream inputStream, int n2) {
            super(inputStream);
            this.breakLines = (n2 & 8) != 8;
            this.encode = (n2 & 1) == 1;
            this.bufferLength = this.encode ? 4 : 3;
            this.buffer = new byte[this.bufferLength];
            this.position = -1;
            this.lineLength = 0;
            this.options = n2;
            this.alphabet = Base64.getAlphabet(n2);
            this.decodabet = Base64.getDecodabet(n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            if (this.position < 0) {
                byte[] byArray;
                if (this.encode) {
                    byArray = new byte[3];
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < 3) {
                        block13: {
                            try {
                                int n4 = this.in.read();
                                if (n4 >= 0) {
                                    byArray[n3] = (byte)n4;
                                    ++n2;
                                }
                            }
                            catch (IOException iOException) {
                                if (n3 != 0) break block13;
                                throw iOException;
                            }
                        }
                        ++n3;
                    }
                    if (n2 <= 0) return -1;
                    Base64.encode3to4(byArray, 0, n2, this.buffer, 0, this.options);
                    this.position = 0;
                    this.numSigBytes = 4;
                } else {
                    byArray = new byte[4];
                    int n5 = 0;
                    n5 = 0;
                    while (n5 < 4) {
                        int n6 = 0;
                        while ((n6 = this.in.read()) >= 0 && this.decodabet[n6 & 0x7F] <= -5) {
                        }
                        if (n6 < 0) break;
                        byArray[n5] = (byte)n6;
                        ++n5;
                    }
                    if (n5 == 4) {
                        this.numSigBytes = Base64.decode4to3(byArray, 0, this.buffer, 0, this.options);
                        this.position = 0;
                    } else {
                        if (n5 != 0) throw new IOException("Improperly padded Base64 input.");
                        return -1;
                    }
                }
            }
            if (this.position < 0) throw new IOException("Error in Base64 code reading stream.");
            if (this.position >= this.numSigBytes) {
                return -1;
            }
            if (this.encode && this.breakLines && this.lineLength >= 76) {
                this.lineLength = 0;
                return 10;
            }
            ++this.lineLength;
            byte by = this.buffer[this.position++];
            if (this.position < this.bufferLength) return by & 0xFF;
            this.position = -1;
            return by & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.read();
                if (n5 < 0) {
                    if (n4 != 0) break;
                    return -1;
                }
                byArray[n2 + n4] = (byte)n5;
                ++n4;
            }
            return n4;
        }
    }

    public static class OutputStream
    extends FilterOutputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int lineLength;
        private boolean breakLines;
        private byte[] b4;
        private boolean suspendEncoding;
        private int options;
        private byte[] alphabet;
        private byte[] decodabet;

        public OutputStream(java.io.OutputStream outputStream) {
            this(outputStream, 1);
        }

        public OutputStream(java.io.OutputStream outputStream, int n2) {
            super(outputStream);
            this.breakLines = (n2 & 8) != 8;
            this.encode = (n2 & 1) == 1;
            this.bufferLength = this.encode ? 3 : 4;
            this.buffer = new byte[this.bufferLength];
            this.position = 0;
            this.lineLength = 0;
            this.suspendEncoding = false;
            this.b4 = new byte[4];
            this.options = n2;
            this.alphabet = Base64.getAlphabet(n2);
            this.decodabet = Base64.getDecodabet(n2);
        }

        @Override
        public void write(int n2) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(n2);
                return;
            }
            if (this.encode) {
                this.buffer[this.position++] = (byte)n2;
                if (this.position >= this.bufferLength) {
                    this.out.write(Base64.encode3to4(this.b4, this.buffer, this.bufferLength, this.options));
                    this.lineLength += 4;
                    if (this.breakLines && this.lineLength >= 76) {
                        this.out.write(10);
                        this.lineLength = 0;
                    }
                    this.position = 0;
                }
            } else if (this.decodabet[n2 & 0x7F] > -5) {
                this.buffer[this.position++] = (byte)n2;
                if (this.position >= this.bufferLength) {
                    int n3 = Base64.decode4to3(this.buffer, 0, this.b4, 0, this.options);
                    this.out.write(this.b4, 0, n3);
                    this.position = 0;
                }
            } else if (this.decodabet[n2 & 0x7F] != -5) {
                throw new IOException("Invalid character in Base64 data.");
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(byArray, n2, n3);
                return;
            }
            int n4 = 0;
            while (n4 < n3) {
                this.write(byArray[n2 + n4]);
                ++n4;
            }
        }

        public void flushBase64() throws IOException {
            if (this.position > 0) {
                if (this.encode) {
                    this.out.write(Base64.encode3to4(this.b4, this.buffer, this.position, this.options));
                    this.position = 0;
                } else {
                    throw new IOException("Base64 input not properly padded.");
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.flushBase64();
            super.close();
            this.buffer = null;
            this.out = null;
        }

        public void suspendEncoding() throws IOException {
            this.flushBase64();
            this.suspendEncoding = true;
        }

        public void resumeEncoding() {
            this.suspendEncoding = false;
        }
    }
}

