/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jivesoftware.smack.util.StringEncoder;

public class Base32Encoder
implements StringEncoder {
    private static Base32Encoder instance = new Base32Encoder();
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ2345678";

    private Base32Encoder() {
    }

    public static Base32Encoder getInstance() {
        return instance;
    }

    @Override
    public String decode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = string.getBytes();
        int n2 = 0;
        while (n2 < byArray.length) {
            char c2 = (char)byArray[n2];
            if (!Character.isWhitespace(c2)) {
                c2 = Character.toUpperCase(c2);
                byteArrayOutputStream.write((byte)c2);
            }
            ++n2;
        }
        while (byteArrayOutputStream.size() % 8 != 0) {
            byteArrayOutputStream.write(56);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n3 = 0;
        while (n3 < byArray2.length / 8) {
            int n4;
            short[] sArray = new short[8];
            int[] nArray = new int[5];
            int n5 = 8;
            int n6 = 0;
            while (n6 < 8) {
                n4 = byArray2[n3 * 8 + n6];
                if (n4 == 56) break;
                sArray[n6] = (short)ALPHABET.indexOf(byArray2[n3 * 8 + n6]);
                if (sArray[n6] < 0) {
                    return null;
                }
                --n5;
                ++n6;
            }
            n6 = Base32Encoder.paddingToLen(n5);
            if (n6 < 0) {
                return null;
            }
            nArray[0] = sArray[0] << 3 | sArray[1] >> 2;
            nArray[1] = (sArray[1] & 3) << 6 | sArray[2] << 1 | sArray[3] >> 4;
            nArray[2] = (sArray[3] & 0xF) << 4 | sArray[4] >> 1 & 0xF;
            nArray[3] = sArray[4] << 7 | sArray[5] << 2 | sArray[6] >> 3;
            nArray[4] = (sArray[6] & 7) << 5 | sArray[7];
            try {
                n4 = 0;
                while (n4 < n6) {
                    dataOutputStream.writeByte((byte)(nArray[n4] & 0xFF));
                    ++n4;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n3;
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    @Override
    public String encode(String string) {
        byte[] byArray = string.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 < (byArray.length + 4) / 5) {
            short[] sArray = new short[5];
            int[] nArray = new int[8];
            int n3 = 5;
            int n4 = 0;
            while (n4 < 5) {
                if (n2 * 5 + n4 < byArray.length) {
                    sArray[n4] = (short)(byArray[n2 * 5 + n4] & 0xFF);
                } else {
                    sArray[n4] = 0;
                    --n3;
                }
                ++n4;
            }
            n4 = Base32Encoder.lenToPadding(n3);
            nArray[0] = (byte)(sArray[0] >> 3 & 0x1F);
            nArray[1] = (byte)((sArray[0] & 7) << 2 | sArray[1] >> 6 & 3);
            nArray[2] = (byte)(sArray[1] >> 1 & 0x1F);
            nArray[3] = (byte)((sArray[1] & 1) << 4 | sArray[2] >> 4 & 0xF);
            nArray[4] = (byte)((sArray[2] & 0xF) << 1 | sArray[3] >> 7 & 1);
            nArray[5] = (byte)(sArray[3] >> 2 & 0x1F);
            nArray[6] = (byte)((sArray[3] & 3) << 3 | sArray[4] >> 5 & 7);
            nArray[7] = (byte)(sArray[4] & 0x1F);
            int n5 = 0;
            while (n5 < nArray.length - n4) {
                char c2 = ALPHABET.charAt(nArray[n5]);
                byteArrayOutputStream.write(c2);
                ++n5;
            }
            ++n2;
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    private static int lenToPadding(int n2) {
        switch (n2) {
            case 1: {
                return 6;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private static int paddingToLen(int n2) {
        switch (n2) {
            case 6: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 0: {
                return 5;
            }
        }
        return -1;
    }
}

