/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import de.measite.smack.Sasl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.Base64;

public class SASLFacebookConnect
extends SASLMechanism {
    private String sessionKey = "";
    private String sessionSecret = "";
    private String apiKey = "";

    static {
        SASLAuthentication.registerSASLMechanism("X-FACEBOOK-PLATFORM", SASLFacebookConnect.class);
        SASLAuthentication.supportSASLMechanism("X-FACEBOOK-PLATFORM", 0);
    }

    public SASLFacebookConnect(SASLAuthentication sASLAuthentication) {
        super(sASLAuthentication);
    }

    @Override
    protected void authenticate() throws IOException, XMPPException {
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<auth mechanism=\"").append(this.getName());
        stringBuilder.append("\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        stringBuilder.append("</auth>");
        this.getSASLAuthentication().send(new Packet(){

            @Override
            public String toXML() {
                return stringBuilder.toString();
            }
        });
    }

    @Override
    public void authenticate(String string, String string2, String string3) throws IOException, XMPPException {
        if (string == null || string3 == null) {
            throw new IllegalStateException("Invalid parameters!");
        }
        String[] stringArray = string.split("\\|");
        if (stringArray == null || stringArray.length != 2) {
            throw new IllegalStateException("Api key or session key is not present!");
        }
        this.apiKey = stringArray[0];
        this.sessionKey = stringArray[1];
        this.sessionSecret = string3;
        this.authenticationId = this.sessionKey;
        this.password = string3;
        this.hostname = string2;
        String[] stringArray2 = new String[]{"DIGEST-MD5"};
        HashMap hashMap = new HashMap();
        this.sc = Sasl.createSaslClient(stringArray2, null, "xmpp", string2, hashMap, this);
        this.authenticate();
    }

    @Override
    public void authenticate(String string, String string2, CallbackHandler callbackHandler) throws IOException, XMPPException {
        String[] stringArray = new String[]{"DIGEST-MD5"};
        HashMap hashMap = new HashMap();
        this.sc = Sasl.createSaslClient(stringArray, null, "xmpp", string2, hashMap, callbackHandler);
        this.authenticate();
    }

    @Override
    protected String getName() {
        return "X-FACEBOOK-PLATFORM";
    }

    @Override
    public void challengeReceived(String string) throws IOException {
        String string2;
        final StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = null;
        if (string != null) {
            string2 = new String(Base64.decode(string));
            Map<String, String> map = this.getQueryMap(string2);
            String string3 = "1.0";
            String string4 = map.get("nonce");
            String string5 = map.get("method");
            Long l2 = new GregorianCalendar().getTimeInMillis() / 1000L;
            String string6 = "api_key=" + this.apiKey + "call_id=" + l2 + "method=" + string5 + "nonce=" + string4 + "session_key=" + this.sessionKey + "v=" + string3 + this.sessionSecret;
            try {
                string6 = this.MD5(string6);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalStateException(noSuchAlgorithmException);
            }
            String string7 = "api_key=" + this.apiKey + "&" + "call_id=" + l2 + "&" + "method=" + string5 + "&" + "nonce=" + string4 + "&" + "session_key=" + this.sessionKey + "&" + "v=" + string3 + "&" + "sig=" + string6;
            byArray = string7.getBytes();
        }
        string2 = "";
        if (byArray != null) {
            string2 = Base64.encodeBytes(byArray, 8);
        }
        stringBuilder.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        stringBuilder.append(string2);
        stringBuilder.append("</response>");
        this.getSASLAuthentication().send(new Packet(){

            @Override
            public String toXML() {
                return stringBuilder.toString();
            }
        });
    }

    private Map<String, String> getQueryMap(String string) {
        String[] stringArray = string.split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[n3];
            String string3 = string2.split("=")[0];
            String string4 = string2.split("=")[1];
            hashMap.put(string3, string4);
            ++n3;
        }
        return hashMap;
    }

    private String convertToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] >>> 4 & 0xF;
            int n4 = 0;
            do {
                if (n3 >= 0 && n3 <= 9) {
                    stringBuffer.append((char)(48 + n3));
                } else {
                    stringBuffer.append((char)(97 + (n3 - 10)));
                }
                n3 = byArray[n2] & 0xF;
            } while (n4++ < 1);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String MD5(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = new byte[32];
        messageDigest.update(string.getBytes("iso-8859-1"), 0, string.length());
        byArray = messageDigest.digest();
        return this.convertToHex(byArray);
    }
}

