/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.StringUtils;

class HTTPProxySocketFactory
extends SocketFactory {
    private ProxyInfo proxy;
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("HTTP/\\S+\\s(\\d+)\\s(.*)\\s*");

    public HTTPProxySocketFactory(ProxyInfo proxyInfo) {
        this.proxy = proxyInfo;
    }

    @Override
    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        return this.httpProxifiedSocket(string, n2);
    }

    @Override
    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        return this.httpProxifiedSocket(string, n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        return this.httpProxifiedSocket(inetAddress.getHostAddress(), n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        return this.httpProxifiedSocket(inetAddress.getHostAddress(), n2);
    }

    private Socket httpProxifiedSocket(String string, int n2) throws IOException {
        Object object;
        String string2;
        String string3 = this.proxy.getProxyAddress();
        int n3 = this.proxy.getProxyPort();
        Socket socket = new Socket(string3, n3);
        String string4 = "CONNECT " + string + ":" + n2;
        String string5 = this.proxy.getProxyUsername();
        if (string5 == null) {
            string2 = "";
        } else {
            object = this.proxy.getProxyPassword();
            string2 = "\r\nProxy-Authorization: Basic " + StringUtils.encodeBase64(String.valueOf(string5) + ":" + (String)object);
        }
        socket.getOutputStream().write((String.valueOf(string4) + " HTTP/1.1\r\nHost: " + string4 + string2 + "\r\n\r\n").getBytes("UTF-8"));
        object = socket.getInputStream();
        StringBuilder stringBuilder = new StringBuilder(100);
        int n4 = 0;
        do {
            char c2 = (char)((InputStream)object).read();
            stringBuilder.append(c2);
            if (stringBuilder.length() > 1024) {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Recieved header of >1024 characters from " + string3 + ", cancelling connection");
            }
            if (c2 == '\uffffffff') {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP);
            }
            if ((n4 == 0 || n4 == 2) && c2 == '\r') {
                ++n4;
                continue;
            }
            if ((n4 == 1 || n4 == 3) && c2 == '\n') {
                ++n4;
                continue;
            }
            n4 = 0;
        } while (n4 != 4);
        if (n4 != 4) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Never received blank line from " + string3 + ", cancelling connection");
        }
        String string6 = stringBuilder.toString();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string6));
        String string7 = bufferedReader.readLine();
        if (string7 == null) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Empty proxy response from " + string3 + ", cancelling");
        }
        Matcher matcher = RESPONSE_PATTERN.matcher(string7);
        if (!matcher.matches()) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Unexpected proxy response from " + string3 + ": " + string7);
        }
        int n5 = Integer.parseInt(matcher.group(1));
        if (n5 != 200) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP);
        }
        return socket;
    }
}

