/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PrivacyItem;

public class Privacy
extends IQ {
    private boolean declineActiveList = false;
    private String activeName;
    private boolean declineDefaultList = false;
    private String defaultName;
    private Map<String, List<PrivacyItem>> itemLists = new HashMap<String, List<PrivacyItem>>();

    public List<PrivacyItem> setPrivacyList(String string, List<PrivacyItem> list) {
        this.getItemLists().put(string, list);
        return list;
    }

    public List<PrivacyItem> setActivePrivacyList() {
        this.setActiveName(this.getDefaultName());
        return this.getItemLists().get(this.getActiveName());
    }

    public void deletePrivacyList(String string) {
        this.getItemLists().remove(string);
        if (this.getDefaultName() != null && string.equals(this.getDefaultName())) {
            this.setDefaultName(null);
        }
    }

    public List<PrivacyItem> getActivePrivacyList() {
        if (this.getActiveName() == null) {
            return null;
        }
        return this.getItemLists().get(this.getActiveName());
    }

    public List<PrivacyItem> getDefaultPrivacyList() {
        if (this.getDefaultName() == null) {
            return null;
        }
        return this.getItemLists().get(this.getDefaultName());
    }

    public List<PrivacyItem> getPrivacyList(String string) {
        return this.getItemLists().get(string);
    }

    public PrivacyItem getItem(String string, int n2) {
        Iterator<PrivacyItem> iterator = this.getPrivacyList(string).iterator();
        PrivacyItem privacyItem = null;
        while (privacyItem == null && iterator.hasNext()) {
            PrivacyItem privacyItem2 = iterator.next();
            if (privacyItem2.getOrder() != n2) continue;
            privacyItem = privacyItem2;
        }
        return privacyItem;
    }

    public boolean changeDefaultList(String string) {
        if (this.getItemLists().containsKey(string)) {
            this.setDefaultName(string);
            return true;
        }
        return false;
    }

    public void deleteList(String string) {
        this.getItemLists().remove(string);
    }

    public String getActiveName() {
        return this.activeName;
    }

    public void setActiveName(String string) {
        this.activeName = string;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String string) {
        this.defaultName = string;
    }

    public Map<String, List<PrivacyItem>> getItemLists() {
        return this.itemLists;
    }

    public boolean isDeclineActiveList() {
        return this.declineActiveList;
    }

    public void setDeclineActiveList(boolean bl) {
        this.declineActiveList = bl;
    }

    public boolean isDeclineDefaultList() {
        return this.declineDefaultList;
    }

    public void setDeclineDefaultList(boolean bl) {
        this.declineDefaultList = bl;
    }

    public Set<String> getPrivacyListNames() {
        return this.itemLists.keySet();
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"jabber:iq:privacy\">");
        if (this.isDeclineActiveList()) {
            stringBuilder.append("<active/>");
        } else if (this.getActiveName() != null) {
            stringBuilder.append("<active name=\"").append(this.getActiveName()).append("\"/>");
        }
        if (this.isDeclineDefaultList()) {
            stringBuilder.append("<default/>");
        } else if (this.getDefaultName() != null) {
            stringBuilder.append("<default name=\"").append(this.getDefaultName()).append("\"/>");
        }
        for (Map.Entry<String, List<PrivacyItem>> entry : this.getItemLists().entrySet()) {
            String string = entry.getKey();
            List<PrivacyItem> list = entry.getValue();
            if (list.isEmpty()) {
                stringBuilder.append("<list name=\"").append(string).append("\"/>");
            } else {
                stringBuilder.append("<list name=\"").append(string).append("\">");
            }
            for (PrivacyItem privacyItem : list) {
                stringBuilder.append(privacyItem.toXML());
            }
            if (list.isEmpty()) continue;
            stringBuilder.append("</list>");
        }
        stringBuilder.append(this.getExtensionsXML());
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }
}

