/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class Message
extends Packet {
    private Type type = Type.normal;
    private PresenceType presenceType = null;
    private String thread = null;
    private String language;
    private final Set<Subject> subjects = new HashSet<Subject>();
    private final Set<Body> bodies = new HashSet<Body>();

    public Message() {
    }

    public Message(String string) {
        this.setTo(string);
    }

    public Message(String string, Type type) {
        this.setTo(string);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        this.type = type;
    }

    public PresenceType getPresenceType() {
        return this.presenceType;
    }

    public void setPresenceType(PresenceType presenceType) {
        this.presenceType = presenceType;
    }

    public String getSubject() {
        return this.getSubject(null);
    }

    public String getSubject(String string) {
        Subject subject = this.getMessageSubject(string);
        return subject == null ? null : subject.subject;
    }

    private Subject getMessageSubject(String string) {
        string = this.determineLanguage(string);
        for (Subject subject : this.subjects) {
            if (!string.equals(subject.language)) continue;
            return subject;
        }
        return null;
    }

    public Collection<Subject> getSubjects() {
        return Collections.unmodifiableCollection(this.subjects);
    }

    public void setSubject(String string) {
        if (string == null) {
            this.removeSubject("");
            return;
        }
        this.addSubject(null, string);
    }

    public Subject addSubject(String string, String string2) {
        string = this.determineLanguage(string);
        Subject subject = new Subject(string, string2);
        this.subjects.add(subject);
        return subject;
    }

    public boolean removeSubject(String string) {
        string = this.determineLanguage(string);
        for (Subject subject : this.subjects) {
            if (!string.equals(subject.language)) continue;
            return this.subjects.remove(subject);
        }
        return false;
    }

    public boolean removeSubject(Subject subject) {
        return this.subjects.remove(subject);
    }

    public Collection<String> getSubjectLanguages() {
        Subject subject = this.getMessageSubject(null);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Subject subject2 : this.subjects) {
            if (subject2.equals(subject)) continue;
            arrayList.add(subject2.language);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public String getBody() {
        return this.getBody(null);
    }

    public String getBody(String string) {
        Body body = this.getMessageBody(string);
        return body == null ? null : body.message;
    }

    private Body getMessageBody(String string) {
        string = this.determineLanguage(string);
        for (Body body : this.bodies) {
            if (!string.equals(body.language)) continue;
            return body;
        }
        return null;
    }

    public Collection<Body> getBodies() {
        return Collections.unmodifiableCollection(this.bodies);
    }

    public void setBody(String string) {
        if (string == null) {
            this.removeBody("");
            return;
        }
        this.addBody(null, string);
    }

    public Body addBody(String string, String string2) {
        string = this.determineLanguage(string);
        Body body = new Body(string, string2);
        this.bodies.add(body);
        return body;
    }

    public boolean removeBody(String string) {
        string = this.determineLanguage(string);
        for (Body body : this.bodies) {
            if (!string.equals(body.language)) continue;
            return this.bodies.remove(body);
        }
        return false;
    }

    public boolean removeBody(Body body) {
        return this.bodies.remove(body);
    }

    public Collection<String> getBodyLanguages() {
        Body body = this.getMessageBody(null);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Body body2 : this.bodies) {
            if (body2.equals(body)) continue;
            arrayList.add(body2.language);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String string) {
        this.thread = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    private String determineLanguage(String string) {
        String string2 = string = "".equals(string) ? null : string;
        if (string == null && this.language != null) {
            return this.language;
        }
        if (string == null) {
            return Message.getDefaultLanguage();
        }
        return string;
    }

    @Override
    public String toXML() {
        XMPPError xMPPError;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<message");
        if (this.getXmlns() != null) {
            stringBuilder.append(" xmlns=\"").append(this.getXmlns()).append("\"");
        }
        if (this.language != null) {
            stringBuilder.append(" xml:lang=\"").append(this.getLanguage()).append("\"");
        }
        if (this.getPacketID() != null) {
            stringBuilder.append(" id=\"").append(this.getPacketID()).append("\"");
        }
        if (this.getTo() != null) {
            stringBuilder.append(" to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\"");
        }
        if (this.getFrom() != null) {
            stringBuilder.append(" from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\"");
        }
        if (this.type != Type.normal) {
            stringBuilder.append(" type=\"").append((Object)this.type).append("\"");
        }
        if (this.presenceType != null) {
            stringBuilder.append(" presence_type=\"").append((Object)this.presenceType).append("\"");
        }
        stringBuilder.append(">");
        Subject subject = this.getMessageSubject(null);
        if (subject != null) {
            stringBuilder.append("<subject>").append(StringUtils.escapeForXML(subject.subject)).append("</subject>");
        }
        for (Object object2 : this.getSubjects()) {
            if (((Subject)object2).equals(subject)) continue;
            stringBuilder.append("<subject xml:lang=\"").append(((Subject)object2).language).append("\">");
            stringBuilder.append(StringUtils.escapeForXML(((Subject)object2).subject));
            stringBuilder.append("</subject>");
        }
        object2 = this.getMessageBody(null);
        if (object2 != null) {
            stringBuilder.append("<body>").append(StringUtils.escapeForXML(((Body)object2).message)).append("</body>");
        }
        for (Body body : this.getBodies()) {
            if (body.equals(object2)) continue;
            stringBuilder.append("<body xml:lang=\"").append(body.getLanguage()).append("\">");
            stringBuilder.append(StringUtils.escapeForXML(body.getMessage()));
            stringBuilder.append("</body>");
        }
        if (this.thread != null) {
            stringBuilder.append("<thread>").append(this.thread).append("</thread>");
        }
        if (this.type == Type.error && (xMPPError = this.getError()) != null) {
            stringBuilder.append(xMPPError.toXML());
        }
        stringBuilder.append(this.getExtensionsXML());
        stringBuilder.append("</message>");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Message message = (Message)object;
        if (!super.equals(message)) {
            return false;
        }
        if (this.bodies.size() != message.bodies.size() || !this.bodies.containsAll(message.bodies)) {
            return false;
        }
        if (this.language != null ? !this.language.equals(message.language) : message.language != null) {
            return false;
        }
        if (this.subjects.size() != message.subjects.size() || !this.subjects.containsAll(message.subjects)) {
            return false;
        }
        if (this.thread != null ? !this.thread.equals(message.thread) : message.thread != null) {
            return false;
        }
        return this.type == message.type;
    }

    @Override
    public int hashCode() {
        int n2 = this.type != null ? this.type.hashCode() : 0;
        n2 = 31 * n2 + this.subjects.hashCode();
        n2 = 31 * n2 + (this.thread != null ? this.thread.hashCode() : 0);
        n2 = 31 * n2 + (this.language != null ? this.language.hashCode() : 0);
        n2 = 31 * n2 + this.bodies.hashCode();
        return n2;
    }

    public static class Body {
        private String message;
        private String language;

        private Body(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("Language cannot be null.");
            }
            if (string2 == null) {
                throw new NullPointerException("Message cannot be null.");
            }
            this.language = string;
            this.message = string2;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.language.hashCode();
            n3 = 31 * n3 + this.message.hashCode();
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Body body = (Body)object;
            return this.language.equals(body.language) && this.message.equals(body.message);
        }
    }

    public static enum PresenceType {
        available,
        unavailable;


        public static PresenceType fromString(String string) {
            try {
                return PresenceType.valueOf(string);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static class Subject {
        private String subject;
        private String language;

        private Subject(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("Language cannot be null.");
            }
            if (string2 == null) {
                throw new NullPointerException("Subject cannot be null.");
            }
            this.language = string;
            this.subject = string2;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getSubject() {
            return this.subject;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.language.hashCode();
            n3 = 31 * n3 + this.subject.hashCode();
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Subject subject = (Subject)object;
            return this.language.equals(subject.language) && this.subject.equals(subject.subject);
        }
    }

    public static enum Type {
        normal,
        chat,
        groupchat,
        headline,
        error,
        notify;


        public static Type fromString(String string) {
            try {
                return Type.valueOf(string);
            }
            catch (Exception exception) {
                return normal;
            }
        }
    }
}

