/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import com.easemob.util.EMLog;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.WriterListener;

public class FileDebugger
implements SmackDebugger {
    public static boolean printInterpreted = false;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("hh:mm:ss aaa");
    private Connection connection = null;
    private PacketListener listener = null;
    private ConnectionListener connListener = null;
    private Writer writer;
    private Reader reader;
    private ReaderListener readerListener;
    private WriterListener writerListener;
    private static final String TAG = "SMACK:FileDebugger";

    public FileDebugger(Connection connection, Writer writer, Reader reader) {
        this.connection = connection;
        this.writer = writer;
        this.reader = reader;
        this.createDebug();
    }

    private void createDebug() {
        ObservableReader observableReader = new ObservableReader(this.reader);
        this.readerListener = new ReaderListener(){

            @Override
            public void read(String string) {
                if (!EMLog.debugMode) {
                    return;
                }
                EMLog.d(FileDebugger.TAG, " RCV from" + FileDebugger.this.connection.getHost() + ":" + FileDebugger.this.connection.getPort() + "(" + FileDebugger.this.connection.hashCode() + "): " + string);
            }
        };
        observableReader.addReaderListener(this.readerListener);
        ObservableWriter observableWriter = new ObservableWriter(this.writer);
        this.writerListener = new WriterListener(){

            @Override
            public void write(String string) {
                if (!EMLog.debugMode) {
                    return;
                }
                EMLog.d(FileDebugger.TAG, " SENT to" + FileDebugger.this.connection.getHost() + ":" + FileDebugger.this.connection.getPort() + "(" + FileDebugger.this.connection.hashCode() + "): " + string);
            }
        };
        observableWriter.addWriterListener(this.writerListener);
        this.reader = observableReader;
        this.writer = observableWriter;
        this.listener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                if (!EMLog.debugMode) {
                    return;
                }
                if (printInterpreted) {
                    EMLog.d(FileDebugger.TAG, " RCV PKT (" + FileDebugger.this.connection.hashCode() + "): " + packet.toXML());
                }
            }
        };
        this.connListener = new ConnectionListener(){

            @Override
            public void connectionClosed() {
                if (!EMLog.debugMode) {
                    return;
                }
                EMLog.d(FileDebugger.TAG, " Connection closed (" + FileDebugger.this.connection.hashCode() + ")");
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                if (!EMLog.debugMode) {
                    return;
                }
                EMLog.d(FileDebugger.TAG, " Connection closed due to an exception (" + FileDebugger.this.connection.hashCode() + ")");
                exception.printStackTrace();
            }

            @Override
            public void reconnectionFailed(Exception exception) {
                if (!EMLog.debugMode) {
                    return;
                }
                EMLog.d(FileDebugger.TAG, " Reconnection failed due to an exception (" + FileDebugger.this.connection.hashCode() + ")");
                exception.printStackTrace();
            }

            @Override
            public void reconnectionSuccessful() {
                if (!EMLog.debugMode) {
                    return;
                }
                EMLog.d(FileDebugger.TAG, " Connection reconnected (" + FileDebugger.this.connection.hashCode() + ")");
            }

            @Override
            public void reconnectingIn(int n2) {
                if (!EMLog.debugMode) {
                    return;
                }
                EMLog.d(FileDebugger.TAG, " Connection (" + FileDebugger.this.connection.hashCode() + ") will reconnect in " + n2);
            }
        };
    }

    @Override
    public Reader newConnectionReader(Reader reader) {
        ((ObservableReader)this.reader).removeReaderListener(this.readerListener);
        ObservableReader observableReader = new ObservableReader(reader);
        observableReader.addReaderListener(this.readerListener);
        this.reader = observableReader;
        return this.reader;
    }

    @Override
    public Writer newConnectionWriter(Writer writer) {
        ((ObservableWriter)this.writer).removeWriterListener(this.writerListener);
        ObservableWriter observableWriter = new ObservableWriter(writer);
        observableWriter.addWriterListener(this.writerListener);
        this.writer = observableWriter;
        return this.writer;
    }

    @Override
    public void userHasLogged(String string) {
        boolean bl = "".equals(StringUtils.parseName(string));
        String string2 = "User logged (" + this.connection.hashCode() + "): " + (bl ? "" : StringUtils.parseBareAddress(string)) + "@" + this.connection.getServiceName() + ":" + this.connection.getPort();
        string2 = String.valueOf(string2) + "/" + StringUtils.parseResource(string);
        EMLog.d(TAG, string2);
        this.connection.addConnectionListener(this.connListener);
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public PacketListener getReaderListener() {
        return this.listener;
    }

    @Override
    public PacketListener getWriterListener() {
        return null;
    }
}

