/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compression;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;

public class JzlibInputOutputStream
extends XMPPInputOutputStream {
    private static Class<?> zoClass = null;
    private static Class<?> ziClass = null;

    static {
        try {
            zoClass = Class.forName("com.jcraft.jzlib.ZOutputStream");
            ziClass = Class.forName("com.jcraft.jzlib.ZInputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public JzlibInputOutputStream() {
        this.compressionMethod = "zlib";
    }

    @Override
    public boolean isSupported() {
        return zoClass != null && ziClass != null;
    }

    @Override
    public InputStream getInputStream(InputStream inputStream) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<?> constructor = ziClass.getConstructor(InputStream.class);
        Object obj = constructor.newInstance(inputStream);
        Method method = ziClass.getMethod("setFlushMode", Integer.TYPE);
        method.invoke(obj, 2);
        return (InputStream)obj;
    }

    @Override
    public OutputStream getOutputStream(OutputStream outputStream) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = zoClass.getConstructor(OutputStream.class, Integer.TYPE);
        Object obj = constructor.newInstance(outputStream, 9);
        Method method = zoClass.getMethod("setFlushMode", Integer.TYPE);
        method.invoke(obj, 2);
        return (OutputStream)obj;
    }
}

