/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import com.easemob.util.EMLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterStorage;
import org.jivesoftware.smack.ServerTrustManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.dns.HostAddress;

public class XMPPConnection
extends Connection {
    private static final String TAG = "sxmppcon";
    Socket socket;
    String connectionID = null;
    private String user = null;
    private boolean connected = false;
    private volatile boolean socketClosed = false;
    private boolean authenticated = false;
    private boolean wasAuthenticated = false;
    private boolean anonymous = false;
    private boolean usingTLS = false;
    private ParsingExceptionCallback parsingExceptionCallback = SmackConfiguration.getDefaultParsingExceptionCallback();
    PacketWriter packetWriter;
    PacketReader packetReader;
    Roster roster = null;
    private Collection<String> compressionMethods;
    private boolean serverAckdCompression = false;
    private Object mutex = new Object();

    public XMPPConnection(String string, CallbackHandler callbackHandler) {
        super(new ConnectionConfiguration(string));
        this.config.setCompressionEnabled(false);
        this.config.setSASLAuthenticationEnabled(true);
        this.config.setDebuggerEnabled(DEBUG_ENABLED);
        this.config.setCallbackHandler(callbackHandler);
    }

    public XMPPConnection(String string) {
        super(new ConnectionConfiguration(string));
        this.config.setCompressionEnabled(false);
        this.config.setSASLAuthenticationEnabled(true);
        this.config.setDebuggerEnabled(DEBUG_ENABLED);
    }

    public XMPPConnection(ConnectionConfiguration connectionConfiguration) {
        super(connectionConfiguration);
    }

    public XMPPConnection(ConnectionConfiguration connectionConfiguration, CallbackHandler callbackHandler) {
        super(connectionConfiguration);
        connectionConfiguration.setCallbackHandler(callbackHandler);
    }

    @Override
    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    @Override
    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    public void setParsingExceptionCallback(ParsingExceptionCallback parsingExceptionCallback) {
        this.parsingExceptionCallback = parsingExceptionCallback;
    }

    public ParsingExceptionCallback getParsingExceptionCallback() {
        return this.parsingExceptionCallback;
    }

    @Override
    public void login(String string, String string2, String string3) throws XMPPException {
        if (!this.isConnected()) {
            throw new XMPPException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new XMPPException("Already logged in to server.");
        }
        string = string.toLowerCase().trim();
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        String string4 = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasNonAnonymousAuthentication() ? (string2 != null ? this.saslAuthentication.authenticate(string, string2, string3) : this.saslAuthentication.authenticate(string, string3, this.config.getCallbackHandler())) : new NonSASLAuthentication(this).authenticate(string, string2, string3);
        if (string4 != null) {
            this.user = string4;
            this.config.setServiceName(StringUtils.parseServer(string4));
        } else {
            this.user = String.valueOf(string) + "@" + this.getServiceName();
            if (string3 != null) {
                this.user = String.valueOf(this.user) + "/" + string3;
            }
        }
        this.authenticated = true;
        this.anonymous = false;
        if (this.roster == null) {
            this.roster = this.rosterStorage == null ? new Roster(this) : new Roster(this, this.rosterStorage);
        }
        if (this.config.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (this.config.isSendPresence()) {
            this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        }
        this.config.setLoginInfo(string, string2, string3);
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    @Override
    public synchronized void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        String string = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
        this.user = string;
        this.config.setServiceName(StringUtils.parseServer(string));
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        this.authenticated = true;
        this.anonymous = true;
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Roster getRosterWithoutLoad() {
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            if (!this.isAuthenticated() || this.isAnonymous()) {
                if (this.roster == null) {
                    this.roster = this.rosterStorage != null ? new Roster(this, this.rosterStorage) : new Roster(this);
                }
                return this.roster;
            }
        }
        return this.roster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Roster getRoster() {
        Object object = this;
        synchronized (object) {
            if (!this.isAuthenticated() || this.isAnonymous()) {
                if (this.roster == null) {
                    this.roster = this.rosterStorage != null ? new Roster(this, this.rosterStorage) : new Roster(this);
                }
                return this.roster;
            }
        }
        if (!this.config.isRosterLoadedAtLogin() && !this.roster.rosterInitialized) {
            this.roster.reload();
        }
        if (!this.roster.rosterInitialized) {
            try {
                object = this.roster;
                synchronized (object) {
                    long l2 = SmackConfiguration.getPacketReplyTimeout();
                    long l3 = System.currentTimeMillis();
                    while (!this.roster.rosterInitialized) {
                        if (l2 <= 0L) break;
                        this.roster.wait(l2);
                        long l4 = System.currentTimeMillis();
                        l2 -= l4 - l3;
                        l3 = l4;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    public boolean isSocketClosed() {
        return this.socketClosed;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public void release() {
        PacketReader packetReader = this.packetReader;
        PacketWriter packetWriter = this.packetWriter;
        if (packetReader == null || packetWriter == null) {
            return;
        }
        this.shutdown(new Presence(Presence.Type.unavailable));
        this.released = true;
        this.chatManager = null;
        this.wasAuthenticated = false;
    }

    protected void shutdown(Presence presence) {
        EMLog.d(TAG, "(" + this.hashCode() + ") " + "shutdown");
        if (this.packetWriter != null) {
            this.packetWriter.sendPacket(presence);
        }
        this.setWasAuthenticated(this.authenticated);
        this.authenticated = false;
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown();
        }
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socketClosed = true;
        if (this.socket != null) {
            EMLog.d(TAG, "trying to close the socket : " + this.socket);
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        EMLog.d(TAG, "(" + this.hashCode() + ") " + "socket was closed");
        this.connected = false;
        this.reader = null;
        this.writer = null;
        this.saslAuthentication.init();
        this.cancelAllWaiting();
    }

    @Override
    public void disconnect(Presence presence) {
        EMLog.i(TAG, "enter disconnect (" + this.hashCode() + ")");
        PacketReader packetReader = this.packetReader;
        PacketWriter packetWriter = this.packetWriter;
        if (packetReader == null || packetWriter == null) {
            return;
        }
        this.wasAuthenticated = false;
        this.shutdown(presence);
        EMLog.i(TAG, "shutdown was called");
        this.chatManager = null;
    }

    @Override
    public void sendPacket(Packet packet) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        this.packetWriter.sendPacket(packet);
    }

    public void addPacketWriterInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        this.addPacketInterceptor(packetInterceptor, packetFilter);
    }

    public void removePacketWriterInterceptor(PacketInterceptor packetInterceptor) {
        this.removePacketInterceptor(packetInterceptor);
    }

    public void addPacketWriterListener(PacketListener packetListener, PacketFilter packetFilter) {
        this.addPacketSendingListener(packetListener, packetFilter);
    }

    public void removePacketWriterListener(PacketListener packetListener) {
        this.removePacketSendingListener(packetListener);
    }

    /*
     * WARNING - void declaration
     */
    private void connectUsingConfiguration(ConnectionConfiguration connectionConfiguration) throws Exception {
        IOException iOException = null;
        Iterator<HostAddress> iterator = connectionConfiguration.getHostAddresses().iterator();
        LinkedList<HostAddress> linkedList = new LinkedList<HostAddress>();
        boolean bl = false;
        while (iterator.hasNext()) {
            void var10_16;
            iOException = null;
            HostAddress hostAddress = iterator.next();
            String string = hostAddress.getFQDN();
            int n2 = hostAddress.getPort();
            EMLog.d(TAG, "try to connect to host : " + string + " port : " + n2);
            try {
                this.socket = connectionConfiguration.getSocketFactory() == null ? new Socket(string, n2) : connectionConfiguration.getSocketFactory().createSocket(string, n2);
                EMLog.d(TAG, "open a new socket : " + this.socket);
            }
            catch (UnknownHostException unknownHostException) {
                iOException = unknownHostException;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException == null) {
                connectionConfiguration.setUsedHostAddress(hostAddress);
                break;
            }
            hostAddress.setException(iOException);
            linkedList.add(hostAddress);
            if (iterator.hasNext()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (HostAddress object2 : linkedList) {
                stringBuilder.append(object2.getErrorMessage());
                stringBuilder.append("; ");
            }
            if (iOException != null) {
                throw iOException;
            }
            if (bl) {
                XMPPError xMPPError = new XMPPError(XMPPError.Condition.remote_server_error);
            } else {
                XMPPError xMPPError = new XMPPError(XMPPError.Condition.remote_server_timeout);
            }
            throw new XMPPException(stringBuilder.toString(), (XMPPError)var10_16, iOException);
        }
        this.socketClosed = false;
        this.initConnection();
    }

    private void initConnection() throws XMPPException {
        boolean bl = this.packetReader == null || this.packetWriter == null;
        this.compressionHandler = null;
        this.serverAckdCompression = false;
        this.initReaderAndWriter();
        try {
            if (bl) {
                this.packetWriter = new PacketWriter(this);
                this.packetReader = new PacketReader(this);
                if (this.config.isDebuggerEnabled()) {
                    this.addPacketListener(this.debugger.getReaderListener(), null);
                    if (this.debugger.getWriterListener() != null) {
                        this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                    }
                }
            } else {
                this.packetWriter.init();
                this.packetReader.init();
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            if (bl) {
                for (ConnectionCreationListener connectionCreationListener : XMPPConnection.getConnectionCreationListeners()) {
                    connectionCreationListener.connectionCreated(this);
                }
            }
        }
        catch (XMPPException xMPPException) {
            EMLog.d(TAG, "initconnection exception:" + xMPPException.toString());
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetReader = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.writer = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
            this.setWasAuthenticated(this.authenticated);
            this.chatManager = null;
            this.authenticated = false;
            this.connected = false;
            throw xMPPException;
        }
    }

    private void initReaderAndWriter() throws XMPPException {
        try {
            if (this.compressionHandler == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
            } else {
                try {
                    OutputStream outputStream = this.compressionHandler.getOutputStream(this.socket.getOutputStream());
                    this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                    InputStream inputStream = this.compressionHandler.getInputStream(this.socket.getInputStream());
                    this.reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.compressionHandler = null;
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                }
            }
        }
        catch (IOException iOException) {
            throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(XMPPError.Condition.remote_server_error, "XMPPError establishing connection with server."), iOException);
        }
        this.initDebugger();
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    void startTLSReceived(boolean bl) {
        if (bl && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.notifyConnectionError(new IllegalStateException("TLS required by server but not allowed by connection configuration"));
            return;
        }
        if (this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            return;
        }
        try {
            this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.notifyConnectionError(iOException);
        }
    }

    void proceedTLSReceived() throws Exception {
        Constructor<?> constructor;
        SSLContext sSLContext = this.config.getCustomSSLContext();
        KeyStore keyStore = null;
        KeyManager[] keyManagerArray = null;
        PasswordCallback passwordCallback = null;
        if (this.config.getCallbackHandler() == null) {
            keyStore = null;
        } else if (sSLContext == null) {
            if (this.config.getKeystoreType().equals("NONE")) {
                keyStore = null;
                passwordCallback = null;
            } else if (this.config.getKeystoreType().equals("PKCS11")) {
                try {
                    constructor = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    String string = "name = SmartCard\nlibrary = " + this.config.getPKCS11Library();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    Provider provider = (Provider)constructor.newInstance(byteArrayInputStream);
                    Security.addProvider(provider);
                    keyStore = KeyStore.getInstance("PKCS11", provider);
                    passwordCallback = new PasswordCallback("PKCS11 Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{passwordCallback});
                    keyStore.load(null, passwordCallback.getPassword());
                }
                catch (Exception exception) {
                    keyStore = null;
                    passwordCallback = null;
                }
            } else if (this.config.getKeystoreType().equals("Apple")) {
                keyStore = KeyStore.getInstance("KeychainStore", "Apple");
                keyStore.load(null, null);
            } else {
                keyStore = KeyStore.getInstance(this.config.getKeystoreType());
                try {
                    passwordCallback = new PasswordCallback("Keystore Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{passwordCallback});
                    keyStore.load(new FileInputStream(this.config.getKeystorePath()), passwordCallback.getPassword());
                }
                catch (Exception exception) {
                    keyStore = null;
                    passwordCallback = null;
                }
            }
            constructor = KeyManagerFactory.getInstance("SunX509");
            try {
                if (passwordCallback == null) {
                    ((KeyManagerFactory)((Object)constructor)).init(keyStore, null);
                } else {
                    ((KeyManagerFactory)((Object)constructor)).init(keyStore, passwordCallback.getPassword());
                    passwordCallback.clearPassword();
                }
                keyManagerArray = ((KeyManagerFactory)((Object)constructor)).getKeyManagers();
            }
            catch (NullPointerException nullPointerException) {
                keyManagerArray = null;
            }
        }
        if (sSLContext == null) {
            sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerArray, new TrustManager[]{new ServerTrustManager(this.getServiceName(), this.config)}, new SecureRandom());
        }
        constructor = this.socket;
        this.socket = sSLContext.getSocketFactory().createSocket((Socket)((Object)constructor), ((Socket)((Object)constructor)).getInetAddress().getHostAddress(), ((Socket)((Object)constructor)).getPort(), true);
        this.socket.setSoTimeout(0);
        this.socket.setKeepAlive(true);
        this.initReaderAndWriter();
        ((SSLSocket)this.socket).startHandshake();
        this.usingTLS = true;
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    void setAvailableCompressionMethods(Collection<String> collection) {
        this.compressionMethods = collection;
    }

    private XMPPInputOutputStream maybeGetCompressionHandler() {
        if (this.compressionMethods != null) {
            for (XMPPInputOutputStream xMPPInputOutputStream : compressionHandlers) {
                String string;
                if (!xMPPInputOutputStream.isSupported() || !this.compressionMethods.contains(string = xMPPInputOutputStream.getCompressionMethod())) continue;
                return xMPPInputOutputStream;
            }
        }
        return null;
    }

    @Override
    public boolean isUsingCompression() {
        return this.compressionHandler != null && this.serverAckdCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useCompression() throws XMPPException {
        if (this.authenticated) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        this.compressionHandler = this.maybeGetCompressionHandler();
        if (this.compressionHandler != null) {
            this.requestStreamCompression(this.compressionHandler.getCompressionMethod());
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.mutex.wait(SmackConfiguration.getPacketReplyTimeout() * 1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.serverAckdCompression) {
                throw new XMPPException("No respnse from server. Compression ACK is not received from server.");
            }
            return this.isUsingCompression();
        }
        return false;
    }

    private void requestStreamCompression(String string) {
        try {
            this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
            this.writer.write("<method>" + string + "</method></compress>");
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.notifyConnectionError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startStreamCompression() throws Exception {
        this.serverAckdCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamCompressionDenied() {
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    @Override
    public void connect() throws Exception {
        if (this.connected) {
            return;
        }
        this.connectUsingConfiguration(this.config);
        if (this.connected && this.wasAuthenticated) {
            if (this.isAnonymous()) {
                this.loginAnonymously();
            } else {
                this.login(this.config.getUsername(), this.config.getPassword(), this.config.getResource());
            }
            this.notifyReconnection();
        }
    }

    private void setWasAuthenticated(boolean bl) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = bl;
        }
    }

    @Override
    public void setRosterStorage(RosterStorage rosterStorage) throws IllegalStateException {
        if (this.roster != null) {
            throw new IllegalStateException("Roster is already initialized");
        }
        this.rosterStorage = rosterStorage;
    }

    void notifyConnectionError(Exception exception) {
        if (this.packetReader == null || this.packetWriter == null) {
            return;
        }
        if (this.packetReader.done && this.packetWriter.done) {
            return;
        }
        this.packetReader.done = true;
        this.packetWriter.done = true;
        this.shutdown(new Presence(Presence.Type.unavailable));
        for (ConnectionListener connectionListener : this.getConnectionListeners()) {
            try {
                connectionListener.connectionClosedOnError(exception);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    protected void notifyReconnection() {
        for (ConnectionListener connectionListener : this.getConnectionListeners()) {
            try {
                connectionListener.reconnectionSuccessful();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getIP() {
        return this.socket.getInetAddress().getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllWaiting() {
        Object object;
        if (this.mutex != null) {
            object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
        }
        if (this.packetReader != null) {
            object = this.packetReader;
            synchronized (object) {
                this.packetReader.notifyAll();
            }
        }
        if (this.saslAuthentication != null) {
            object = this.saslAuthentication;
            synchronized (object) {
                this.saslAuthentication.notifyAll();
            }
        }
    }
}

