/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.jivesoftware.smack.parsing.ExceptionThrowingCallback;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public final class SmackConfiguration {
    private static final String SMACK_VERSION = "3.3.1";
    private static int packetReplyTimeout = 10000;
    private static Vector<String> defaultMechs = new Vector();
    private static boolean localSocks5ProxyEnabled = true;
    private static int localSocks5ProxyPort = 7777;
    private static int packetCollectorSize = 5000;
    private static int defaultPingInterval = 1800;
    private static ParsingExceptionCallback defaultCallback = new ExceptionThrowingCallback();
    private static boolean autoEnableEntityCaps = true;

    static {
        try {
            ClassLoader[] classLoaderArray;
            ClassLoader[] classLoaderArray2 = classLoaderArray = SmackConfiguration.getClassLoaders();
            int n2 = classLoaderArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ClassLoader classLoader = classLoaderArray2[n3];
                Enumeration<URL> enumeration = classLoader.getResources("META-INF/smack-config.xml");
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    InputStream inputStream = null;
                    try {
                        try {
                            inputStream = uRL.openStream();
                            XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
                            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                            xmlPullParser.setInput(inputStream, "UTF-8");
                            int n4 = xmlPullParser.getEventType();
                            do {
                                if (n4 != 2) continue;
                                if (xmlPullParser.getName().equals("className")) {
                                    SmackConfiguration.parseClassToLoad(xmlPullParser);
                                    continue;
                                }
                                if (xmlPullParser.getName().equals("packetReplyTimeout")) {
                                    packetReplyTimeout = SmackConfiguration.parseIntProperty(xmlPullParser, packetReplyTimeout);
                                    continue;
                                }
                                if (xmlPullParser.getName().equals("mechName")) {
                                    defaultMechs.add(xmlPullParser.nextText());
                                    continue;
                                }
                                if (xmlPullParser.getName().equals("localSocks5ProxyEnabled")) {
                                    localSocks5ProxyEnabled = Boolean.parseBoolean(xmlPullParser.nextText());
                                    continue;
                                }
                                if (xmlPullParser.getName().equals("localSocks5ProxyPort")) {
                                    localSocks5ProxyPort = SmackConfiguration.parseIntProperty(xmlPullParser, localSocks5ProxyPort);
                                    continue;
                                }
                                if (xmlPullParser.getName().equals("packetCollectorSize")) {
                                    packetCollectorSize = SmackConfiguration.parseIntProperty(xmlPullParser, packetCollectorSize);
                                    continue;
                                }
                                if (xmlPullParser.getName().equals("defaultPingInterval")) {
                                    defaultPingInterval = SmackConfiguration.parseIntProperty(xmlPullParser, defaultPingInterval);
                                    continue;
                                }
                                if (!xmlPullParser.getName().equals("autoEnableEntityCaps")) continue;
                                autoEnableEntityCaps = Boolean.parseBoolean(xmlPullParser.nextText());
                            } while ((n4 = xmlPullParser.next()) != 1);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception2) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private SmackConfiguration() {
    }

    public static String getVersion() {
        return SMACK_VERSION;
    }

    public static int getPacketReplyTimeout() {
        if (packetReplyTimeout <= 0) {
            packetReplyTimeout = 10000;
        }
        return packetReplyTimeout;
    }

    public static void setPacketReplyTimeout(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        packetReplyTimeout = n2;
    }

    public static int getPacketCollectorSize() {
        return packetCollectorSize;
    }

    public static void setPacketCollectorSize(int n2) {
        packetCollectorSize = n2;
    }

    public static void addSaslMech(String string) {
        if (!defaultMechs.contains(string)) {
            defaultMechs.add(string);
        }
    }

    public static void addSaslMechs(Collection<String> collection) {
        for (String string : collection) {
            SmackConfiguration.addSaslMech(string);
        }
    }

    public static void removeSaslMech(String string) {
        if (defaultMechs.contains(string)) {
            defaultMechs.remove(string);
        }
    }

    public static void removeSaslMechs(Collection<String> collection) {
        for (String string : collection) {
            SmackConfiguration.removeSaslMech(string);
        }
    }

    public static List<String> getSaslMechs() {
        return defaultMechs;
    }

    public static boolean isLocalSocks5ProxyEnabled() {
        return localSocks5ProxyEnabled;
    }

    public static void setLocalSocks5ProxyEnabled(boolean bl) {
        localSocks5ProxyEnabled = bl;
    }

    public static int getLocalSocks5ProxyPort() {
        return localSocks5ProxyPort;
    }

    public static void setLocalSocks5ProxyPort(int n2) {
        localSocks5ProxyPort = n2;
    }

    public static int getDefaultPingInterval() {
        return defaultPingInterval;
    }

    public static void setDefaultPingInterval(int n2) {
        defaultPingInterval = n2;
    }

    public static boolean autoEnableEntityCaps() {
        return autoEnableEntityCaps;
    }

    public static void setAutoEnableEntityCaps(boolean bl) {
        autoEnableEntityCaps = bl;
    }

    public static void setDefaultParsingExceptionCallback(ParsingExceptionCallback parsingExceptionCallback) {
        defaultCallback = parsingExceptionCallback;
    }

    public static ParsingExceptionCallback getDefaultParsingExceptionCallback() {
        return defaultCallback;
    }

    private static void parseClassToLoad(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.nextText();
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error! A startup class specified in smack-config.xml could not be loaded: " + string);
        }
    }

    private static int parseIntProperty(XmlPullParser xmlPullParser, int n2) throws Exception {
        try {
            return Integer.parseInt(xmlPullParser.nextText());
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return n2;
        }
    }

    private static ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaderArray = new ClassLoader[]{SmackConfiguration.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        ClassLoader[] classLoaderArray2 = classLoaderArray;
        int n2 = classLoaderArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ClassLoader classLoader = classLoaderArray2[n3];
            if (classLoader != null) {
                arrayList.add(classLoader);
            }
            ++n3;
        }
        return arrayList.toArray(new ClassLoader[arrayList.size()]);
    }
}

