/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.RosterStorage;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;

public class Roster {
    private static SubscriptionMode defaultSubscriptionMode = SubscriptionMode.accept_all;
    private RosterStorage persistentStorage;
    private Connection connection;
    private final Map<String, RosterGroup> groups;
    private final Map<String, RosterEntry> entries;
    private final List<RosterEntry> unfiledEntries;
    private final List<RosterListener> rosterListeners;
    private Map<String, Map<String, Presence>> presenceMap;
    boolean rosterInitialized = false;
    private PresencePacketListener presencePacketListener;
    private SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();
    private String requestPacketId;

    public static SubscriptionMode getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    public static void setDefaultSubscriptionMode(SubscriptionMode subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    Roster(Connection connection, RosterStorage rosterStorage) {
        this(connection);
        this.persistentStorage = rosterStorage;
        this.loadFromStorage();
    }

    Roster(Connection connection) {
        this.connection = connection;
        if (!connection.getConfiguration().isRosterVersioningAvailable()) {
            this.persistentStorage = null;
        }
        this.groups = new ConcurrentHashMap<String, RosterGroup>();
        this.unfiledEntries = new CopyOnWriteArrayList<RosterEntry>();
        this.entries = new ConcurrentHashMap<String, RosterEntry>();
        this.rosterListeners = new CopyOnWriteArrayList<RosterListener>();
        this.presenceMap = new ConcurrentHashMap<String, Map<String, Presence>>();
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(RosterPacket.class);
        connection.addPacketListener(new RosterPacketListener(), packetTypeFilter);
        PacketTypeFilter packetTypeFilter2 = new PacketTypeFilter(Presence.class);
        this.presencePacketListener = new PresencePacketListener();
        connection.addPacketListener(this.presencePacketListener, packetTypeFilter2);
        final AbstractConnectionListener abstractConnectionListener = new AbstractConnectionListener(){

            @Override
            public void connectionClosed() {
                Roster.this.setOfflinePresences();
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                Roster.this.setOfflinePresences();
            }
        };
        if (!this.connection.isConnected()) {
            Connection.addConnectionCreationListener(new ConnectionCreationListener(){

                @Override
                public void connectionCreated(Connection connection) {
                    if (connection.equals(Roster.this.connection)) {
                        Roster.this.connection.addConnectionListener(abstractConnectionListener);
                    }
                }
            });
        } else {
            connection.addConnectionListener(abstractConnectionListener);
        }
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public void reload() {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Not logged in to server.");
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        RosterPacket rosterPacket = new RosterPacket();
        if (this.persistentStorage != null) {
            rosterPacket.setVersion(this.persistentStorage.getRosterVersion());
        }
        this.requestPacketId = rosterPacket.getPacketID();
        PacketIDFilter packetIDFilter = new PacketIDFilter(this.requestPacketId);
        this.connection.addPacketListener(new RosterResultListener(), packetIDFilter);
        this.connection.sendPacket(rosterPacket);
    }

    public void addRosterListener(RosterListener rosterListener) {
        if (!this.rosterListeners.contains(rosterListener)) {
            this.rosterListeners.add(rosterListener);
        }
    }

    public void removeRosterListener(RosterListener rosterListener) {
        this.rosterListeners.remove(rosterListener);
    }

    public RosterGroup createGroup(String string) {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Not logged in to server.");
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (this.groups.containsKey(string)) {
            throw new IllegalArgumentException("Group with name " + string + " alread exists.");
        }
        RosterGroup rosterGroup = new RosterGroup(string, this.connection);
        this.groups.put(string, rosterGroup);
        return rosterGroup;
    }

    public void createEntry(String string, String string2, String[] stringArray) throws XMPPException {
        Object object;
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Not logged in to server.");
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.SET);
        RosterPacket.Item item = new RosterPacket.Item(string, string2);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = stringArray2[n3];
                if (object != null && ((String)object).trim().length() > 0) {
                    item.addGroupName((String)object);
                }
                ++n3;
            }
        }
        rosterPacket.addRosterItem(item);
        object = this.connection.createPacketCollector(new PacketIDFilter(rosterPacket.getPacketID()));
        this.connection.sendPacket(rosterPacket);
        IQ iQ = (IQ)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
        ((PacketCollector)object).cancel();
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        Presence presence = new Presence(Presence.Type.subscribe);
        presence.setTo(string);
        this.connection.sendPacket(presence);
    }

    private void insertRosterItems(List<RosterPacket.Item> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Iterator<RosterPacket.Item> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.insertRosterItem(iterator.next(), arrayList, arrayList2, arrayList3);
        }
        this.fireRosterChangedEvent(arrayList, arrayList2, arrayList3);
    }

    private void insertRosterItem(RosterPacket.Item item, Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        Object object4;
        RosterEntry rosterEntry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), this, this.connection);
        if (RosterPacket.ItemType.remove.equals((Object)item.getItemType())) {
            if (this.entries.containsKey(item.getUser())) {
                this.entries.remove(item.getUser());
            }
            if (this.unfiledEntries.contains(rosterEntry)) {
                this.unfiledEntries.remove(rosterEntry);
            }
            object4 = String.valueOf(StringUtils.parseName(item.getUser())) + "@" + StringUtils.parseServer(item.getUser());
            this.presenceMap.remove(object4);
            if (collection3 != null) {
                collection3.add(item.getUser());
            }
        } else {
            if (RosterPacket.ItemType.to.equals((Object)item.getItemType())) {
                return;
            }
            if (!this.entries.containsKey(item.getUser())) {
                this.entries.put(item.getUser(), rosterEntry);
                if (collection != null) {
                    collection.add(item.getUser());
                }
            } else {
                this.entries.put(item.getUser(), rosterEntry);
                if (collection2 != null) {
                    collection2.add(item.getUser());
                }
            }
            if (!item.getGroupNames().isEmpty()) {
                this.unfiledEntries.remove(rosterEntry);
            } else if (!this.unfiledEntries.contains(rosterEntry)) {
                this.unfiledEntries.add(rosterEntry);
            }
        }
        object4 = new ArrayList();
        for (RosterGroup rosterGroup : this.getGroups()) {
            if (!rosterGroup.contains(rosterEntry)) continue;
            object4.add(rosterGroup.getName());
        }
        if (!RosterPacket.ItemType.remove.equals((Object)item.getItemType())) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : item.getGroupNames()) {
                arrayList.add(string);
                RosterGroup rosterGroup = this.getGroup(string);
                if (rosterGroup == null) {
                    rosterGroup = this.createGroup(string);
                    this.groups.put(string, rosterGroup);
                }
                rosterGroup.addEntryLocal(rosterEntry);
            }
            for (String string : arrayList) {
                object4.remove(string);
            }
        }
        Iterator iterator = object4.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RosterGroup rosterGroup = this.getGroup(string);
            rosterGroup.removeEntryLocal(rosterEntry);
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(string);
        }
        for (RosterGroup rosterGroup : this.getGroups()) {
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(rosterGroup.getName());
        }
    }

    public void removeEntry(RosterEntry rosterEntry) throws XMPPException {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Not logged in to server.");
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (!this.entries.containsKey(rosterEntry.getUser())) {
            return;
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.SET);
        RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
        item.setItemType(RosterPacket.ItemType.remove);
        rosterPacket.addRosterItem(item);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(rosterPacket.getPacketID()));
        this.connection.sendPacket(rosterPacket);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
    }

    public int getEntryCount() {
        return this.getEntries().size();
    }

    public Collection<RosterEntry> getEntries() {
        HashSet<RosterEntry> hashSet = new HashSet<RosterEntry>();
        for (RosterGroup rosterGroup : this.getGroups()) {
            hashSet.addAll(rosterGroup.getEntries());
        }
        hashSet.addAll(this.unfiledEntries);
        return Collections.unmodifiableCollection(hashSet);
    }

    public int getUnfiledEntryCount() {
        return this.unfiledEntries.size();
    }

    public Collection<RosterEntry> getUnfiledEntries() {
        return Collections.unmodifiableList(this.unfiledEntries);
    }

    public RosterEntry getEntry(String string) {
        if (string == null) {
            return null;
        }
        return this.entries.get(string.toLowerCase());
    }

    public boolean contains(String string) {
        return this.getEntry(string) != null;
    }

    public RosterGroup getGroup(String string) {
        return this.groups.get(string);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Collection<RosterGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Presence getPresence(String string) {
        String string2 = this.getPresenceMapKey(StringUtils.parseBareAddress(string));
        Map<String, Presence> map = this.presenceMap.get(string2);
        if (map == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        Presence presence = null;
        for (String string3 : map.keySet()) {
            Presence.Mode mode;
            Presence presence2 = map.get(string3);
            if (!presence2.isAvailable()) continue;
            if (presence == null || presence2.getPriority() > presence.getPriority()) {
                presence = presence2;
                continue;
            }
            if (presence2.getPriority() != presence.getPriority()) continue;
            Presence.Mode mode2 = presence2.getMode();
            if (mode2 == null) {
                mode2 = Presence.Mode.available;
            }
            if ((mode = presence.getMode()) == null) {
                mode = Presence.Mode.available;
            }
            if (mode2.compareTo(mode) >= 0) continue;
            presence = presence2;
        }
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        return presence;
    }

    public Presence getPresenceResource(String string) {
        String string2 = this.getPresenceMapKey(string);
        String string3 = StringUtils.parseResource(string);
        Map<String, Presence> map = this.presenceMap.get(string2);
        if (map == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        Presence presence = map.get(string3);
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        return presence;
    }

    public Iterator<Presence> getPresences(String string) {
        Presence presence3;
        String string2 = this.getPresenceMapKey(string);
        Map<String, Presence> map = this.presenceMap.get(string2);
        if (map == null) {
            Presence presence2 = new Presence(Presence.Type.unavailable);
            presence2.setFrom(string);
            return Arrays.asList(presence2).iterator();
        }
        ArrayList<Presence> arrayList = new ArrayList<Presence>();
        for (Presence presence3 : map.values()) {
            if (!presence3.isAvailable()) continue;
            arrayList.add(presence3);
        }
        if (!arrayList.isEmpty()) {
            return arrayList.iterator();
        }
        presence3 = new Presence(Presence.Type.unavailable);
        presence3.setFrom(string);
        return Arrays.asList(presence3).iterator();
    }

    private String getPresenceMapKey(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (!this.contains(string)) {
            string2 = StringUtils.parseBareAddress(string);
        }
        return string2.toLowerCase();
    }

    private void setOfflinePresences() {
        for (String string : this.presenceMap.keySet()) {
            Map<String, Presence> map = this.presenceMap.get(string);
            if (map == null) continue;
            for (String string2 : map.keySet()) {
                Presence presence = new Presence(Presence.Type.unavailable);
                presence.setFrom(String.valueOf(string) + "/" + string2);
                this.presencePacketListener.processPacket(presence);
            }
        }
    }

    private void fireRosterChangedEvent(Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        for (RosterListener rosterListener : this.rosterListeners) {
            if (!collection.isEmpty()) {
                rosterListener.entriesAdded(collection);
            }
            if (!collection2.isEmpty()) {
                rosterListener.entriesUpdated(collection2);
            }
            if (collection3.isEmpty()) continue;
            rosterListener.entriesDeleted(collection3);
        }
    }

    private void fireRosterPresenceEvent(Presence presence) {
        for (RosterListener rosterListener : this.rosterListeners) {
            rosterListener.presenceChanged(presence);
        }
    }

    public void loadFromStorage() {
        if (this.persistentStorage != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (RosterPacket.Item item : this.persistentStorage.getEntries()) {
                this.insertRosterItem(item, arrayList, arrayList2, arrayList3);
            }
        }
    }

    private class PresencePacketListener
    implements PacketListener {
        private PresencePacketListener() {
        }

        @Override
        public void processPacket(Packet packet) {
            Presence presence = (Presence)packet;
            String string = presence.getFrom();
            String string2 = Roster.this.getPresenceMapKey(string);
            if (presence.getType() == Presence.Type.available) {
                Map<String, Presence> map;
                if (Roster.this.presenceMap.get(string2) == null) {
                    map = new ConcurrentHashMap();
                    Roster.this.presenceMap.put(string2, map);
                } else {
                    map = (Map)Roster.this.presenceMap.get(string2);
                }
                map.remove("");
                map.put(StringUtils.parseResource(string), presence);
                RosterEntry rosterEntry = (RosterEntry)Roster.this.entries.get(string2);
                if (rosterEntry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            } else if (presence.getType() == Presence.Type.unavailable) {
                Object object;
                if ("".equals(StringUtils.parseResource(string))) {
                    if (Roster.this.presenceMap.get(string2) == null) {
                        object = new ConcurrentHashMap();
                        Roster.this.presenceMap.put(string2, object);
                    } else {
                        object = (Map)Roster.this.presenceMap.get(string2);
                    }
                    object.put("", presence);
                } else if (Roster.this.presenceMap.get(string2) != null) {
                    object = (Map)Roster.this.presenceMap.get(string2);
                    object.put(StringUtils.parseResource(string), presence);
                }
                object = (RosterEntry)Roster.this.entries.get(string2);
                if (object != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            } else if (presence.getType() == Presence.Type.subscribe) {
                if (Roster.this.subscriptionMode == SubscriptionMode.accept_all) {
                    Presence presence2 = new Presence(Presence.Type.subscribed);
                    presence2.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(presence2);
                } else if (Roster.this.subscriptionMode == SubscriptionMode.reject_all) {
                    Presence presence3 = new Presence(Presence.Type.unsubscribed);
                    presence3.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(presence3);
                }
            } else if (presence.getType() == Presence.Type.unsubscribe) {
                if (Roster.this.subscriptionMode != SubscriptionMode.manual) {
                    Presence presence4 = new Presence(Presence.Type.unsubscribed);
                    presence4.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(presence4);
                }
            } else if (presence.getType() == Presence.Type.error && "".equals(StringUtils.parseResource(string))) {
                Map<String, Presence> map;
                if (!Roster.this.presenceMap.containsKey(string2)) {
                    map = new ConcurrentHashMap();
                    Roster.this.presenceMap.put(string2, map);
                } else {
                    map = (Map)Roster.this.presenceMap.get(string2);
                    map.clear();
                }
                map.put("", presence);
                RosterEntry rosterEntry = (RosterEntry)Roster.this.entries.get(string2);
                if (rosterEntry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            }
        }
    }

    private class RosterPacketListener
    implements PacketListener {
        private RosterPacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPacket(Packet packet) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            String string = null;
            RosterPacket rosterPacket = (RosterPacket)packet;
            ArrayList<RosterPacket.Item> arrayList4 = new ArrayList<RosterPacket.Item>();
            for (RosterPacket.Item item : rosterPacket.getRosterItems()) {
                arrayList4.add(item);
            }
            if (rosterPacket.getVersion() == null) {
                Roster.this.persistentStorage = null;
            } else {
                string = rosterPacket.getVersion();
            }
            for (RosterPacket.Item item : arrayList4) {
                Roster.this.insertRosterItem(item, arrayList, arrayList2, arrayList3);
            }
            if (rosterPacket.getType() == IQ.Type.RESULT) {
                HashSet<String> hashSet = new HashSet<String>();
                for (RosterPacket.Item item : arrayList4) {
                    if (item.getItemType() != RosterPacket.ItemType.both && item.getItemType() != RosterPacket.ItemType.from) continue;
                    hashSet.add(item.getUser());
                }
                for (String string2 : Roster.this.entries.keySet()) {
                    if (hashSet.contains(string2)) continue;
                    arrayList3.add(string2);
                }
            }
            if (Roster.this.persistentStorage != null) {
                for (RosterPacket.Item item : rosterPacket.getRosterItems()) {
                    if (item.getItemType().equals((Object)RosterPacket.ItemType.remove)) {
                        Roster.this.persistentStorage.removeEntry(item.getUser(), string);
                        continue;
                    }
                    Roster.this.persistentStorage.addEntry(item, string);
                }
                if (rosterPacket.getType() == IQ.Type.RESULT && arrayList3.size() > 0) {
                    for (String string3 : arrayList3) {
                        if (Roster.this.entries.containsKey(string3)) {
                            RosterEntry rosterEntry = (RosterEntry)Roster.this.entries.get(string3);
                            Roster.this.entries.remove(string3);
                            Roster.this.unfiledEntries.remove(rosterEntry);
                        }
                        Roster.this.persistentStorage.removeEntry(string3, string);
                        EMLog.d("Roster", "roster remove:" + string3);
                    }
                }
            }
            Roster roster = Roster.this;
            synchronized (roster) {
                Roster.this.rosterInitialized = true;
                EMLog.d("roster", "rosterInitialized set to true 1");
                Roster.this.notifyAll();
            }
            Roster.this.fireRosterChangedEvent(arrayList, arrayList2, arrayList3);
        }
    }

    private class RosterResultListener
    implements PacketListener {
        private RosterResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPacket(Packet packet) {
            IQ iQ;
            if (packet instanceof IQ && !(packet instanceof RosterPacket) && (iQ = (IQ)packet).getType().equals(IQ.Type.RESULT) && iQ.getExtensions().isEmpty()) {
                Roster roster = Roster.this;
                synchronized (roster) {
                    Roster.this.rosterInitialized = true;
                    EMLog.d("roster", "rosterInitialized set to true 2");
                    Roster.this.notifyAll();
                }
            }
            Roster.this.connection.removePacketListener(this);
        }
    }

    public static enum SubscriptionMode {
        accept_all,
        reject_all,
        manual;

    }
}

