/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;

class PacketWriter {
    private Thread writerThread;
    private Thread keepAliveThread;
    private Writer writer;
    private XMPPConnection connection;
    private final BlockingQueue<Packet> queue = new ArrayBlockingQueue<Packet>(500, true);
    volatile boolean done;

    protected PacketWriter(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.init();
    }

    protected void init() {
        this.writer = this.connection.writer;
        this.done = false;
        this.writerThread = new Thread(){

            @Override
            public void run() {
                PacketWriter.this.writePackets(this);
            }
        };
        this.writerThread.setName("Smack Packet Writer (" + this.connection.connectionCounterValue + ")");
        this.writerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) {
        if (!this.done) {
            this.connection.firePacketInterceptors(packet);
            try {
                this.queue.put(packet);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
            BlockingQueue<Packet> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                this.queue.notifyAll();
            }
            this.connection.firePacketSendingListeners(packet);
        }
    }

    public void startup() {
        this.writerThread.start();
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.done = true;
        BlockingQueue<Packet> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notifyAll();
        }
        if (this.keepAliveThread != null) {
            this.keepAliveThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet nextPacket() {
        Packet packet = null;
        while (!this.done && (packet = (Packet)this.queue.poll()) == null) {
            try {
                BlockingQueue<Packet> blockingQueue = this.queue;
                synchronized (blockingQueue) {
                    this.queue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return packet;
    }

    /*
     * Unable to fully structure code
     */
    private void writePackets(Thread var1_1) {
        block19: {
            try {
                this.openStream();
                if (true) ** GOTO lbl9
                do {
                    if ((var2_2 = this.nextPacket()) != null) {
                        this.writer.write(var2_2.toXML());
                        if (this.queue.isEmpty()) {
                            this.writer.flush();
                        }
                    }
lbl9:
                    // 6 sources

                    if (this.done) break;
                } while (this.writerThread == var1_1);
                try {
                    while (!this.queue.isEmpty()) {
                        var2_2 = (Packet)this.queue.remove();
                        this.writer.write(var2_2.toXML());
                    }
                    this.writer.flush();
                }
                catch (Exception var2_3) {
                    var2_3.printStackTrace();
                }
                this.queue.clear();
                try {
                    try {
                        this.writer.write("</stream:stream>");
                        this.writer.flush();
                    }
                    catch (Exception var2_4) {
                        try {
                            this.writer.close();
                        }
                        catch (Exception var4_6) {}
                    }
                }
                finally {
                    try {
                        this.writer.close();
                    }
                    catch (Exception var4_8) {}
                }
            }
            catch (IOException var2_5) {
                if (this.done || this.connection.isSocketClosed()) break block19;
                this.done = true;
                if (this.connection.packetReader == null) break block19;
                this.connection.notifyConnectionError(var2_5);
            }
        }
    }

    void openStream() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<stream:stream");
        stringBuilder.append(" to=\"").append(this.connection.getServiceName()).append("\"");
        stringBuilder.append(" xmlns=\"jabber:client\"");
        stringBuilder.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        stringBuilder.append(" version=\"1.0\">");
        this.writer.write(stringBuilder.toString());
        this.writer.flush();
    }
}

