/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import com.easemob.util.EMLog;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.parsing.UnparsablePacket;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class PacketReader {
    private static final String TAG = "PacketReader";
    private Thread readerThread;
    private ExecutorService listenerExecutor;
    private XMPPConnection connection;
    private XmlPullParser parser;
    volatile boolean done;
    private String connectionID = null;
    private boolean featuresAreParsed = false;

    protected PacketReader(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.init();
    }

    protected void init() {
        this.done = false;
        this.connectionID = null;
        this.featuresAreParsed = false;
        this.readerThread = new Thread(){

            @Override
            public void run() {
                PacketReader.this.parsePackets(this);
            }
        };
        this.readerThread.setName("Smack Packet Reader (" + this.connection.connectionCounterValue + ")");
        this.readerThread.setDaemon(true);
        this.listenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Smack Listener Processor (" + ((PacketReader)PacketReader.this).connection.connectionCounterValue + ")");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.resetParser();
    }

    public synchronized void startup() throws XMPPException {
        this.readerThread.start();
        try {
            int n2 = SmackConfiguration.getPacketReplyTimeout();
            this.wait(n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.connectionID == null) {
            throw new XMPPException("Connection failed. No response from server.");
        }
        if (!this.featuresAreParsed) {
            throw new XMPPException("Connection failed. The features are not received from server.");
        }
        this.connection.connectionID = this.connectionID;
    }

    public void shutdown() {
        if (!this.done) {
            for (ConnectionListener connectionListener : this.connection.getConnectionListeners()) {
                try {
                    connectionListener.connectionClosed();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.done = true;
        this.listenerExecutor.shutdown();
    }

    private void resetParser() {
        try {
            this.parser = XmlPullParserFactory.newInstance().newPullParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(this.connection.reader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
    }

    private void parsePackets(Thread thread) {
        block41: {
            try {
                int n2 = this.parser.getEventType();
                do {
                    if (n2 == 2) {
                        UnparsablePacket unparsablePacket;
                        String string;
                        int n3 = this.parser.getDepth();
                        ParsingExceptionCallback parsingExceptionCallback = this.connection.getParsingExceptionCallback();
                        if (this.parser.getName().equals("message")) {
                            Packet packet;
                            try {
                                packet = PacketParserUtils.parseMessage(this.parser);
                            }
                            catch (Exception exception) {
                                string = PacketParserUtils.parseContentDepth(this.parser, n3);
                                unparsablePacket = new UnparsablePacket(string, exception);
                                if (parsingExceptionCallback == null) continue;
                                parsingExceptionCallback.handleUnparsablePacket(unparsablePacket);
                                continue;
                            }
                            this.processPacket(packet);
                        } else if (this.parser.getName().equals("iq")) {
                            IQ iQ;
                            try {
                                iQ = PacketParserUtils.parseIQ(this.parser, this.connection);
                            }
                            catch (Exception exception) {
                                string = PacketParserUtils.parseContentDepth(this.parser, n3);
                                unparsablePacket = new UnparsablePacket(string, exception);
                                if (parsingExceptionCallback == null) continue;
                                parsingExceptionCallback.handleUnparsablePacket(unparsablePacket);
                                continue;
                            }
                            this.processPacket(iQ);
                        } else if (this.parser.getName().equals("presence")) {
                            Presence presence;
                            try {
                                presence = PacketParserUtils.parsePresence(this.parser);
                            }
                            catch (Exception exception) {
                                string = PacketParserUtils.parseContentDepth(this.parser, n3);
                                unparsablePacket = new UnparsablePacket(string, exception);
                                if (parsingExceptionCallback == null) continue;
                                parsingExceptionCallback.handleUnparsablePacket(unparsablePacket);
                                continue;
                            }
                            this.processPacket(presence);
                        } else if (this.parser.getName().equals("stream")) {
                            if ("jabber:client".equals(this.parser.getNamespace(null))) {
                                int n4 = 0;
                                while (n4 < this.parser.getAttributeCount()) {
                                    if (this.parser.getAttributeName(n4).equals("id")) {
                                        this.connectionID = this.parser.getAttributeValue(n4);
                                        if (!"1.0".equals(this.parser.getAttributeValue("", "version"))) {
                                            this.releaseConnectionIDLock();
                                        }
                                    } else if (this.parser.getAttributeName(n4).equals("from")) {
                                        this.connection.config.setServiceName(this.parser.getAttributeValue(n4));
                                    }
                                    ++n4;
                                }
                            }
                        } else {
                            if (this.parser.getName().equals("error")) {
                                throw new XMPPException(PacketParserUtils.parseStreamError(this.parser));
                            }
                            if (this.parser.getName().equals("features")) {
                                this.parseFeatures(this.parser);
                            } else if (this.parser.getName().equals("proceed")) {
                                this.connection.proceedTLSReceived();
                                this.resetParser();
                            } else if (this.parser.getName().equals("failure")) {
                                String string2 = this.parser.getNamespace(null);
                                if ("urn:ietf:params:xml:ns:xmpp-tls".equals(string2)) {
                                    throw new Exception("TLS negotiation has failed");
                                }
                                if ("http://jabber.org/protocol/compress".equals(string2)) {
                                    this.connection.streamCompressionDenied();
                                } else {
                                    SASLMechanism.Failure failure = PacketParserUtils.parseSASLFailure(this.parser);
                                    this.processPacket(failure);
                                    this.connection.getSASLAuthentication().authenticationFailed();
                                }
                            } else if (this.parser.getName().equals("challenge")) {
                                String string3 = this.parser.nextText();
                                this.processPacket(new SASLMechanism.Challenge(string3));
                                this.connection.getSASLAuthentication().challengeReceived(string3);
                            } else if (this.parser.getName().equals("success")) {
                                this.processPacket(new SASLMechanism.Success(this.parser.nextText()));
                                this.connection.packetWriter.openStream();
                                this.resetParser();
                                this.connection.getSASLAuthentication().authenticated();
                            } else if (this.parser.getName().equals("compressed")) {
                                this.connection.startStreamCompression();
                                this.resetParser();
                            }
                        }
                    } else if (n2 == 3 && this.parser.getName().equals("stream")) {
                        this.connection.disconnect();
                    }
                    n2 = this.parser.next();
                } while (!this.done && n2 != 1 && thread == this.readerThread);
            }
            catch (Exception exception) {
                if (this.done || this.connection.isSocketClosed()) break block41;
                this.connection.notifyConnectionError(exception);
            }
        }
    }

    private synchronized void releaseConnectionIDLock() {
        this.notify();
    }

    private void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        for (PacketCollector packetCollector : this.connection.getPacketCollectors()) {
            packetCollector.processPacket(packet);
        }
        this.listenerExecutor.submit(new ListenerNotification(packet));
    }

    private void parseFeatures(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl3) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (xmlPullParser.getName().equals("starttls")) {
                    bl = true;
                    continue;
                }
                if (xmlPullParser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(PacketParserUtils.parseMechanisms(xmlPullParser));
                    continue;
                }
                if (xmlPullParser.getName().equals("bind")) {
                    this.connection.getSASLAuthentication().bindingRequired();
                    continue;
                }
                if (xmlPullParser.getName().equals("ver")) {
                    this.connection.getConfiguration().setRosterVersioningAvailable(true);
                    continue;
                }
                if (xmlPullParser.getName().equals("c")) {
                    String string = xmlPullParser.getAttributeValue(null, "node");
                    String string2 = xmlPullParser.getAttributeValue(null, "ver");
                    if (string2 == null || string == null) continue;
                    String string3 = String.valueOf(string) + "#" + string2;
                    this.connection.setServiceCapsNode(string3);
                    continue;
                }
                if (xmlPullParser.getName().equals("session")) {
                    this.connection.getSASLAuthentication().sessionsSupported();
                    continue;
                }
                if (xmlPullParser.getName().equals("compression")) {
                    this.connection.setAvailableCompressionMethods(PacketParserUtils.parseCompressionMethods(xmlPullParser));
                    continue;
                }
                if (!xmlPullParser.getName().equals("register")) continue;
                this.connection.getAccountManager().setSupportsAccountCreation(true);
                continue;
            }
            if (n2 != 3) continue;
            if (xmlPullParser.getName().equals("starttls")) {
                this.connection.startTLSReceived(bl2);
                continue;
            }
            if (xmlPullParser.getName().equals("required") && bl) {
                bl2 = true;
                continue;
            }
            if (!xmlPullParser.getName().equals("features")) continue;
            bl3 = true;
        }
        this.featuresAreParsed = true;
        if (!this.connection.isSecureConnection() && !bl && this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
            throw new XMPPException("Server does not support security (TLS), but security required by connection configuration.", new XMPPError(XMPPError.Condition.forbidden));
        }
        if (!bl || this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.releaseConnectionIDLock();
        }
    }

    private class ListenerNotification
    implements Runnable {
        private Packet packet;

        public ListenerNotification(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            for (Connection.ListenerWrapper listenerWrapper : ((PacketReader)PacketReader.this).connection.recvListeners.values()) {
                try {
                    listenerWrapper.notifyListener(this.packet);
                }
                catch (Exception exception) {
                    EMLog.e(PacketReader.TAG, "Exception in packet listener: " + exception);
                    exception.printStackTrace();
                }
            }
        }
    }
}

