/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.collections.ReferenceMap;

public class ChatManager {
    private static String prefix = StringUtils.randomString(5);
    private static long id = 0L;
    private Map<String, Chat> threadChats = Collections.synchronizedMap(new ReferenceMap(0, 2));
    private Map<String, Chat> jidChats = Collections.synchronizedMap(new ReferenceMap(0, 2));
    private Map<String, Chat> baseJidChats = Collections.synchronizedMap(new ReferenceMap(0, 2));
    private Set<ChatManagerListener> chatManagerListeners = new CopyOnWriteArraySet<ChatManagerListener>();
    private Map<PacketInterceptor, PacketFilter> interceptors = new WeakHashMap<PacketInterceptor, PacketFilter>();
    private Connection connection;

    private static synchronized String nextID() {
        return String.valueOf(prefix) + Long.toString(id++);
    }

    ChatManager(Connection connection) {
        this.connection = connection;
        PacketFilter packetFilter = new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                if (!(packet instanceof Message)) {
                    return false;
                }
                Message.Type type = ((Message)packet).getType();
                return type != Message.Type.groupchat && type != Message.Type.notify && type != Message.Type.headline;
            }
        };
        connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Chat chat;
                Message message = (Message)packet;
                if (message.getThread() == null) {
                    chat = ChatManager.this.getUserChat(message.getFrom());
                } else {
                    chat = ChatManager.this.getThreadChat(message.getThread());
                    if (chat == null) {
                        chat = ChatManager.this.getUserChat(message.getFrom());
                    }
                }
                if (chat == null) {
                    chat = ChatManager.this.createChat(message);
                }
                ChatManager.this.deliverMessage(chat, message);
            }
        }, packetFilter);
    }

    public Chat createChat(String string, MessageListener messageListener) {
        String string2;
        while (this.threadChats.get(string2 = ChatManager.nextID()) != null) {
        }
        return this.createChat(string, string2, messageListener);
    }

    public Chat createChat(String string, String string2, MessageListener messageListener) {
        Chat chat;
        if (string2 == null) {
            string2 = ChatManager.nextID();
        }
        if ((chat = this.threadChats.get(string2)) != null) {
            throw new IllegalArgumentException("ThreadID is already used");
        }
        chat = this.createChat(string, string2, true);
        chat.addMessageListener(messageListener);
        return chat;
    }

    private Chat createChat(String string, String string2, boolean bl) {
        Chat chat = new Chat(this, string, string2);
        this.threadChats.put(string2, chat);
        this.jidChats.put(string, chat);
        this.baseJidChats.put(StringUtils.parseBareAddress(string), chat);
        for (ChatManagerListener chatManagerListener : this.chatManagerListeners) {
            chatManagerListener.chatCreated(chat, bl);
        }
        return chat;
    }

    private Chat createChat(Message message) {
        String string = message.getThread();
        if (string == null) {
            string = ChatManager.nextID();
        }
        String string2 = message.getFrom();
        return this.createChat(string2, string, false);
    }

    private Chat getUserChat(String string) {
        Chat chat = this.jidChats.get(string);
        if (chat == null) {
            chat = this.baseJidChats.get(StringUtils.parseBareAddress(string));
        }
        return chat;
    }

    public Chat getThreadChat(String string) {
        return this.threadChats.get(string);
    }

    public void addChatListener(ChatManagerListener chatManagerListener) {
        this.chatManagerListeners.add(chatManagerListener);
    }

    public void removeChatListener(ChatManagerListener chatManagerListener) {
        this.chatManagerListeners.remove(chatManagerListener);
    }

    public Collection<ChatManagerListener> getChatListeners() {
        return Collections.unmodifiableCollection(this.chatManagerListeners);
    }

    private void deliverMessage(Chat chat, Message message) {
        chat.deliver(message);
    }

    void sendMessage(Chat chat, Message message) {
        for (Map.Entry<PacketInterceptor, PacketFilter> entry : this.interceptors.entrySet()) {
            PacketFilter packetFilter = entry.getValue();
            if (packetFilter == null || !packetFilter.accept(message)) continue;
            entry.getKey().interceptPacket(message);
        }
        if (message.getFrom() == null) {
            message.setFrom(this.connection.getUser());
        }
        this.connection.sendPacket(message);
    }

    PacketCollector createPacketCollector(Chat chat) {
        return this.connection.createPacketCollector(new AndFilter(new ThreadFilter(chat.getThreadID()), new FromContainsFilter(chat.getParticipant())));
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor) {
        this.addOutgoingMessageInterceptor(packetInterceptor, null);
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (packetInterceptor != null) {
            this.interceptors.put(packetInterceptor, packetFilter);
        }
    }
}

