/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import android.os.Build;
import java.io.File;
import java.util.List;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.HostAddress;

public class AndroidConnectionConfiguration
extends ConnectionConfiguration {
    private static final int DEFAULT_TIMEOUT = 10000;

    public AndroidConnectionConfiguration(String string) throws XMPPException {
        this.AndroidInit(string, 10000);
    }

    public AndroidConnectionConfiguration(String string, int n2) throws XMPPException {
        this.AndroidInit(string, n2);
    }

    public AndroidConnectionConfiguration(String string, int n2, String string2) {
        super(string, n2, string2);
        this.AndroidInit();
    }

    private void AndroidInit() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.setTruststoreType("AndroidCAStore");
            this.setTruststorePassword(null);
            this.setTruststorePath(null);
        } else {
            this.setTruststoreType("BKS");
            String string = System.getProperty("javax.net.ssl.trustStore");
            if (string == null) {
                string = String.valueOf(System.getProperty("java.home")) + File.separator + "etc" + File.separator + "security" + File.separator + "cacerts.bks";
            }
            this.setTruststorePath(string);
        }
    }

    private void AndroidInit(String string, int n2) throws XMPPException {
        this.AndroidInit();
        class DnsSrvLookupRunnable
        implements Runnable {
            String serviceName;
            List<HostAddress> addresses;

            public DnsSrvLookupRunnable(String string) {
                this.serviceName = string;
            }

            @Override
            public void run() {
                this.addresses = DNSUtil.resolveXMPPDomain(this.serviceName);
            }

            public List<HostAddress> getHostAddresses() {
                return this.addresses;
            }
        }
        DnsSrvLookupRunnable dnsSrvLookupRunnable = new DnsSrvLookupRunnable(string);
        Thread thread = new Thread((Runnable)dnsSrvLookupRunnable, "dns-srv-lookup");
        thread.start();
        try {
            thread.join(n2);
        }
        catch (InterruptedException interruptedException) {
            throw new XMPPException("DNS lookup timeout after " + n2 + "ms", interruptedException);
        }
        this.hostAddresses = dnsSrvLookupRunnable.getHostAddresses();
        if (this.hostAddresses == null) {
            throw new XMPPException("DNS lookup failure");
        }
        ProxyInfo proxyInfo = ProxyInfo.forDefaultProxy();
        this.init(string, proxyInfo);
    }
}

