/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.weupnp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.bitlet.weupnp.GatewayDeviceHandler;
import org.bitlet.weupnp.NameValueHandler;
import org.bitlet.weupnp.PortMappingEntry;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayDevice {
    private String st;
    private String location;
    private String serviceType;
    private String serviceTypeCIF;
    private String urlBase;
    private String controlURL;
    private String controlURLCIF;
    private String eventSubURL;
    private String eventSubURLCIF;
    private String sCPDURL;
    private String sCPDURLCIF;
    private String deviceType;
    private String deviceTypeCIF;
    private String friendlyName;
    private String manufacturer;
    private String modelDescription;
    private String presentationURL;
    private InetAddress localAddress;
    private String modelNumber;
    private String modelName;
    private static final int TIMEOUT = 750;

    public void loadDescription() throws SAXException, IOException {
        URLConnection uRLConnection = new URL(this.getLocation()).openConnection();
        uRLConnection.setReadTimeout(750);
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setContentHandler(new GatewayDeviceHandler(this));
        xMLReader.parse(new InputSource(uRLConnection.getInputStream()));
        String string = this.urlBase != null && this.urlBase.trim().length() > 0 ? this.urlBase : this.location;
        int n2 = string.indexOf(47, 7);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        this.sCPDURL = this.copyOrCatUrl(string, this.sCPDURL);
        this.controlURL = this.copyOrCatUrl(string, this.controlURL);
        this.controlURLCIF = this.copyOrCatUrl(string, this.controlURLCIF);
        this.presentationURL = this.copyOrCatUrl(string, this.presentationURL);
    }

    public static Map<String, String> simpleUPnPcommand(String string, String string2, String string3, Map<String, String> map) throws IOException, SAXException {
        Object object;
        Object object2;
        Object object3;
        String string4 = "\"" + string2 + "#" + string3 + "\"";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>\r\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><m:" + string3 + " xmlns:m=\"" + string2 + "\">");
        if (map != null && map.size() > 0) {
            object3 = map.entrySet();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                stringBuffer.append("<" + object.getKey() + ">" + object.getValue() + "</" + object.getKey() + ">");
            }
        }
        stringBuffer.append("</m:" + string3 + ">");
        stringBuffer.append("</SOAP-ENV:Body></SOAP-ENV:Envelope>");
        object3 = new URL(string);
        object2 = (HttpURLConnection)((URL)object3).openConnection();
        ((HttpURLConnection)object2).setRequestMethod("POST");
        ((URLConnection)object2).setConnectTimeout(1500);
        ((URLConnection)object2).setReadTimeout(1500);
        ((URLConnection)object2).setDoOutput(true);
        ((URLConnection)object2).setRequestProperty("Content-Type", "text/xml");
        ((URLConnection)object2).setRequestProperty("SOAPAction", string4);
        ((URLConnection)object2).setRequestProperty("Connection", "Close");
        object = stringBuffer.toString().getBytes();
        ((URLConnection)object2).setRequestProperty("Content-Length", String.valueOf(((Object)object).length));
        ((URLConnection)object2).getOutputStream().write((byte[])object);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setContentHandler(new NameValueHandler(hashMap));
        if (((HttpURLConnection)object2).getResponseCode() == 500) {
            try {
                xMLReader.parse(new InputSource(((HttpURLConnection)object2).getErrorStream()));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            ((HttpURLConnection)object2).disconnect();
            return hashMap;
        }
        xMLReader.parse(new InputSource(((URLConnection)object2).getInputStream()));
        ((HttpURLConnection)object2).disconnect();
        return hashMap;
    }

    public boolean isConnected() throws IOException, SAXException {
        Map<String, String> map = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetStatusInfo", null);
        String string = map.get("NewConnectionStatus");
        return string != null && string.equalsIgnoreCase("Connected");
    }

    public String getExternalIPAddress() throws IOException, SAXException {
        Map<String, String> map = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetExternalIPAddress", null);
        return map.get("NewExternalIPAddress");
    }

    public boolean addPortMapping(int n2, int n3, String string, String string2, String string3) throws IOException, SAXException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NewRemoteHost", "");
        hashMap.put("NewExternalPort", Integer.toString(n2));
        hashMap.put("NewProtocol", string2);
        hashMap.put("NewInternalPort", Integer.toString(n3));
        hashMap.put("NewInternalClient", string);
        hashMap.put("NewEnabled", Integer.toString(1));
        hashMap.put("NewPortMappingDescription", string3);
        hashMap.put("NewLeaseDuration", Integer.toString(0));
        Map<String, String> map = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "AddPortMapping", hashMap);
        return map.get("errorCode") == null;
    }

    public boolean getSpecificPortMappingEntry(int n2, String string, PortMappingEntry portMappingEntry) throws IOException, SAXException {
        portMappingEntry.setExternalPort(n2);
        portMappingEntry.setProtocol(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NewRemoteHost", "");
        hashMap.put("NewExternalPort", Integer.toString(n2));
        hashMap.put("NewProtocol", string);
        Map<String, String> map = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetSpecificPortMappingEntry", hashMap);
        String string2 = map.get("NewInternalClient");
        String string3 = map.get("NewInternalPort");
        if (string2 != null) {
            portMappingEntry.setInternalClient(string2);
        }
        if (string3 != null) {
            try {
                portMappingEntry.setInternalPort(Integer.parseInt(string3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2 != null && string3 != null;
    }

    public boolean getGenericPortMappingEntry(int n2, PortMappingEntry portMappingEntry) throws IOException, SAXException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NewPortMappingIndex", Integer.toString(n2));
        Map<String, String> map = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetGenericPortMappingEntry", hashMap);
        try {
            portMappingEntry.setExternalPort(Integer.parseInt(map.get("NewExternalPort")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        portMappingEntry.setRemoteHost(map.get("NewRemoteHost"));
        portMappingEntry.setInternalClient(map.get("NewInternalClient"));
        portMappingEntry.setProtocol(map.get("NewProtocol"));
        try {
            portMappingEntry.setInternalPort(Integer.parseInt(map.get("NewInternalPort")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        portMappingEntry.setEnabled(map.get("NewEnabled"));
        portMappingEntry.setPortMappingDescription(map.get("NewPortMappingDescription"));
        return map.get("errorCode") == null;
    }

    public Integer getPortMappingNumberOfEntries() throws IOException, SAXException {
        Map<String, String> map = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetPortMappingNumberOfEntries", null);
        Integer n2 = null;
        try {
            n2 = Integer.valueOf(map.get("NewPortMappingNumberOfEntries"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public boolean deletePortMapping(int n2, String string) throws IOException, SAXException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NewRemoteHost", "");
        hashMap.put("NewExternalPort", Integer.toString(n2));
        hashMap.put("NewProtocol", string);
        Map<String, String> map = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "DeletePortMapping", hashMap);
        return true;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
    }

    public String getSt() {
        return this.st;
    }

    public void setSt(String string) {
        this.st = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String string) {
        this.serviceType = string;
    }

    public String getServiceTypeCIF() {
        return this.serviceTypeCIF;
    }

    public void setServiceTypeCIF(String string) {
        this.serviceTypeCIF = string;
    }

    public String getControlURL() {
        return this.controlURL;
    }

    public void setControlURL(String string) {
        this.controlURL = string;
    }

    public String getControlURLCIF() {
        return this.controlURLCIF;
    }

    public void setControlURLCIF(String string) {
        this.controlURLCIF = string;
    }

    public String getEventSubURL() {
        return this.eventSubURL;
    }

    public void setEventSubURL(String string) {
        this.eventSubURL = string;
    }

    public String getEventSubURLCIF() {
        return this.eventSubURLCIF;
    }

    public void setEventSubURLCIF(String string) {
        this.eventSubURLCIF = string;
    }

    public String getSCPDURL() {
        return this.sCPDURL;
    }

    public void setSCPDURL(String string) {
        this.sCPDURL = string;
    }

    public String getSCPDURLCIF() {
        return this.sCPDURLCIF;
    }

    public void setSCPDURLCIF(String string) {
        this.sCPDURLCIF = string;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String string) {
        this.deviceType = string;
    }

    public String getDeviceTypeCIF() {
        return this.deviceTypeCIF;
    }

    public void setDeviceTypeCIF(String string) {
        this.deviceTypeCIF = string;
    }

    public String getURLBase() {
        return this.urlBase;
    }

    public void setURLBase(String string) {
        this.urlBase = string;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String string) {
        this.friendlyName = string;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String string) {
        this.manufacturer = string;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public void setModelDescription(String string) {
        this.modelDescription = string;
    }

    public String getPresentationURL() {
        return this.presentationURL;
    }

    public void setPresentationURL(String string) {
        this.presentationURL = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(String string) {
        this.modelNumber = string;
    }

    private String copyOrCatUrl(String string, String string2) {
        if (string2 != null) {
            if (string2.startsWith("http://")) {
                string = string2;
            } else {
                if (!string2.startsWith("/")) {
                    string = string + "/";
                }
                string = string + string2;
            }
        }
        return string;
    }
}

