/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common.sasl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.NameCallback;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.harmony.javax.security.sasl.SaslClient;
import org.apache.harmony.javax.security.sasl.SaslException;

public class PlainSaslClient
implements SaslClient {
    private boolean completed = false;
    private CallbackHandler cbh;
    private String authorizationID;
    private String authenticationID;
    private byte[] password;
    private static byte SEPARATOR = 0;

    public PlainSaslClient(String string, CallbackHandler callbackHandler) throws SaslException {
        this.cbh = callbackHandler;
        Object[] objectArray = this.getUserInfo();
        this.authorizationID = string;
        this.authenticationID = (String)objectArray[0];
        this.password = (byte[])objectArray[1];
        if (this.authenticationID == null || this.password == null) {
            throw new SaslException("PLAIN: authenticationID and password must be specified");
        }
    }

    @Override
    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN: authentication already completed");
        }
        this.completed = true;
        try {
            byte[] byArray2 = this.authorizationID == null ? null : this.authorizationID.getBytes("UTF8");
            byte[] byArray3 = this.authenticationID.getBytes("UTF8");
            byte[] byArray4 = new byte[this.password.length + byArray3.length + 2 + (byArray2 != null ? byArray2.length : 0)];
            int n2 = 0;
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                n2 = byArray2.length;
            }
            byArray4[n2++] = SEPARATOR;
            System.arraycopy(byArray3, 0, byArray4, n2, byArray3.length);
            n2 += byArray3.length;
            byArray4[n2++] = SEPARATOR;
            System.arraycopy(this.password, 0, byArray4, n2, this.password.length);
            this.clearPassword();
            return byArray4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("PLAIN: Cannot get UTF-8 encoding of ids", unsupportedEncodingException);
        }
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN: this mechanism supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN: authentication not completed");
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN: this mechanism supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN: authentication not completed");
    }

    @Override
    public Object getNegotiatedProperty(String string) {
        if (this.completed) {
            if (string.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("PLAIN: authentication not completed");
    }

    private void clearPassword() {
        if (this.password != null) {
            int n2 = 0;
            while (n2 < this.password.length) {
                this.password[n2] = 0;
                ++n2;
            }
            this.password = null;
        }
    }

    @Override
    public void dispose() throws SaslException {
        this.clearPassword();
    }

    protected void finalize() {
        this.clearPassword();
    }

    private Object[] getUserInfo() throws SaslException {
        try {
            byte[] byArray;
            String string = "PLAIN authentication id: ";
            String string2 = "PLAIN password: ";
            NameCallback nameCallback = new NameCallback("PLAIN authentication id: ");
            PasswordCallback passwordCallback = new PasswordCallback("PLAIN password: ", false);
            this.cbh.handle(new Callback[]{nameCallback, passwordCallback});
            String string3 = nameCallback.getName();
            char[] cArray = passwordCallback.getPassword();
            if (cArray != null) {
                byArray = new String(cArray).getBytes("UTF8");
                passwordCallback.clearPassword();
            } else {
                byArray = null;
            }
            return new Object[]{string3, byArray};
        }
        catch (IOException iOException) {
            throw new SaslException("Cannot get password", iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("Cannot get userid/password", unsupportedCallbackException);
        }
    }
}

