/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.sasl;

import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.sasl.SaslClient;
import org.apache.harmony.javax.security.sasl.SaslClientFactory;
import org.apache.harmony.javax.security.sasl.SaslException;
import org.apache.harmony.javax.security.sasl.SaslServer;
import org.apache.harmony.javax.security.sasl.SaslServerFactory;

public class Sasl {
    private static final String CLIENTFACTORYSRV = "SaslClientFactory";
    private static final String SERVERFACTORYSRV = "SaslServerFactory";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    public static final String REUSE = "javax.security.sasl.reuse";
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";

    private Sasl() {
    }

    private static Object newInstance(String string, Provider provider) throws SaslException {
        String string2 = "auth.31";
        ClassLoader classLoader = provider.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            Object obj = Class.forName(string, true, classLoader).newInstance();
            return obj;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SaslException(String.valueOf(string2) + string, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SaslException(String.valueOf(string2) + string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new SaslException(String.valueOf(string2) + string, instantiationException);
        }
    }

    private static Collection<?> findFactories(String string) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Provider[] providerArray = Security.getProviders();
        if (providerArray == null || providerArray.length == 0) {
            return hashSet;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        int n2 = 0;
        while (n2 < providerArray.length) {
            String string2 = providerArray[n2].getName();
            Enumeration<Object> enumeration = providerArray[n2].keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string3.startsWith(string)) continue;
                String string4 = providerArray[n2].getProperty(string3);
                try {
                    if (!hashSet2.add(string2.concat(string4))) continue;
                    hashSet.add(Sasl.newInstance(string4, providerArray[n2]));
                }
                catch (SaslException saslException) {
                    saslException.printStackTrace();
                }
            }
            ++n2;
        }
        return hashSet;
    }

    public static Enumeration<SaslClientFactory> getSaslClientFactories() {
        Collection<?> collection = Sasl.findFactories(CLIENTFACTORYSRV);
        return Collections.enumeration(collection);
    }

    public static Enumeration<SaslServerFactory> getSaslServerFactories() {
        Collection<?> collection = Sasl.findFactories(SERVERFACTORYSRV);
        return Collections.enumeration(collection);
    }

    public static SaslServer createSaslServer(String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        if (string == null) {
            throw new NullPointerException("auth.32");
        }
        Collection<SaslServerFactory> collection = Sasl.findFactories(SERVERFACTORYSRV);
        if (collection.isEmpty()) {
            return null;
        }
        for (SaslServerFactory saslServerFactory : collection) {
            SaslServer saslServer;
            String[] stringArray = saslServerFactory.getMechanismNames(null);
            boolean bl = false;
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl || (saslServer = saslServerFactory.createSaslServer(string, string2, string3, map, callbackHandler)) == null) continue;
            return saslServer;
        }
        return null;
    }

    public static SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        if (stringArray == null) {
            throw new NullPointerException("auth.33");
        }
        Collection<SaslClientFactory> collection = Sasl.findFactories(CLIENTFACTORYSRV);
        if (collection.isEmpty()) {
            return null;
        }
        for (SaslClientFactory saslClientFactory : collection) {
            SaslClient saslClient;
            String[] stringArray2 = saslClientFactory.getMechanismNames(null);
            boolean bl = false;
            if (stringArray2 != null) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (stringArray2[n2].equals(stringArray[n3])) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            if (!bl || (saslClient = saslClientFactory.createSaslClient(stringArray, string, string2, string3, map, callbackHandler)) == null) continue;
            return saslClient;
        }
        return null;
    }
}

